/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.io.Serializable;
import oracle.toplink.essentials.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.essentials.internal.expressions.SQLSelectStatement;

public class ForUpdateClause
implements Serializable,
Cloneable {
    protected static final ForUpdateClause NO_LOCK_CLAUSE = new ForUpdateClause();
    short lockMode;

    public ForUpdateClause() {
        this.lockMode = 0;
    }

    public ForUpdateClause(short lockMode) {
        this.lockMode = lockMode;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException never) {
            return null;
        }
    }

    public static ForUpdateClause newInstance(short lockMode) {
        if (lockMode == 0) {
            return NO_LOCK_CLAUSE;
        }
        return new ForUpdateClause(lockMode);
    }

    public boolean isForUpdateOfClause() {
        return false;
    }

    public boolean isReferenceClassLocked() {
        return true;
    }

    public short getLockMode() {
        return this.lockMode;
    }

    public void printSQL(ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        if (this.getLockMode() == 1) {
            printer.printString(printer.getSession().getPlatform().getSelectForUpdateString());
        } else if (this.lockMode == 2) {
            printer.printString(printer.getSession().getPlatform().getSelectForUpdateString());
            printer.printString(printer.getSession().getPlatform().getSelectForUpdateNoWaitString());
        }
    }
}

