/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.threetier;

import java.util.Enumeration;
import oracle.toplink.essentials.exceptions.ConcurrencyException;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.internal.databaseaccess.Accessor;
import oracle.toplink.essentials.sessions.Login;
import oracle.toplink.essentials.threetier.ConnectionPool;
import oracle.toplink.essentials.threetier.ServerSession;

public class ReadConnectionPool
extends ConnectionPool {
    public ReadConnectionPool() {
    }

    public ReadConnectionPool(String name, Login login, int minNumberOfConnections, int maxNumberOfConnections, ServerSession owner) {
        super(name, login, minNumberOfConnections, maxNumberOfConnections, owner);
    }

    public synchronized Accessor acquireConnection() throws ConcurrencyException {
        Accessor leastBusyConnection = null;
        Enumeration connectionsEnum = this.getConnectionsAvailable().elements();
        while (connectionsEnum.hasMoreElements()) {
            Accessor connection = (Accessor)connectionsEnum.nextElement();
            if (connection.getCallCount() == 0) {
                connection.incrementCallCount(this.getOwner());
                return connection;
            }
            if (leastBusyConnection != null && leastBusyConnection.getCallCount() <= connection.getCallCount()) continue;
            leastBusyConnection = connection;
        }
        if (this.getTotalNumberOfConnections() < this.getMaxNumberOfConnections()) {
            Accessor connection = this.buildConnection();
            this.getConnectionsAvailable().addElement(connection);
            connection.incrementCallCount(this.getOwner());
            return connection;
        }
        leastBusyConnection.incrementCallCount(this.getOwner());
        return leastBusyConnection;
    }

    public boolean hasConnectionAvailable() {
        return true;
    }

    public synchronized void releaseConnection(Accessor connection) throws DatabaseException {
        connection.decrementCallCount();
    }
}

