/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra;

import com.sun.genericra.GenericJMSRAProperties;
import com.sun.genericra.inbound.ActivationSpec;
import com.sun.genericra.inbound.EndpointConsumer;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import com.sun.genericra.util.ObjectBuilderFactory;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.resource.ResourceException;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;

public class GenericJMSRA
extends GenericJMSRAProperties
implements ResourceAdapter {
    private transient BootstrapContext context = null;
    private transient Hashtable consumers;
    private transient Method onMessageMethod = null;
    private transient ObjectBuilderFactory obf = null;
    private static GenericJMSRA raInstance = null;
    private String logLevel = "info";
    private static Logger logger = LogUtils.getLogger();

    public static GenericJMSRA getInstance() {
        logger.log(Level.FINEST, "GenericJMSRA - getInstance() orig " + raInstance);
        return raInstance;
    }

    public void stop() {
        this.obf = null;
        this.onMessageMethod = null;
    }

    public void start(BootstrapContext context) throws ResourceAdapterInternalException {
        logger.log(Level.FINEST, "GenericJMSRA.start() ....");
        raInstance = this;
        this.obf = new ObjectBuilderFactory();
        this.consumers = new Hashtable();
        this.context = context;
        try {
            Class msgListenerClass = MessageListener.class;
            Class[] paramTypes = new Class[]{Message.class};
            this.onMessageMethod = msgListenerClass.getMethod("onMessage", paramTypes);
        }
        catch (NoSuchMethodException ex) {
            throw ExceptionUtils.newResourceAdapterInternalException(ex);
        }
    }

    public void endpointActivation(MessageEndpointFactory mef, javax.resource.spi.ActivationSpec spec) throws ResourceException {
        EndpointConsumer consumer = new EndpointConsumer(mef, spec);
        consumer.start();
        Hashtable consumers = this.getConsumers();
        EndpointKey key = new EndpointKey(mef, spec);
        consumers.put(key, consumer);
    }

    public void endpointDeactivation(MessageEndpointFactory mef, javax.resource.spi.ActivationSpec spec) {
        EndpointKey key = new EndpointKey(mef, spec);
        EndpointConsumer consumer = (EndpointConsumer)this.getConsumers().remove(key);
        if (consumer != null) {
            consumer.stop();
        }
    }

    public XAResource[] getXAResources(javax.resource.spi.ActivationSpec[] specs) throws ResourceException {
        ArrayList<XAResource> xars = new ArrayList<XAResource>();
        for (int i = 0; i < specs.length; ++i) {
            ActivationSpec tmpSpec = null;
            if (!(specs[i] instanceof ActivationSpec) || !(tmpSpec = (ActivationSpec)specs[i]).getSupportsXA()) continue;
            XAConnection xacon = null;
            XASession xasess = null;
            EndpointConsumer consumer = null;
            try {
                consumer = new EndpointConsumer(tmpSpec);
                consumer.initialize(true);
                xacon = (XAConnection)consumer.getConnection();
                xasess = xacon.createXASession();
                XAResource xaRes = xasess.getXAResource();
                xars.add(xaRes);
                logger.log(Level.FINEST, "Added XA Resource : " + xaRes);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return (XAResource[])xars.toArray();
    }

    public WorkManager getWorkManager() {
        return GenericJMSRA.getInstance().context.getWorkManager();
    }

    public ObjectBuilderFactory getObjectBuilderFactory() {
        return GenericJMSRA.getInstance().obf;
    }

    public void setLogLevel(String level) {
        logger.log(Level.FINEST, "Setting log level:" + level);
        this.logLevel = level;
        this.setLevelInLogger(level);
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    private Hashtable getConsumers() {
        return GenericJMSRA.getInstance().consumers;
    }

    private void setLevelInLogger(String level) {
        Level l = Level.INFO;
        if (level.equalsIgnoreCase("finest")) {
            logger.log(Level.FINEST, "Setting finest as log levels");
            l = Level.FINEST;
        } else if (level.equalsIgnoreCase("finer")) {
            l = Level.FINER;
        } else if (level.equalsIgnoreCase("fine")) {
            l = Level.FINE;
        } else if (level.equalsIgnoreCase("info")) {
            l = Level.INFO;
        } else if (level.equalsIgnoreCase("warning")) {
            l = Level.WARNING;
        } else if (level.equalsIgnoreCase("severe")) {
            l = Level.SEVERE;
        }
        final Level tmp = l;
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                logger.setLevel(tmp);
                return null;
            }
        });
    }

    public Method getListeningMethod() {
        return GenericJMSRA.getInstance().onMessageMethod;
    }

    class EndpointKey
    implements Serializable {
        private MessageEndpointFactory mef;
        private javax.resource.spi.ActivationSpec spec;

        public EndpointKey(MessageEndpointFactory mef, javax.resource.spi.ActivationSpec spec) {
            this.mef = mef;
            this.spec = spec;
        }

        public boolean equals(Object obj) {
            EndpointKey other = (EndpointKey)obj;
            return other.mef.equals(this.mef) && other.spec.equals(this.spec);
        }

        public int hashCode() {
            return this.mef.hashCode() + this.spec.hashCode();
        }
    }
}

