/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.inbound;

import com.sun.genericra.GenericJMSRA;
import com.sun.genericra.inbound.DeliveryHelper;
import com.sun.genericra.inbound.InboundJmsResourcePool;
import com.sun.genericra.inbound.MessageListener;
import com.sun.genericra.inbound.WorkImpl;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.Session;
import javax.jms.XASession;
import javax.resource.ResourceException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.XAResource;

public class InboundJmsResource
implements ServerSession {
    private Session session;
    private XAResource xaresource;
    private MessageEndpoint endPoint;
    private boolean free;
    private GenericJMSRA ra;
    private InboundJmsResourcePool pool;
    private DeliveryHelper helper;
    private static Logger _logger = LogUtils.getLogger();

    public InboundJmsResource(Session session, InboundJmsResourcePool pool) throws JMSException {
        this(session, pool, null);
    }

    public InboundJmsResource(Session session, InboundJmsResourcePool pool, XAResource xaresource) throws JMSException {
        this.session = session;
        this.xaresource = xaresource;
        this.pool = pool;
        this.ra = (GenericJMSRA)pool.getConsumer().getResourceAdapter();
    }

    public void start() throws JMSException {
        try {
            _logger.log(Level.FINER, "Provider is starting the message consumtion");
            WorkImpl w = new WorkImpl(this);
            WorkManager wm = this.ra.getWorkManager();
            wm.scheduleWork((Work)w);
        }
        catch (WorkException e) {
            throw ExceptionUtils.newJMSException(e);
        }
    }

    public InboundJmsResource refreshListener() throws JMSException {
        MessageListener listener = new MessageListener(this, this.pool);
        this.session.setMessageListener((javax.jms.MessageListener)listener);
        this.helper = new DeliveryHelper(this, this.pool);
        return this;
    }

    public void destroy() {
        block3: {
            if (this.session != null) {
                try {
                    this.session.close();
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.FINE)) break block3;
                    _logger.log(Level.FINE, e.getMessage(), e);
                }
            }
        }
        this.releaseEndpoint();
    }

    public boolean isFree() {
        return this.free;
    }

    public InboundJmsResource markAsBusy() {
        this.free = false;
        return this;
    }

    public InboundJmsResource markAsFree() {
        this.free = true;
        return this;
    }

    public DeliveryHelper getDeliveryHelper() {
        return this.helper;
    }

    public XAResource getXAResource() {
        return this.xaresource;
    }

    public Session getSession() {
        _logger.log(Level.FINEST, "Message provider got the session :" + this.session);
        return this.session;
    }

    public InboundJmsResourcePool getPool() {
        return this.pool;
    }

    public XASession getXASession() {
        return (XASession)this.session;
    }

    public MessageEndpoint getEndpoint() {
        return this.endPoint;
    }

    public void release() {
        this.getPool().put(this);
    }

    public void refresh() throws JMSException {
        MessageEndpointFactory mef = this.pool.getConsumer().getMessageEndpointFactory();
        try {
            _logger.log(Level.FINER, "Creating message endpoint : " + this.xaresource);
            this.endPoint = mef.createEndpoint(this.helper.getXAResource());
            this.endPoint.beforeDelivery(this.ra.getListeningMethod());
            _logger.log(Level.FINE, "Binod.IN: Created endpoint : ");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEndpoint() {
        try {
            if (this.endPoint != null) {
                this.endPoint.afterDelivery();
            }
        }
        catch (ResourceException re) {
            _logger.log(Level.WARNING, "" + re.getMessage(), re);
        }
        finally {
            if (this.endPoint != null) {
                this.endPoint.release();
                _logger.log(Level.FINE, "Binod.OUT: released endpoint : ");
                this.endPoint = null;
            }
        }
    }
}

