/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.common;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCServerInterface;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.xml.sax.EntityResolver;

public class CCSystem {
    static String DEFAULT_SERVER_IMPL_CLASS = "com.sun.web.console.ui.CCServerImpl";
    static String RESOURCE_CONTEXT_PATH = "com_sun_web_ui";
    static String CONSOLE_SECUREPORT = System.getProperty("com.sun.web.console.secureport");
    static String CONSOLE_UNSECUREPORT = System.getProperty("com.sun.web.console.unsecureport");
    static String CONSOLE_UNSECUREHOST = System.getProperty("com.sun.web.console.unsecurehost");
    static boolean HELP_SECURE = false;
    static EntityResolver MODEL_ENTITY_RESOLVER = null;
    public static final String SERVER_IMPL_CLASS_NAME = "com_sun_web_ui_serverimpl";
    public static final String URL_SEPARATOR = "/";
    public static final String CONSOLE_APPBASE = System.getProperty("com.sun.web.console.appbase");
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final String FILE_PRODNAME = "/com_sun_web_ui/images/ProductName.properties";
    private static final String SPLIT_PROBE_PATH = "/com_sun_web_ui/dtd/descriptor.dtd";
    private static final String ATTR_PRODNAME = "com.sun.web.ui.prodname.";
    private static final String PROP_PRODNAME_PRIMARY = "primary.";
    private static final String PROP_PRODNAME_SECONDARY = "secondary.";
    private static final String PROP_PRODNAME_VERSION = "version.";
    private static final String PROP_PRODNAME_URI = "uri";
    private static final String PROP_PRODNAME_HEIGHT = "height";
    private static final String PROP_PRODNAME_WIDTH = "width";
    private static String JSP_URL_PREFIX = "/com_sun_web_ui";
    private static final String HTTP_PROTOCOL = "http://";
    private static final String LOCAL_HOST = "localhost";
    private static final String LOOPBACK_ADDRESS = "127.0.0.1";
    private static String hostName = null;
    private static String httpPrefix = null;
    private static Object osync = new Object();
    private static CCServerInterface serverImpl = null;

    public static String getResourceContextPath() {
        String rcPath;
        block5: {
            rcPath = null;
            if (!CCSystem.isAppInConsole()) {
                try {
                    RequestContext reqContext = RequestManager.getRequestContext();
                    ServletContext context = reqContext.getServletContext();
                    URL url = context.getResource(SPLIT_PROBE_PATH);
                    if (url != null) {
                        rcPath = reqContext.getRequest().getContextPath() + URL_SEPARATOR + RESOURCE_CONTEXT_PATH;
                        break block5;
                    }
                    rcPath = URL_SEPARATOR + RESOURCE_CONTEXT_PATH;
                }
                catch (Exception e) {
                    rcPath = URL_SEPARATOR + RESOURCE_CONTEXT_PATH;
                }
            } else {
                rcPath = serverImpl.getResourceContextPath();
            }
        }
        CCDebug.trace3("RCPATH : " + rcPath);
        return rcPath;
    }

    public static String getSecurePort() {
        return CONSOLE_SECUREPORT;
    }

    public static String getUnsecurePort() {
        return CONSOLE_UNSECUREPORT;
    }

    public static String getUnsecureServerName() {
        return CONSOLE_UNSECUREHOST;
    }

    public static boolean isHelpSecure() {
        return HELP_SECURE;
    }

    public static int getVersion() {
        return 300;
    }

    public static EntityResolver getEntityResolver() {
        return MODEL_ENTITY_RESOLVER;
    }

    public static CCServerInterface getServerInterface() {
        return serverImpl;
    }

    public static boolean isAppInConsole() {
        return serverImpl != null;
    }

    public static String getURLPrefix() {
        return JSP_URL_PREFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getResourceImage(String imageSource) {
        BufferedImage image = null;
        if (imageSource == null) {
            return image;
        }
        RequestContext reqContext = RequestManager.getRequestContext();
        ServletContext context = reqContext.getServletContext();
        InputStream is = null;
        is = context.getResourceAsStream(URL_SEPARATOR + imageSource);
        if (is != null) {
            try {
                image = ImageIO.read(is);
            }
            catch (Exception e) {
                CCDebug.trace1("Could not read image from inputstream", e);
            }
        } else {
            Object e = osync;
            synchronized (e) {
                if (hostName == null) {
                    hostName = CCSystem.getUnsecureServerName();
                    if (hostName == null || hostName.length() == 0) {
                        try {
                            hostName = reqContext.getRequest().getServerName();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (hostName == null) {
                        try {
                            hostName = InetAddress.getLocalHost().getHostName();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (hostName == null) {
                        hostName = LOCAL_HOST;
                    }
                    httpPrefix = HTTP_PROTOCOL + hostName + ":" + CCSystem.getUnsecurePort();
                }
            }
            try {
                image = ImageIO.read(new URL(httpPrefix + imageSource));
            }
            catch (Exception ex) {
                CCDebug.trace1("Error loading image " + httpPrefix + imageSource + ": " + ex.getMessage());
                image = null;
            }
        }
        return image;
    }

    public static String[] getProductNameImage(String type, String src, String height, String width) {
        ServletContext context = null;
        String path = null;
        RequestContext reqContext = RequestManager.getRequestContext();
        if (reqContext != null) {
            try {
                HttpServletRequest request = reqContext.getRequest();
                if (request != null) {
                    path = request.getContextPath();
                    context = request.getSession().getServletContext();
                }
            }
            catch (Exception e) {
                context = null;
            }
        }
        if (context == null) {
            CCDebug.trace1("get product name called outside request");
            String[] result = new String[]{src, height, width};
            return result;
        }
        Properties props = new Properties();
        String attrname = null;
        attrname = path != null && path.length() > 1 ? ATTR_PRODNAME + path.substring(1) : ATTR_PRODNAME;
        try {
            props = (Properties)context.getAttribute(attrname);
            if (props == null) {
                props = new Properties();
                InputStream is = context.getResourceAsStream(FILE_PRODNAME);
                if (is != null) {
                    props.load(is);
                    is.close();
                }
                context.setAttribute(attrname, (Object)props);
            }
        }
        catch (Exception ex) {
            CCDebug.trace1("Error reading product name properties: " + ex.getMessage());
            props = new Properties();
        }
        String val = src;
        String ht = height;
        String wd = width;
        try {
            String tmp;
            String key = null;
            if (type.equalsIgnoreCase("primary")) {
                key = PROP_PRODNAME_PRIMARY;
            } else if (type.equalsIgnoreCase("secondary")) {
                key = PROP_PRODNAME_SECONDARY;
            } else if (type.equalsIgnoreCase("version")) {
                key = PROP_PRODNAME_VERSION;
            }
            if (key != null && (tmp = props.getProperty(key + PROP_PRODNAME_URI)) != null) {
                val = path + tmp;
                ht = props.getProperty(key + PROP_PRODNAME_HEIGHT);
                wd = props.getProperty(key + PROP_PRODNAME_WIDTH);
            }
        }
        catch (Exception ex) {
            CCDebug.trace3("Error obtaining buffered image: " + ex.getMessage());
        }
        String[] result = new String[]{val, ht, wd};
        return result;
    }

    public static String getHelpUrlHeader(HttpServletRequest request) {
        String port;
        String host;
        String scheme;
        String hdr = "";
        if (HELP_SECURE) {
            scheme = "https";
            host = CONSOLE_UNSECUREHOST;
            port = CONSOLE_SECUREPORT;
        } else {
            scheme = "http";
            host = CONSOLE_UNSECUREHOST;
            port = CONSOLE_UNSECUREPORT;
        }
        if (host == null || host.length() == 0) {
            host = LOOPBACK_ADDRESS;
        }
        if (port == null || port.length() == 0) {
            CCDebug.trace1("Help port not set, using request header");
            if (request != null) {
                scheme = request.getScheme();
                host = request.getServerName();
                port = String.valueOf(request.getServerPort());
            } else {
                CCDebug.trace1("No help url header, request is null");
            }
        }
        if (port != null && port.length() > 0) {
            hdr = scheme + "://" + host + ":" + port;
        }
        return hdr;
    }

    private CCSystem() {
    }

    static void setSecurePort(int port) {
        CONSOLE_SECUREPORT = String.valueOf(port);
    }

    static void setUnsecurePort(int port) {
        CONSOLE_UNSECUREPORT = String.valueOf(port);
    }

    static void setUnsecureServerName(String name) {
        CONSOLE_UNSECUREHOST = name;
    }

    static void setResourceContextPath(String path) {
        RESOURCE_CONTEXT_PATH = path;
    }

    static void setEntityResolver(EntityResolver resolver) {
        MODEL_ENTITY_RESOLVER = resolver;
    }

    static void setSecureHelp(boolean bSecure) {
        HELP_SECURE = bSecure;
    }

    static {
        try {
            serverImpl = (CCServerInterface)Class.forName(DEFAULT_SERVER_IMPL_CLASS).newInstance();
        }
        catch (ClassNotFoundException e) {
            CCDebug.trace1("could not find console implementation of CCServerInterface");
            serverImpl = null;
        }
        catch (Exception e) {
            CCDebug.trace1("could not instantiate console implementation of CCServerInterface", e);
            serverImpl = null;
        }
    }
}

