/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.view.datetime;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.TextField;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.common.CCStateData;
import com.sun.web.ui.model.CCDateTimeModelInterface;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.datetime.CCDateTimeBase;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHref;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;

public class CCDateTime
extends CCDateTimeBase
implements CCStateData {
    public static final String DEFAULT_HREF = "defaultHref";
    public static final String DECREASE_BUTTON = "decrease";
    public static final String INCREASE_BUTTON = "increase";
    public static final String MONTH_COMBO = "monthMenu";
    public static final String YEAR_COMBO = "yearMenu";
    public static final String START_DATE_TEXT = "startDate";
    public static final String REPEAT_INTERVAL_COMBO = "repeatIntervalMenu";
    public static final String START_HOUR_COMBO = "startHour";
    public static final String START_MINUTE_COMBO = "startMinute";
    public static final String END_HOUR_COMBO = "endHour";
    public static final String END_MINUTE_COMBO = "endMinute";
    public static final String REPEAT_LIMITUNIT_COMBO = "repeatLimitUnit";
    public static final String REPEAT_LIMITPERIOD_TEXT = "repeatLimitPeriod";
    public static final String REPEAT_INTERVAL_HREF = "repeatIntervalHref";
    public static final String CHILD_PREVIEW_BUTTON = "previewButton";
    public static final String CHILD_ALERT = "Alert";
    public static final String CHILD_DATE_HREF = "DateHREF";
    public static final String MONTH_PREFIX = "month";
    public static final String INPUT_ERROR_DATE = "datetime.dateError";
    public static final String INPUT_ERROR_TIME = "datetime.timeError";
    public static final String INPUT_ERROR_LIMIT = "datetime.limitError";
    private final String STATE_DATA = this.getQualifiedName() + ".stateData";
    private final String INTERVAL_CHANGE = this.getQualifiedName() + ".intervalChanged";
    private final String PREVIEW_CLICKED = this.getQualifiedName() + ".previewClicked";
    private final int DEFAULT_REPEAT_INTERVAL_INDEX = 0;
    private final String START_DATE = "startDateKey";
    private final String END_DATE = "endDateKey";
    private final String REPEAT_INTERVAL = "repeatIntervalKey";
    private final String REPEAT_LIMITUNIT = "repeatLimitUnitKey";
    private final String REPEAT_LIMITPERIOD = "repeatLimitPeriodKey";
    private String[] monthLabels;
    private int currentYear;
    private int startYear = -1;
    private int endYear = -1;
    private int yearsInCalendar = 10;
    private final int MONTHS_ONE_YEAR = 12;
    private final int MINUTE_INCREASING = 5;
    private final int MINUTES_ONE_HOUR = 60;
    private final int HOURS_ONE_DAY = 24;
    private final int DAYS_ONE_WEEK = 7;
    private final int MS_ONE_MINUTE = 60000;

    public CCDateTime(ContainerView parent, CCDateTimeModelInterface model, String name) {
        super(parent, model, name);
        String[] months = this.dateFormat.getDateFormatSymbols().getMonths();
        if (months[12].trim().length() == 0) {
            this.monthLabels = new String[12];
            for (int i = 0; i < 12; ++i) {
                this.monthLabels[i] = months[i];
            }
        } else {
            this.monthLabels = months;
        }
        Calendar c = this.getCalendar();
        this.currentYear = c.get(1);
        if (model.getStartDateTime() != null) {
            c.setTime(model.getStartDateTime());
        }
        this.startYear = model.getStartYear() != -1 ? model.getStartYear() : c.get(1);
        if (model.getEndYear() != -1) {
            this.endYear = model.getEndYear();
        }
        if (this.endYear == -1) {
            if (this.startYear < this.currentYear) {
                this.yearsInCalendar = this.currentYear - this.startYear + 10;
            }
        } else if (this.startYear < this.endYear) {
            this.yearsInCalendar = this.endYear - this.startYear + 1;
        }
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(DECREASE_BUTTON, CCButton.class);
        this.registerChild(INCREASE_BUTTON, CCButton.class);
        this.registerChild(MONTH_COMBO, CCDropDownMenu.class);
        this.registerChild(YEAR_COMBO, CCDropDownMenu.class);
        this.registerChild(START_DATE_TEXT, TextField.class);
        this.registerChild(START_HOUR_COMBO, CCDropDownMenu.class);
        this.registerChild(START_MINUTE_COMBO, CCDropDownMenu.class);
        this.registerChild(END_HOUR_COMBO, CCDropDownMenu.class);
        this.registerChild(END_MINUTE_COMBO, CCDropDownMenu.class);
        this.registerChild(REPEAT_INTERVAL_COMBO, CCDropDownMenu.class);
        this.registerChild(REPEAT_LIMITUNIT_COMBO, CCDropDownMenu.class);
        this.registerChild(REPEAT_LIMITPERIOD_TEXT, TextField.class);
        this.registerChild(DEFAULT_HREF, CCHref.class);
        this.registerChild(REPEAT_INTERVAL_HREF, CCHref.class);
        this.registerChild(CHILD_ALERT, CCAlertInline.class);
        this.registerChild(CHILD_PREVIEW_BUTTON, CCButton.class);
        this.registerChild(CHILD_DATE_HREF, CCHref.class);
    }

    protected View createChild(String name) {
        if (name.equals(DECREASE_BUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, null);
            child.setType("icon");
            child.setSrc(CCImage.DATETIME_BACKWARD);
            child.setAlt("datetime.backward");
            return child;
        }
        if (name.equals(INCREASE_BUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, null);
            child.setType("icon");
            child.setSrc(CCImage.DATETIME_FORWARD);
            child.setAlt("datetime.forward");
            return child;
        }
        if (name.equals(MONTH_COMBO)) {
            CCDropDownMenu child = new CCDropDownMenu((ContainerView)this, name, null);
            String[] values = new String[this.monthLabels.length];
            for (int i = 0; i < this.monthLabels.length; ++i) {
                values[i] = MONTH_PREFIX + i;
            }
            OptionList optionList = new OptionList(this.monthLabels, values);
            child.setOptions(optionList);
            return child;
        }
        if (name.equals(YEAR_COMBO)) {
            String[] yearLabels = new String[this.yearsInCalendar];
            for (int i = 0; i < this.yearsInCalendar; ++i) {
                yearLabels[i] = Integer.toString(this.startYear + i);
            }
            CCDropDownMenu child = new CCDropDownMenu((ContainerView)this, name, null);
            OptionList optionList = new OptionList(yearLabels, yearLabels);
            child.setOptions(optionList);
            return child;
        }
        if (name.equals(START_HOUR_COMBO) || name.equals(END_HOUR_COMBO)) {
            String[] hours = new String[25];
            hours[0] = "  ";
            for (int i = 0; i < 24; ++i) {
                hours[i + 1] = i < 10 ? "0" + i : Integer.toString(i);
            }
            CCDropDownMenu child = new CCDropDownMenu((ContainerView)this, name, null);
            child.setOptions(new OptionList(hours, hours));
            return child;
        }
        if (name.equals(START_MINUTE_COMBO) || name.equals(END_MINUTE_COMBO)) {
            int count = 12;
            String[] minutes = new String[count + 1];
            minutes[0] = "  ";
            for (int i = 0; i < count; ++i) {
                int num = i * 5;
                minutes[i + 1] = num < 10 ? "0" + num : Integer.toString(num);
            }
            CCDropDownMenu child = new CCDropDownMenu((ContainerView)this, name, null);
            child.setOptions(new OptionList(minutes, minutes));
            return child;
        }
        if (name.equals(REPEAT_INTERVAL_COMBO)) {
            CCDropDownMenu child = new CCDropDownMenu((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(START_DATE_TEXT)) {
            TextField child = new TextField((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(REPEAT_LIMITUNIT_COMBO)) {
            CCDropDownMenu child = new CCDropDownMenu((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(REPEAT_LIMITPERIOD_TEXT)) {
            TextField child = new TextField((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(DEFAULT_HREF) || name.equals(REPEAT_INTERVAL_HREF) || name.equals(CHILD_DATE_HREF)) {
            CCHref child = new CCHref((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_ALERT)) {
            return new CCAlertInline((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_PREVIEW_BUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, "datetime.preview");
            child.setType("secondaryMini");
            return child;
        }
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        Boolean b = (Boolean)this.getParentViewBean().getPageSessionAttribute(this.INTERVAL_CHANGE);
        this.restoreStateData();
        if (b != null && b.booleanValue()) {
            this.getParentViewBean().setPageSessionAttribute(this.INTERVAL_CHANGE, null);
            return;
        }
        b = (Boolean)this.getParentViewBean().getPageSessionAttribute(this.PREVIEW_CLICKED);
        if (b != null && b.booleanValue()) {
            this.getParentViewBean().setPageSessionAttribute(this.PREVIEW_CLICKED, null);
            if (!this.validateDataInput()) {
                return;
            }
        }
        HashMap map = (HashMap)this.getStateData();
        Calendar c = this.getCalendar();
        Date startDate = this.model.getStartDateTime();
        if (startDate != null) {
            c.setTime(startDate);
        }
        try {
            int month = map.get(MONTH_COMBO) != null ? Integer.parseInt((String)map.get(MONTH_COMBO)) : c.get(2);
            this.setDisplayFieldValue(MONTH_COMBO, MONTH_PREFIX + month);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            int year;
            int n = year = map.get(YEAR_COMBO) != null ? Integer.parseInt((String)map.get(YEAR_COMBO)) : c.get(1);
            if (year >= this.startYear && year < this.startYear + this.yearsInCalendar) {
                this.setDisplayFieldValue(YEAR_COMBO, Integer.toString(year));
            } else {
                this.setDisplayFieldValue(YEAR_COMBO, Integer.toString(this.endYear));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String startHour = "  ";
        String startMinute = "  ";
        String startDateText = "";
        if (startDate != null) {
            try {
                int hour = map.get(START_HOUR_COMBO) != null ? Integer.parseInt((String)map.get(START_HOUR_COMBO)) : c.get(11);
                startHour = hour < 10 ? "0" + hour : Integer.toString(hour);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                int minute;
                int n = minute = map.get(START_MINUTE_COMBO) != null ? Integer.parseInt((String)map.get(START_MINUTE_COMBO)) : c.get(12);
                if (minute % 5 != 0) {
                    minute = minute - minute % 5 + 5;
                }
                if (minute == 60) {
                    minute = 0;
                }
                startMinute = minute < 10 ? "0" + minute : Integer.toString(minute);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            startDateText = map.get(START_DATE_TEXT) != null ? (String)map.get(START_DATE_TEXT) : this.dateFormat.format(c.getTime());
        }
        this.setDisplayFieldValue(START_HOUR_COMBO, startHour);
        this.setDisplayFieldValue(START_MINUTE_COMBO, startMinute);
        this.setDisplayFieldValue(START_DATE_TEXT, startDateText);
        String endHour = "  ";
        String endMinute = "  ";
        Date endTime = this.model.getEndTime();
        if (endTime != null) {
            c.setTime(endTime);
        }
        if (map.get(END_HOUR_COMBO) != null) {
            try {
                int hour = map.get(END_HOUR_COMBO) != null ? Integer.parseInt((String)map.get(END_HOUR_COMBO)) : c.get(11);
                endHour = hour < 10 ? "0" + hour : Integer.toString(hour);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                int minute;
                int n = minute = map.get(END_MINUTE_COMBO) != null ? Integer.parseInt((String)map.get(END_MINUTE_COMBO)) : c.get(12);
                if (minute % 5 != 0) {
                    minute = minute - minute % 5 + 5;
                }
                if (minute == 60) {
                    minute = 0;
                }
                endMinute = minute < 10 ? "0" + minute : Integer.toString(minute);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.setDisplayFieldValue(END_HOUR_COMBO, endHour);
        this.setDisplayFieldValue(END_MINUTE_COMBO, endMinute);
        String interval = null;
        if (map.get(REPEAT_INTERVAL_COMBO) != null) {
            interval = (String)map.get(REPEAT_INTERVAL_COMBO);
            this.updateRepeatInterval();
        } else {
            interval = this.model.getSelectedRepeatIntervalName();
            if (interval != null) {
                String[] repeatIntervals = this.model.getRepeatIntervals();
                for (int i = 0; i < repeatIntervals.length; ++i) {
                    if (!interval.equals(repeatIntervals[i])) continue;
                    interval = "interval" + i;
                    break;
                }
            } else {
                interval = "interval0";
            }
        }
        this.setDisplayFieldValue(REPEAT_INTERVAL_COMBO, interval);
        try {
            String unit = map.get(REPEAT_LIMITUNIT_COMBO) != null ? (String)map.get(REPEAT_LIMITUNIT_COMBO) : "limitUnit" + Integer.toString(this.model.getRepeatLimitUnit());
            this.setDisplayFieldValue(REPEAT_LIMITUNIT_COMBO, unit);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String period = map.get(REPEAT_LIMITPERIOD_TEXT) != null ? (String)map.get(REPEAT_LIMITPERIOD_TEXT) : Integer.toString(this.model.getRepeatLimitPeriod());
        try {
            String periodText = Integer.parseInt(period) != -1 ? period : "";
            this.setDisplayFieldValue(REPEAT_LIMITPERIOD_TEXT, periodText);
        }
        catch (NumberFormatException e) {
            this.setDisplayFieldValue(REPEAT_LIMITPERIOD_TEXT, period);
        }
    }

    public Map getStateData() {
        HashMap map;
        ViewBean vb = this.getParentViewBean();
        HashMap hashMap = map = vb.getPageSessionAttribute(this.STATE_DATA) != null ? (HashMap)vb.getPageSessionAttribute(this.STATE_DATA) : new HashMap();
        if (this.getDisplayFieldValue(MONTH_COMBO) != null) {
            map.put(MONTH_COMBO, this.getDisplayFieldValue(MONTH_COMBO));
        }
        if (this.getDisplayFieldValue(YEAR_COMBO) != null) {
            map.put(YEAR_COMBO, this.getDisplayFieldValue(YEAR_COMBO));
        }
        if (this.getDisplayFieldValue(START_DATE_TEXT) != null) {
            map.put(START_DATE_TEXT, this.getDisplayFieldValue(START_DATE_TEXT));
        }
        if (this.getDisplayFieldValue(START_HOUR_COMBO) != null) {
            map.put(START_HOUR_COMBO, this.getDisplayFieldValue(START_HOUR_COMBO));
        }
        if (this.getDisplayFieldValue(START_MINUTE_COMBO) != null) {
            map.put(START_MINUTE_COMBO, this.getDisplayFieldValue(START_MINUTE_COMBO));
        }
        if (this.getDisplayFieldValue(END_HOUR_COMBO) != null) {
            map.put(END_HOUR_COMBO, this.getDisplayFieldValue(END_HOUR_COMBO));
        }
        if (this.getDisplayFieldValue(END_MINUTE_COMBO) != null) {
            map.put(END_MINUTE_COMBO, this.getDisplayFieldValue(END_MINUTE_COMBO));
        }
        if (this.getDisplayFieldValue(REPEAT_INTERVAL_COMBO) != null) {
            map.put(REPEAT_INTERVAL_COMBO, this.getDisplayFieldValue(REPEAT_INTERVAL_COMBO));
        }
        if (this.getDisplayFieldValue(REPEAT_LIMITUNIT_COMBO) != null) {
            map.put(REPEAT_LIMITUNIT_COMBO, this.getDisplayFieldValue(REPEAT_LIMITUNIT_COMBO));
        }
        if (this.getDisplayFieldValue(REPEAT_LIMITPERIOD_TEXT) != null) {
            map.put(REPEAT_LIMITPERIOD_TEXT, this.getDisplayFieldValue(REPEAT_LIMITPERIOD_TEXT));
        }
        if (map.get("startDateKey") == null) {
            map.put("startDateKey", this.model.getStartDateTime());
        }
        if (map.get("endDateKey") == null) {
            map.put("endDateKey", this.model.getEndTime());
        }
        if (map.get("repeatIntervalKey") == null) {
            map.put("repeatIntervalKey", this.model.getSelectedRepeatIntervalName());
        }
        if (map.get("repeatLimitUnitKey") == null) {
            map.put("repeatLimitUnitKey", new Integer(this.model.getRepeatLimitUnit()));
        }
        if (map.get("repeatLimitPeriodKey") == null) {
            map.put("repeatLimitPeriodKey", new Integer(this.model.getRepeatLimitPeriod()));
        }
        return map;
    }

    public void setStateData() {
        this.restoreStateData();
    }

    public void setStateData(Map map) {
        this.resetStateData();
        if (map == null) {
            CCDebug.trace1("State data map is null");
            return;
        }
        this.setDisplayFieldValue(MONTH_COMBO, map.get(MONTH_COMBO));
        this.setDisplayFieldValue(YEAR_COMBO, map.get(YEAR_COMBO));
        this.setDisplayFieldValue(START_DATE_TEXT, map.get(START_DATE_TEXT));
        this.setDisplayFieldValue(START_HOUR_COMBO, map.get(START_HOUR_COMBO));
        this.setDisplayFieldValue(START_MINUTE_COMBO, map.get(START_MINUTE_COMBO));
        this.setDisplayFieldValue(END_HOUR_COMBO, map.get(END_HOUR_COMBO));
        this.setDisplayFieldValue(END_MINUTE_COMBO, map.get(END_MINUTE_COMBO));
        this.setDisplayFieldValue(REPEAT_INTERVAL_COMBO, map.get(REPEAT_INTERVAL_COMBO));
        this.setDisplayFieldValue(REPEAT_LIMITUNIT_COMBO, map.get(REPEAT_LIMITUNIT_COMBO));
        this.setDisplayFieldValue(REPEAT_LIMITPERIOD_TEXT, map.get(REPEAT_LIMITPERIOD_TEXT));
        this.model.setStartDateTime((Date)map.get("startDateKey"));
        this.model.setEndTime((Date)map.get("endDateKey"));
        String interval = (String)map.get("repeatIntervalKey");
        this.model.setSelectedRepeatIntervalName(interval.substring("interval".length()));
        String unit = (String)map.get("repeatLimitUnitKey");
        unit = unit.substring("limitUnit".length());
        try {
            this.model.setRepeatLimitUnit(Integer.parseInt(unit));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String period = (String)map.get("repeatLimitPeriodKey");
        try {
            this.model.setRepeatLimitPeriod(Integer.parseInt(period));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    public void reset() {
        this.resetStateData();
    }

    public void resetStateData() {
        this.setDisplayFieldValue(MONTH_COMBO, null);
        this.setDisplayFieldValue(YEAR_COMBO, null);
        this.setDisplayFieldValue(START_DATE_TEXT, null);
        this.setDisplayFieldValue(START_HOUR_COMBO, null);
        this.setDisplayFieldValue(START_MINUTE_COMBO, null);
        this.setDisplayFieldValue(END_HOUR_COMBO, null);
        this.setDisplayFieldValue(END_MINUTE_COMBO, null);
        this.setDisplayFieldValue(REPEAT_INTERVAL_COMBO, null);
        this.setDisplayFieldValue(REPEAT_LIMITUNIT_COMBO, null);
        this.setDisplayFieldValue(REPEAT_LIMITPERIOD_TEXT, null);
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, null);
    }

    public void restoreStateData() {
        HashMap map = (HashMap)this.getStateData();
        if (map.get("startDateKey") != null) {
            this.model.setStartDateTime((Date)map.get("startDateKey"));
        }
        if (map.get("endDateKey") != null) {
            this.model.setEndTime((Date)map.get("endDateKey"));
        }
        if (map.get("repeatIntervalKey") != null) {
            this.model.setSelectedRepeatIntervalName((String)map.get("repeatIntervalKey"));
        }
        if (map.get("repeatLimitUnitKey") != null) {
            this.model.setRepeatLimitUnit((Integer)map.get("repeatLimitUnitKey"));
        }
        if (map.get("repeatLimitPeriodKey") != null) {
            this.model.setRepeatLimitPeriod((Integer)map.get("repeatLimitPeriodKey"));
        }
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)map);
    }

    public void handleDateHREFRequest(RequestInvocationEvent event) throws ServletException, IOException, ParseException {
        CCHref href = (CCHref)this.getChild(CHILD_DATE_HREF);
        String date = (String)href.getValue();
        this.setDisplayFieldValue(START_DATE_TEXT, date);
        HashMap m = (HashMap)this.getStateData();
        m.put("startDateKey", this.dateFormat.parse(date));
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)m);
        this.getParentViewBean().forwardTo(this.getRequestContext());
    }

    public void handleDecreaseRequest(RequestInvocationEvent event) throws ServletException, IOException {
        CCDropDownMenu monthCombo = (CCDropDownMenu)this.getChild(MONTH_COMBO);
        CCDropDownMenu yearCombo = (CCDropDownMenu)this.getChild(YEAR_COMBO);
        String strMonth = (String)monthCombo.getValue();
        int month = new Integer(strMonth = strMonth.substring(MONTH_PREFIX.length()));
        if (month == 0) {
            int year = new Integer(yearCombo.getValue().toString());
            if (year != this.startYear) {
                yearCombo.setValue(Integer.toString(year - 1));
                month = this.monthLabels.length;
            } else {
                month = 1;
            }
        }
        monthCombo.setValue(MONTH_PREFIX + (month - 1));
        ViewBean targetView = this.getParentViewBean();
        targetView.forwardTo(this.getRequestContext());
    }

    public void handleIncreaseRequest(RequestInvocationEvent event) throws ServletException, IOException {
        CCDropDownMenu monthCombo = (CCDropDownMenu)this.getChild(MONTH_COMBO);
        CCDropDownMenu yearCombo = (CCDropDownMenu)this.getChild(YEAR_COMBO);
        String strMonth = (String)monthCombo.getValue();
        int month = new Integer(strMonth = strMonth.substring(MONTH_PREFIX.length()));
        if (month == this.monthLabels.length - 1) {
            int year = new Integer(yearCombo.getValue().toString());
            if (year != this.startYear + this.yearsInCalendar - 1) {
                yearCombo.setValue(Integer.toString(year + 1));
                month = -1;
            } else {
                month = this.monthLabels.length - 2;
            }
        }
        monthCombo.setValue(MONTH_PREFIX + (month + 1));
        ViewBean targetView = this.getParentViewBean();
        targetView.forwardTo(this.getRequestContext());
    }

    public void handleDefaultHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        if (this.getDisplayFieldValue(REPEAT_INTERVAL_COMBO) != null) {
            HashMap m = (HashMap)this.getStateData();
            this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)m);
        }
        ViewBean targetView = this.getParentViewBean();
        targetView.forwardTo(this.getRequestContext());
    }

    public void handleRepeatIntervalHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        ViewBean targetView = this.getParentViewBean();
        targetView.setPageSessionAttribute(this.INTERVAL_CHANGE, (Serializable)new Boolean(true));
        targetView.forwardTo(this.getRequestContext());
    }

    public void handlePreviewButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        ViewBean vb = this.getParentViewBean();
        vb.setPageSessionAttribute(this.PREVIEW_CLICKED, (Serializable)new Boolean(true));
        vb.forwardTo(this.getRequestContext());
    }

    private String updateRepeatInterval() {
        String interval = (String)this.getDisplayFieldValue(REPEAT_INTERVAL_COMBO);
        if (interval != null) {
            String[] intervals = this.model.getRepeatIntervals();
            int index = new Integer(interval = interval.substring("interval".length()));
            if (index < 0 || index >= this.model.getRepeatIntervals().length) {
                index = 0;
            }
            this.model.setSelectedRepeatIntervalName(intervals[index]);
            int repeatUnit = this.model.getRepeatIntervalUnit(intervals[index]);
            int period = -1;
            int type = this.model.getType();
            if (type == 0 || type == 3) {
                String strUnit;
                if (repeatUnit != 5) {
                    String strPeriod = (String)this.getDisplayFieldValue(REPEAT_LIMITPERIOD_TEXT);
                    if (strPeriod == null) {
                        strPeriod = "";
                    }
                    if (strPeriod.trim().length() != 0) {
                        try {
                            period = new Integer(strPeriod);
                            if (period <= 0) {
                                return INPUT_ERROR_LIMIT;
                            }
                        }
                        catch (NumberFormatException ex) {
                            return INPUT_ERROR_LIMIT;
                        }
                    }
                }
                if ((strUnit = (String)this.getDisplayFieldValue(REPEAT_LIMITUNIT_COMBO)) != null) {
                    strUnit = strUnit.substring("limitUnit".length());
                    this.model.setRepeatLimitUnit(new Integer(strUnit));
                }
            }
            this.model.setRepeatLimitPeriod(period);
        }
        return null;
    }

    public boolean validateDataInput() {
        String[] repeatIntervals = this.model.getRepeatIntervals();
        TextField startDate = (TextField)this.getChild(START_DATE_TEXT);
        String start = startDate.getValue() != null ? (String)startDate.getValue() : "";
        Calendar calendar = this.getCalendar();
        int index = 0;
        if ((start = this.validateDateString(start)) == null) {
            this.displayAlertError(INPUT_ERROR_DATE);
            return false;
        }
        this.setDisplayFieldValue(START_DATE_TEXT, start);
        try {
            calendar.setTime(this.dateFormat.parse(start));
        }
        catch (ParseException ex) {
            this.displayAlertError(INPUT_ERROR_DATE);
            return false;
        }
        if (this.model.getType() == 2) {
            this.model.setStartDateTime(calendar.getTime());
            return true;
        }
        CCDropDownMenu startHourCombo = (CCDropDownMenu)this.getChild(START_HOUR_COMBO);
        CCDropDownMenu startMinuteCombo = (CCDropDownMenu)this.getChild(START_MINUTE_COMBO);
        String strHour = (String)startHourCombo.getValue();
        String strMinute = (String)startMinuteCombo.getValue();
        if (strHour == null || strMinute == null || strHour.equals("  ") || strMinute.equals("  ")) {
            this.displayAlertError(INPUT_ERROR_TIME);
            return false;
        }
        int startHour = new Integer(strHour);
        int startMinute = new Integer(strMinute);
        calendar.set(11, startHour);
        calendar.set(12, startMinute);
        this.model.setStartDateTime(calendar.getTime());
        String repeatErrorMsg = this.updateRepeatInterval();
        if (this.model.getType() == 0 || this.model.getType() == 3) {
            CCDropDownMenu endHourCombo = (CCDropDownMenu)this.getChild(END_HOUR_COMBO);
            CCDropDownMenu endMinuteCombo = (CCDropDownMenu)this.getChild(END_MINUTE_COMBO);
            strHour = (String)endHourCombo.getValue();
            strMinute = (String)endMinuteCombo.getValue();
            if (strHour != null && strMinute != null && !strHour.equals("  ") && !strMinute.equals("  ")) {
                int endHour = new Integer(strHour);
                int endMinute = new Integer(strMinute);
                if (startHour > endHour || startHour == endHour && startMinute > endMinute) {
                    this.displayAlertError("datetime.startLTEndError");
                    return false;
                }
                calendar.set(11, endHour);
                calendar.set(12, endMinute);
                this.model.setEndTime(calendar.getTime());
            } else if (strHour != null && strMinute != null && strHour.equals("  ") && strMinute.equals("  ")) {
                this.model.setEndTime(null);
            } else {
                this.displayAlertError("datetime.endTimeError");
                return false;
            }
            if (repeatErrorMsg != null) {
                this.displayAlertError(repeatErrorMsg);
                return false;
            }
            String[] intervals = this.model.getRepeatIntervals();
            int repeatUnit = this.model.getRepeatIntervalUnit(intervals[index]);
            if (repeatUnit == 3) {
                for (int i = 0; i < this.model.getRepeatLimitPeriod(); ++i) {
                    Calendar c = (Calendar)calendar.clone();
                    c.add(2, i);
                    if (calendar.get(5) <= c.get(5)) continue;
                    this.displayAlertWarning("datetime.dateWarning");
                    break;
                }
            }
        }
        HashMap map = (HashMap)this.getStateData();
        map.put("startDateKey", null);
        map.put("endDateKey", null);
        map.put("repeatIntervalKey", null);
        map.put("repeatLimitUnitKey", null);
        map.put("repeatLimitPeriodKey", null);
        String month = String.valueOf(calendar.get(2));
        String year = String.valueOf(calendar.get(1));
        map.put(MONTH_COMBO, String.valueOf(month));
        map.put(YEAR_COMBO, String.valueOf(year));
        this.setDisplayFieldValue(MONTH_COMBO, MONTH_PREFIX + month);
        this.setDisplayFieldValue(YEAR_COMBO, String.valueOf(year));
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)map);
        return true;
    }

    public boolean isOneDayScheduled(Date date) {
        Date startDateTime = this.model.getStartDateTime();
        if (startDateTime == null) {
            return false;
        }
        Calendar calendar = this.getCalendar();
        calendar.setTime(startDateTime);
        int month = calendar.get(2);
        int day = calendar.get(5);
        int year = calendar.get(1);
        calendar.setTime(date);
        if (month == calendar.get(2) && day == calendar.get(5) && year == calendar.get(1)) {
            return true;
        }
        int type = this.model.getType();
        if (type == 2 || type == 4) {
            return false;
        }
        if (date.before(startDateTime)) {
            return false;
        }
        calendar.setTime(startDateTime);
        int limitUnit = this.model.getRepeatLimitUnit();
        int limitPeriod = this.model.getRepeatLimitPeriod();
        if (limitUnit != -1 && limitPeriod != -1) {
            if (limitUnit == 0) {
                calendar.add(11, limitPeriod - 1);
                calendar.set(12, 59);
            } else if (limitUnit == 1) {
                calendar.add(5, limitPeriod - 1);
                calendar.set(11, 23);
                calendar.set(12, 59);
            } else if (limitUnit == 2) {
                limitPeriod = limitPeriod * 7 - 1;
                calendar.add(5, limitPeriod);
                calendar.set(11, 23);
                calendar.set(12, 59);
            } else if (limitUnit == 3) {
                int curDay = calendar.get(5);
                calendar.add(2, limitPeriod);
                if (curDay == calendar.get(5)) {
                    calendar.add(5, -1);
                }
                calendar.set(11, 23);
                calendar.set(12, 59);
            }
            if (calendar.getTime().before(date)) {
                return false;
            }
        }
        calendar.setTime(startDateTime);
        String intervalName = this.model.getSelectedRepeatIntervalName();
        if (intervalName == null) {
            intervalName = this.model.getRepeatIntervals()[0];
        }
        int unit = this.model.getRepeatIntervalUnit(intervalName);
        int period = this.model.getRepeatIntervalAccount(intervalName);
        if (unit == 1 || unit == 0 || unit == 2) {
            long timeAdd = 0L;
            if (unit == 0) {
                if (period <= 24) {
                    return true;
                }
                timeAdd = period * 60 * 60000;
            } else if (unit == 1) {
                timeAdd = period * 24 * 60 * 60000;
            } else if (unit == 2) {
                Calendar c = this.getCalendar();
                c.setTime(date);
                return calendar.get(7) == c.get(7);
            }
            Calendar c = this.getCalendar();
            c.set(1, 1970);
            c.set(2, 0);
            c.set(5, 1);
            c.set(11, 0);
            c.set(12, 0);
            c.set(13, 0);
            c.set(14, 0);
            long offset = c.getTime().getTime();
            long time = startDateTime.getTime() - offset;
            long myTime = date.getTime() - offset;
            long oneDay = 86400000L;
            do {
                if (myTime / oneDay != (time += timeAdd) / oneDay) continue;
                return true;
            } while (time <= myTime);
            return false;
        }
        if (unit == 4) {
            calendar.setTime(date);
            int weekday = calendar.get(7);
            int result = 0;
            if (weekday == 1) {
                result = period & 0x40;
            } else if (weekday == 2) {
                result = period & 1;
            } else if (weekday == 3) {
                result = period & 2;
            } else if (weekday == 4) {
                result = period & 4;
            } else if (weekday == 5) {
                result = period & 8;
            } else if (weekday == 6) {
                result = period & 0x10;
            } else if (weekday == 7) {
                result = period & 0x20;
            }
            return result != 0;
        }
        if (unit == 3) {
            calendar.setTime(date);
            day = calendar.get(5);
            calendar.setTime(startDateTime);
            int day1 = calendar.get(5);
            return day == day1;
        }
        return unit != 5;
    }

    private void displayAlertError(String detail) {
        CCAlertInline alert = (CCAlertInline)this.getChild(CHILD_ALERT);
        alert.setValue("error");
        alert.setDetail(detail);
        alert.setSummary("datetime.errorSummary");
    }

    private void displayAlertWarning(String detail) {
        CCAlertInline alert = (CCAlertInline)this.getChild(CHILD_ALERT);
        alert.setValue("warning");
        alert.setDetail(detail);
        alert.setSummary("datetime.warningSummary");
    }
}

