/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.view.datetime;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.common.CCStateData;
import com.sun.web.ui.model.CCDateTimeModelInterface;
import com.sun.web.ui.servlet.datetime.DateTimeWindowViewBean;
import com.sun.web.ui.view.datetime.CCDateTimeBase;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.html.CCImageField;
import com.sun.web.ui.view.html.CCTextField;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;

public class CCDateTimeWindow
extends CCDateTimeBase
implements CCStateData {
    public static final String CHILD_TEXTFIELD = "textField";
    public static final String CHILD_IMAGE = "image";
    public static final String CHILD_HREF = "href";
    public static final String CHILD_START_DATE = "startDate";
    public static final String CHILD_START_HOUR = "startHour";
    public static final String CHILD_START_MINUTE = "startMinute";
    public static final String CHILD_END_HOUR = "endHour";
    public static final String CHILD_END_MINUTE = "endMinute";
    public static final String CHILD_REPEAT_INTERVAL = "repeatInterval";
    public static final String CHILD_REPEAT_UNIT = "repeatUnit";
    public static final String CHILD_REPEAT_PERIOD = "repeatPeriod";
    private String mastheadSrc = null;
    private String mastheadAlt = null;
    private String mastheadHeight = null;
    private String mastheadWidth = null;
    private String showTextInput = null;
    private final String STATE_DATA = this.getQualifiedName() + ".stateData";

    public CCDateTimeWindow(ContainerView parent, CCDateTimeModelInterface model, String name) {
        super(parent, model, name);
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(CHILD_TEXTFIELD, CCTextField.class);
        this.registerChild(CHILD_IMAGE, CCImage.class);
        this.registerChild(CHILD_HREF, CCHref.class);
        this.registerChild(CHILD_START_DATE, CCHiddenField.class);
        this.registerChild(CHILD_START_HOUR, CCHiddenField.class);
        this.registerChild(CHILD_START_MINUTE, CCHiddenField.class);
        this.registerChild(CHILD_END_HOUR, CCHiddenField.class);
        this.registerChild(CHILD_END_MINUTE, CCHiddenField.class);
        this.registerChild(CHILD_REPEAT_INTERVAL, CCHiddenField.class);
        this.registerChild(CHILD_REPEAT_UNIT, CCHiddenField.class);
        this.registerChild(CHILD_REPEAT_PERIOD, CCHiddenField.class);
    }

    protected View createChild(String name) {
        if (name.equals(CHILD_TEXTFIELD)) {
            return new CCTextField((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_IMAGE)) {
            CCImageField child = new CCImageField((ContainerView)this, name, CCImage.DATETIME_POPUP);
            return child;
        }
        if (name.equals(CHILD_HREF)) {
            CCHref child = new CCHref((ContainerView)this, name, null);
            return child;
        }
        if (name.equals(CHILD_START_DATE) || name.equals(CHILD_START_HOUR) || name.equals(CHILD_START_MINUTE) || name.equals(CHILD_END_HOUR) || name.equals(CHILD_END_MINUTE) || name.equals(CHILD_REPEAT_INTERVAL) || name.equals(CHILD_REPEAT_UNIT) || name.equals(CHILD_REPEAT_PERIOD)) {
            CCHiddenField child = new CCHiddenField((ContainerView)this, name, "");
            return child;
        }
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.restoreStateData();
    }

    public void handleHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        DateTimeWindowViewBean vb = (DateTimeWindowViewBean)this.getViewBean(DateTimeWindowViewBean.class);
        this.restoreStateData();
        vb.setDateTimeModel(this.model);
        vb.forwardTo(this.getRequestContext());
    }

    public boolean validateDataInput() {
        String startDate = (String)this.getDisplayFieldValue(CHILD_TEXTFIELD);
        if (startDate == null) {
            startDate = (String)this.getDisplayFieldValue(CHILD_START_DATE);
        }
        if ((startDate = this.validateDateString(startDate)) == null) {
            return false;
        }
        this.setDisplayFieldValue(CHILD_TEXTFIELD, startDate);
        Calendar calendar = this.getCalendar();
        try {
            calendar.setTime(this.dateFormat.parse(startDate));
        }
        catch (ParseException e) {
            return false;
        }
        if (this.model.getType() == 2) {
            this.model.setStartDateTime(calendar.getTime());
            return true;
        }
        String hour = (String)this.getDisplayFieldValue(CHILD_START_HOUR);
        String minute = (String)this.getDisplayFieldValue(CHILD_START_MINUTE);
        if (hour == null || minute == null || hour.equals("") || minute.equals("")) {
            return false;
        }
        int startHour = new Integer(hour);
        int startMinute = new Integer(minute);
        calendar.set(11, startHour);
        calendar.set(12, startMinute);
        this.model.setStartDateTime(calendar.getTime());
        String interval = (String)this.getDisplayFieldValue(CHILD_REPEAT_INTERVAL);
        int index = 0;
        String[] repeatIntervals = this.model.getRepeatIntervals();
        if (interval != null && !interval.equals("")) {
            interval = interval.substring("interval".length());
            index = new Integer(interval);
            this.model.setSelectedRepeatIntervalName(repeatIntervals[index]);
        }
        int repeatUnit = this.model.getRepeatIntervalUnit(repeatIntervals[index]);
        this.model.setRepeatLimitPeriod(-1);
        if (this.model.getType() == 0 || this.model.getType() == 3) {
            hour = (String)this.getDisplayFieldValue(CHILD_END_HOUR);
            minute = (String)this.getDisplayFieldValue(CHILD_END_MINUTE);
            if (hour != null && minute != null && !hour.equals("  ") && !minute.equals("  ")) {
                int endHour = new Integer(hour);
                int endMinute = new Integer(minute);
                calendar.set(11, endHour);
                calendar.set(12, endMinute);
                this.model.setEndTime(calendar.getTime());
            } else if (hour != null && minute != null && hour.equals("  ") && minute.equals("  ")) {
                this.model.setEndTime(null);
            } else {
                return false;
            }
            if (repeatUnit != 5) {
                String repeatPeriod = this.getDisplayFieldValue(CHILD_REPEAT_PERIOD) != null ? (String)this.getDisplayFieldValue(CHILD_REPEAT_PERIOD) : "";
                int period = -1;
                if (repeatPeriod.trim().length() != 0) {
                    try {
                        period = new Integer(repeatPeriod);
                    }
                    catch (NumberFormatException ex) {
                        return false;
                    }
                }
                this.model.setRepeatLimitPeriod(period);
                String unit = (String)this.getDisplayFieldValue(CHILD_REPEAT_UNIT);
                if (unit != null && !unit.equals("")) {
                    unit = unit.substring("limitUnit".length());
                    this.model.setRepeatLimitUnit(new Integer(unit));
                }
            }
        }
        return true;
    }

    public Map getStateData() {
        if (this.model == null) {
            return null;
        }
        ViewBean vb = this.getParentViewBean();
        HashMap stateMap = vb.getPageSessionAttribute(this.STATE_DATA) != null ? (HashMap)vb.getPageSessionAttribute(this.STATE_DATA) : new HashMap();
        stateMap.put(CHILD_TEXTFIELD, this.getDisplayFieldValue(CHILD_TEXTFIELD));
        stateMap.put(CHILD_START_DATE, this.getDisplayFieldValue(CHILD_START_DATE));
        stateMap.put(CHILD_START_HOUR, this.getDisplayFieldValue(CHILD_START_HOUR));
        stateMap.put(CHILD_START_MINUTE, this.getDisplayFieldValue(CHILD_START_MINUTE));
        stateMap.put(CHILD_END_HOUR, this.getDisplayFieldValue(CHILD_END_HOUR));
        stateMap.put(CHILD_END_MINUTE, this.getDisplayFieldValue(CHILD_END_MINUTE));
        stateMap.put(CHILD_REPEAT_INTERVAL, this.getDisplayFieldValue(CHILD_REPEAT_INTERVAL));
        stateMap.put(CHILD_REPEAT_UNIT, this.getDisplayFieldValue(CHILD_REPEAT_UNIT));
        stateMap.put(CHILD_REPEAT_PERIOD, this.getDisplayFieldValue(CHILD_REPEAT_PERIOD));
        return stateMap;
    }

    public void setStateData(Map map) {
        this.resetStateData();
        this.setDisplayFieldValue(CHILD_TEXTFIELD, map.get(CHILD_TEXTFIELD));
        this.setDisplayFieldValue(CHILD_START_DATE, map.get(CHILD_START_DATE));
        this.setDisplayFieldValue(CHILD_START_HOUR, map.get(CHILD_START_HOUR));
        this.setDisplayFieldValue(CHILD_START_MINUTE, map.get(CHILD_START_MINUTE));
        this.setDisplayFieldValue(CHILD_END_HOUR, map.get(CHILD_END_HOUR));
        this.setDisplayFieldValue(CHILD_END_MINUTE, map.get(CHILD_END_MINUTE));
        this.setDisplayFieldValue(CHILD_REPEAT_INTERVAL, map.get(CHILD_REPEAT_INTERVAL));
        this.setDisplayFieldValue(CHILD_REPEAT_UNIT, map.get(CHILD_REPEAT_UNIT));
        this.setDisplayFieldValue(CHILD_REPEAT_PERIOD, map.get(CHILD_REPEAT_PERIOD));
    }

    public void resetStateData() {
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, null);
        this.setDisplayFieldValue(CHILD_TEXTFIELD, null);
        this.setDisplayFieldValue(CHILD_START_DATE, null);
        this.setDisplayFieldValue(CHILD_START_HOUR, null);
        this.setDisplayFieldValue(CHILD_START_MINUTE, null);
        this.setDisplayFieldValue(CHILD_END_HOUR, null);
        this.setDisplayFieldValue(CHILD_END_MINUTE, null);
        this.setDisplayFieldValue(CHILD_REPEAT_INTERVAL, null);
        this.setDisplayFieldValue(CHILD_REPEAT_UNIT, null);
        this.setDisplayFieldValue(CHILD_REPEAT_PERIOD, null);
    }

    public void restoreStateData() {
        String interval;
        String unit;
        HashMap stateMap = (HashMap)this.getStateData();
        Calendar calendar = this.getCalendar();
        if (stateMap == null || this.model == null) {
            return;
        }
        String startDate = (String)stateMap.get(CHILD_TEXTFIELD);
        if (startDate == null) {
            startDate = (String)stateMap.get(CHILD_START_DATE);
        }
        try {
            calendar.setTime(this.dateFormat.parse(startDate));
            this.model.setStartDateTime(calendar.getTime());
        }
        catch (ParseException ex) {
            // empty catch block
        }
        String hour = (String)stateMap.get(CHILD_START_HOUR);
        String minute = (String)stateMap.get(CHILD_START_MINUTE);
        try {
            calendar.set(11, new Integer(hour));
            calendar.set(12, new Integer(minute));
            this.model.setStartDateTime(calendar.getTime());
        }
        catch (NumberFormatException startException) {
            // empty catch block
        }
        hour = (String)stateMap.get(CHILD_END_HOUR);
        minute = (String)stateMap.get(CHILD_START_MINUTE);
        try {
            calendar.set(11, new Integer(hour));
            calendar.set(12, new Integer(minute));
            this.model.setEndTime(calendar.getTime());
        }
        catch (NumberFormatException endException) {
            // empty catch block
        }
        String period = (String)stateMap.get(CHILD_REPEAT_PERIOD);
        if (period != null && !period.equals("")) {
            this.model.setRepeatLimitPeriod(new Integer(period));
        }
        if ((unit = (String)stateMap.get(CHILD_REPEAT_UNIT)) != null && !unit.equals("")) {
            unit = unit.substring("limitUnit".length());
            this.model.setRepeatLimitUnit(new Integer(unit));
        }
        if ((interval = (String)stateMap.get(CHILD_REPEAT_INTERVAL)) != null && !interval.equals("")) {
            int index = 0;
            String[] repeatIntervals = this.model.getRepeatIntervals();
            interval = interval.substring("interval".length());
            index = new Integer(interval);
            this.model.setSelectedRepeatIntervalName(repeatIntervals[index]);
        }
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)stateMap);
    }

    public String getMastheadSrc() {
        return this.mastheadSrc;
    }

    public void setMastheadSrc(String value) {
        this.mastheadSrc = value;
    }

    public String getMastheadHeight() {
        return this.mastheadHeight;
    }

    public void setMastheadHeight(String value) {
        this.mastheadHeight = value;
    }

    public String getMastheadWidth() {
        return this.mastheadWidth;
    }

    public void setMastheadWidth(String value) {
        this.mastheadWidth = value;
    }

    public String getMastheadAlt() {
        return this.mastheadAlt;
    }

    public void setMastheadAlt(String value) {
        this.mastheadAlt = value;
    }

    public String getShowTextInput() {
        return this.showTextInput;
    }

    public void setShowTextInput(String value) {
        this.showTextInput = value;
    }
}

