/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.ContainerFactory;
import com.sun.ejb.EJBUtils;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.ContainerSynchronization;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EntityContainer;
import com.sun.ejb.containers.TimerLocalHome;
import com.sun.ejb.containers.TimerPrimaryKey;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBContext;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;

public abstract class TimerBean
implements EntityBean {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private static final int ACTIVE = 0;
    private static final int CANCELLED = 1;
    private EJBContextImpl context_;
    private boolean blobLoaded_;
    private Object timedObjectPrimaryKey_;
    private transient Serializable info_;
    private transient Date creationTime_;
    private transient Date initialExpiration_;
    private transient Date lastExpiration_;

    public abstract String getTimerId();

    public abstract void setTimerId(String var1);

    public abstract String getOwnerId();

    public abstract void setOwnerId(String var1);

    public abstract long getCreationTimeRaw();

    public abstract void setCreationTimeRaw(long var1);

    public abstract long getInitialExpirationRaw();

    public abstract void setInitialExpirationRaw(long var1);

    public abstract long getLastExpirationRaw();

    public abstract void setLastExpirationRaw(long var1);

    public abstract long getIntervalDuration();

    public abstract void setIntervalDuration(long var1);

    public abstract int getState();

    public abstract void setState(int var1);

    public abstract long getContainerId();

    public abstract void setContainerId(long var1);

    public abstract Blob getBlob();

    public abstract void setBlob(Blob var1);

    public abstract int getPkHashCode();

    public abstract void setPkHashCode(int var1);

    public abstract Set ejbSelectTimerIdsByContainer(long var1) throws FinderException;

    public abstract Set ejbSelectTimerIdsByContainerAndState(long var1, int var3) throws FinderException;

    public abstract Set ejbSelectTimerIdsByContainerAndOwner(long var1, String var3) throws FinderException;

    public abstract Set ejbSelectTimerIdsByContainerAndOwnerAndState(long var1, String var3, int var4) throws FinderException;

    public abstract Set ejbSelectAllTimerIdsByOwner(String var1) throws FinderException;

    public abstract Set ejbSelectAllTimerIdsByOwnerAndState(String var1, int var2) throws FinderException;

    public abstract Set ejbSelectTimersByContainer(long var1) throws FinderException;

    public abstract Set ejbSelectTimersByContainerAndState(long var1, int var3) throws FinderException;

    public abstract Set ejbSelectTimersByContainerAndOwner(long var1, String var3) throws FinderException;

    public abstract Set ejbSelectTimersByContainerAndOwnerAndState(long var1, String var3, int var4) throws FinderException;

    public abstract Set ejbSelectAllTimersByOwner(String var1) throws FinderException;

    public abstract Set ejbSelectAllTimersByOwnerAndState(String var1, int var2) throws FinderException;

    public abstract int ejbSelectCountTimersByContainer(long var1) throws FinderException;

    public abstract int ejbSelectCountTimersByContainerAndState(long var1, int var3) throws FinderException;

    public abstract int ejbSelectCountTimersByContainerAndOwner(long var1, String var3) throws FinderException;

    public abstract int ejbSelectCountTimersByContainerAndOwnerAndState(long var1, String var3, int var4) throws FinderException;

    public abstract int ejbSelectCountAllTimersByOwner(String var1) throws FinderException;

    public abstract int ejbSelectCountAllTimersByOwnerAndState(String var1, int var2) throws FinderException;

    public TimerPrimaryKey ejbCreate(String timerId, long containerId, String ownerId, Object timedObjectPrimaryKey, Date initialExpiration, long intervalDuration, Serializable info) throws CreateException {
        this.setTimerId(timerId);
        this.setOwnerId(ownerId);
        return null;
    }

    public void ejbPostCreate(String timerId, long containerId, String ownerId, Object timedObjectPrimaryKey, Date initialExpiration, long intervalDuration, Serializable info) throws CreateException {
        Date creationTime = new Date();
        this.setCreationTimeRaw(creationTime.getTime());
        this.creationTime_ = creationTime;
        this.setInitialExpirationRaw(initialExpiration.getTime());
        this.initialExpiration_ = initialExpiration;
        this.setLastExpirationRaw(0L);
        this.lastExpiration_ = null;
        this.setIntervalDuration(intervalDuration);
        this.setContainerId(containerId);
        this.timedObjectPrimaryKey_ = timedObjectPrimaryKey;
        this.info_ = info;
        this.blobLoaded_ = true;
        Blob blob = null;
        try {
            blob = new Blob(timedObjectPrimaryKey, info);
        }
        catch (IOException ioe) {
            CreateException ce = new CreateException();
            ce.initCause((Throwable)ioe);
            throw ce;
        }
        this.setBlob(blob);
        this.setState(0);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "TimerBean.postCreate() ::timerId=" + this.getTimerId() + " ::containerId=" + this.getContainerId() + " ::timedObjectPK=" + timedObjectPrimaryKey + " ::info=" + info + " ::initialExpiration=" + initialExpiration + " ::intervalDuration=" + intervalDuration + " :::state=" + TimerBean.stateToString(this.getState()) + " :::creationTime=" + creationTime + " :::ownerId=" + this.getOwnerId());
        }
        if (this.timerOwnedByThisServer()) {
            TimerSynch timerSynch = new TimerSynch(new TimerPrimaryKey(this.getTimerId()), 0, this.getInitialExpiration(), this.getContainer(containerId));
            try {
                ContainerSynchronization containerSynch = this.getContainerSynch();
                containerSynch.addTimerSynchronization(new TimerPrimaryKey(this.getTimerId()), timerSynch);
            }
            catch (Exception e) {
                CreateException ce = new CreateException();
                ce.initCause((Throwable)e);
                throw ce;
            }
        }
    }

    private boolean timerOwnedByThisServer() {
        String ownerIdOfThisServer = this.getOwnerIdOfThisServer();
        return ownerIdOfThisServer != null && ownerIdOfThisServer.equals(this.getOwnerId());
    }

    private String getOwnerIdOfThisServer() {
        return TimerBean.getEJBTimerService().getOwnerIdOfThisServer();
    }

    private static String stateToString(int state) {
        String stateStr = "UNKNOWN_TIMER_STATE";
        switch (state) {
            case 0: {
                stateStr = "TIMER_ACTIVE";
                break;
            }
            case 1: {
                stateStr = "TIMER_CANCELLED";
                break;
            }
            default: {
                stateStr = "UNKNOWN_TIMER_STATE";
            }
        }
        return stateStr;
    }

    private static String txStatusToString(int txStatus) {
        String txStatusStr = "UNMATCHED TX STATUS";
        switch (txStatus) {
            case 0: {
                txStatusStr = "TX_STATUS_ACTIVE";
                break;
            }
            case 3: {
                txStatusStr = "TX_STATUS_COMMITTED";
                break;
            }
            case 8: {
                txStatusStr = "TX_STATUS_COMMITTING";
                break;
            }
            case 1: {
                txStatusStr = "TX_STATUS_MARKED_ROLLBACK";
                break;
            }
            case 6: {
                txStatusStr = "TX_STATUS_NO_TRANSACTION";
                break;
            }
            case 2: {
                txStatusStr = "TX_STATUS_PREPARED";
                break;
            }
            case 7: {
                txStatusStr = "TX_STATUS_PREPARING";
                break;
            }
            case 4: {
                txStatusStr = "TX_STATUS_ROLLEDBACK";
                break;
            }
            case 9: {
                txStatusStr = "TX_STATUS_ROLLING_BACK";
                break;
            }
            case 5: {
                txStatusStr = "TX_STATUS_UNKNOWN";
                break;
            }
            default: {
                txStatusStr = "UNMATCHED TX STATUS";
            }
        }
        return txStatusStr;
    }

    private ContainerSynchronization getContainerSynch() throws Exception {
        EntityContainer container = (EntityContainer)this.context_.getContainer();
        ContainerFactoryImpl containerFactory = (ContainerFactoryImpl)Switch.getSwitch().getContainerFactory();
        Transaction transaction = this.context_.getTransaction();
        if (transaction == null) {
            logger.log(Level.FINE, "Context transaction = null. Using invocation instead.");
            InvocationManager iMgr = Switch.getSwitch().getInvocationManager();
            ComponentInvocation i = iMgr.getCurrentInvocation();
            transaction = i.transaction;
        }
        if (transaction == null) {
            throw new Exception("transaction = null in getContainerSynch for timerId = " + this.getTimerId());
        }
        ContainerSynchronization containerSync = containerFactory.getContainerSync(transaction);
        return containerSync;
    }

    private static EJBTimerService getEJBTimerService() {
        ContainerFactoryImpl containerFactory = (ContainerFactoryImpl)Switch.getSwitch().getContainerFactory();
        return containerFactory.getEJBTimerService();
    }

    private void loadBlob() {
        EJBTimerService timerService = TimerBean.getEJBTimerService();
        ClassLoader cl = timerService.getTimerClassLoader(this.getContainerId());
        if (cl == null) {
            throw new EJBException("No timer classloader for " + this.getTimerId());
        }
        this.loadBlob(cl);
    }

    private void loadBlob(ClassLoader cl) {
        try {
            Blob blob = this.getBlob();
            this.timedObjectPrimaryKey_ = blob.getTimedObjectPrimaryKey(cl);
            this.info_ = blob.getInfo(cl);
            this.blobLoaded_ = true;
        }
        catch (Exception e) {
            EJBException ejbEx = new EJBException();
            ejbEx.initCause((Throwable)e);
            throw ejbEx;
        }
    }

    public void setEntityContext(EntityContext context) {
        this.context_ = (EJBContextImpl)context;
    }

    public void unsetEntityContext() {
        this.context_ = null;
    }

    public void ejbRemove() {
    }

    public void ejbLoad() {
        long lastExpirationRaw = this.getLastExpirationRaw();
        this.lastExpiration_ = lastExpirationRaw > 0L ? new Date(lastExpirationRaw) : null;
        this.creationTime_ = new Date(this.getCreationTimeRaw());
        this.initialExpiration_ = new Date(this.getInitialExpirationRaw());
        this.timedObjectPrimaryKey_ = null;
        this.info_ = null;
        this.blobLoaded_ = false;
    }

    public void ejbStore() {
    }

    public void ejbPassivate() {
    }

    public void ejbActivate() {
    }

    public boolean repeats() {
        return this.getIntervalDuration() > 0L;
    }

    public void cancel() throws Exception {
        if (this.getState() == 1) {
            return;
        }
        this.setState(1);
        if (this.timerOwnedByThisServer()) {
            TimerPrimaryKey timerId = new TimerPrimaryKey(this.getTimerId());
            Date nextTimeout = TimerBean.getEJBTimerService().cancelTask(timerId);
            ContainerSynchronization containerSynch = this.getContainerSynch();
            Synchronization timerSynch = containerSynch.getTimerSynchronization(timerId);
            if (timerSynch != null) {
                containerSynch.removeTimerSynchronization(timerId);
                TimerBean.getEJBTimerService().expungeTimer(timerId);
            } else {
                timerSynch = new TimerSynch(timerId, 1, nextTimeout, this.getContainer(this.getContainerId()));
                containerSynch.addTimerSynchronization(timerId, timerSynch);
            }
        }
    }

    public Serializable getInfo() {
        if (!this.blobLoaded_) {
            this.loadBlob();
        }
        return this.info_;
    }

    public Object getTimedObjectPrimaryKey() {
        if (!this.blobLoaded_) {
            this.loadBlob();
        }
        return this.timedObjectPrimaryKey_;
    }

    public Date getCreationTime() {
        return this.creationTime_;
    }

    public Date getInitialExpiration() {
        return this.initialExpiration_;
    }

    public Date getLastExpiration() {
        return this.lastExpiration_;
    }

    public void setLastExpiration(Date lastExpiration) {
        this.lastExpiration_ = lastExpiration;
        long lastExpirationRaw = lastExpiration != null ? lastExpiration.getTime() : 0L;
        this.setLastExpirationRaw(lastExpirationRaw);
    }

    public boolean isActive() {
        return this.getState() == 0;
    }

    public boolean isCancelled() {
        return this.getState() == 1;
    }

    private Set toPKeys(Set ids) {
        HashSet<TimerPrimaryKey> pkeys = new HashSet<TimerPrimaryKey>();
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            pkeys.add(new TimerPrimaryKey((String)iter.next()));
        }
        return pkeys;
    }

    public Set ejbHomeSelectTimerIdsByContainer(long containerId) throws FinderException {
        return this.toPKeys(this.ejbSelectTimerIdsByContainer(containerId));
    }

    public Set ejbHomeSelectActiveTimerIdsByContainer(long containerId) throws FinderException {
        return this.toPKeys(this.ejbSelectTimerIdsByContainerAndState(containerId, 0));
    }

    public Set ejbHomeSelectCancelledTimerIdsByContainer(long containerId) throws FinderException {
        return this.toPKeys(this.ejbSelectTimerIdsByContainerAndState(containerId, 1));
    }

    public Set ejbHomeSelectTimerIdsOwnedByThisServerByContainer(long containerId) throws FinderException {
        return this.toPKeys(this.ejbSelectTimerIdsByContainerAndOwner(containerId, this.getOwnerIdOfThisServer()));
    }

    public Set ejbHomeSelectActiveTimerIdsOwnedByThisServerByContainer(long containerId) throws FinderException {
        return this.toPKeys(this.ejbSelectTimerIdsByContainerAndOwnerAndState(containerId, this.getOwnerIdOfThisServer(), 0));
    }

    public Set ejbHomeSelectCancelledTimerIdsOwnedByThisServerByContainer(long containerId) throws FinderException {
        return this.toPKeys(this.ejbSelectTimerIdsByContainerAndOwnerAndState(containerId, this.getOwnerIdOfThisServer(), 1));
    }

    public Set ejbHomeSelectAllTimerIdsOwnedByThisServer() throws FinderException {
        return this.toPKeys(this.ejbSelectAllTimerIdsByOwner(this.getOwnerIdOfThisServer()));
    }

    public Set ejbHomeSelectAllActiveTimerIdsOwnedByThisServer() throws FinderException {
        return this.toPKeys(this.ejbSelectAllTimerIdsByOwnerAndState(this.getOwnerIdOfThisServer(), 0));
    }

    public Set ejbHomeSelectAllCancelledTimerIdsOwnedByThisServer() throws FinderException {
        return this.toPKeys(this.ejbSelectAllTimerIdsByOwnerAndState(this.getOwnerIdOfThisServer(), 1));
    }

    public Set ejbHomeSelectAllTimerIdsOwnedBy(String ownerId) throws FinderException {
        return this.toPKeys(this.ejbSelectAllTimerIdsByOwner(ownerId));
    }

    public Set ejbHomeSelectAllActiveTimerIdsOwnedBy(String ownerId) throws FinderException {
        return this.toPKeys(this.ejbSelectAllTimerIdsByOwnerAndState(ownerId, 0));
    }

    public Set ejbHomeSelectAllCancelledTimerIdsOwnedBy(String ownerId) throws FinderException {
        return this.toPKeys(this.ejbSelectAllTimerIdsByOwnerAndState(ownerId, 1));
    }

    public Set ejbHomeSelectTimersByContainer(long containerId) throws FinderException {
        return this.ejbSelectTimersByContainer(containerId);
    }

    public Set ejbHomeSelectActiveTimersByContainer(long containerId) throws FinderException {
        return this.ejbSelectTimersByContainerAndState(containerId, 0);
    }

    public Set ejbHomeSelectCancelledTimersByContainer(long containerId) throws FinderException {
        return this.ejbSelectTimersByContainerAndState(containerId, 1);
    }

    public Set ejbHomeSelectTimersOwnedByThisServerByContainer(long containerId) throws FinderException {
        return this.ejbSelectTimersByContainerAndOwner(containerId, this.getOwnerIdOfThisServer());
    }

    public Set ejbHomeSelectActiveTimersOwnedByThisServerByContainer(long containerId) throws FinderException {
        return this.ejbSelectTimersByContainerAndOwnerAndState(containerId, this.getOwnerIdOfThisServer(), 0);
    }

    public Set ejbHomeSelectCancelledTimersOwnedByThisServerByContainer(long containerId) throws FinderException {
        return this.ejbSelectTimersByContainerAndOwnerAndState(containerId, this.getOwnerIdOfThisServer(), 1);
    }

    public Set ejbHomeSelectAllTimersOwnedByThisServer() throws FinderException {
        return this.ejbSelectAllTimersByOwner(this.getOwnerIdOfThisServer());
    }

    public Set ejbHomeSelectAllActiveTimersOwnedByThisServer() throws FinderException {
        return this.ejbSelectAllTimersByOwnerAndState(this.getOwnerIdOfThisServer(), 0);
    }

    public Set ejbHomeSelectAllCancelledTimersOwnedByThisServer() throws FinderException {
        return this.ejbSelectAllTimersByOwnerAndState(this.getOwnerIdOfThisServer(), 1);
    }

    public Set ejbHomeSelectAllTimersOwnedBy(String ownerId) throws FinderException {
        return this.ejbSelectAllTimersByOwner(ownerId);
    }

    public Set ejbHomeSelectAllActiveTimersOwnedBy(String ownerId) throws FinderException {
        return this.ejbSelectAllTimersByOwnerAndState(ownerId, 0);
    }

    public Set ejbHomeSelectAllCancelledTimersOwnedBy(String ownerId) throws FinderException {
        return this.ejbSelectAllTimersByOwnerAndState(ownerId, 1);
    }

    public int ejbHomeSelectCountTimersByContainer(long containerId) throws FinderException {
        return this.ejbSelectCountTimersByContainer(containerId);
    }

    public int ejbHomeSelectCountActiveTimersByContainer(long containerId) throws FinderException {
        return this.ejbSelectCountTimersByContainerAndState(containerId, 0);
    }

    public int ejbHomeSelectCountCancelledTimersByContainer(long containerId) throws FinderException {
        return this.ejbSelectCountTimersByContainerAndState(containerId, 1);
    }

    public int ejbHomeSelectCountTimersOwnedByThisServerByContainer(long containerId) throws FinderException {
        return this.ejbSelectCountTimersByContainerAndOwner(containerId, this.getOwnerIdOfThisServer());
    }

    public int ejbHomeSelectCountActiveTimersOwnedByThisServerByContainer(long containerId) throws FinderException {
        return this.ejbSelectCountTimersByContainerAndOwnerAndState(containerId, this.getOwnerIdOfThisServer(), 0);
    }

    public int ejbHomeSelectCountCancelledTimersOwnedByThisServerByContainer(long containerId) throws FinderException {
        return this.ejbSelectCountTimersByContainerAndOwnerAndState(containerId, this.getOwnerIdOfThisServer(), 1);
    }

    public int ejbHomeSelectCountAllTimersOwnedByThisServer() throws FinderException {
        return this.ejbSelectCountAllTimersByOwner(this.getOwnerIdOfThisServer());
    }

    public int ejbHomeSelectCountAllActiveTimersOwnedByThisServer() throws FinderException {
        return this.ejbSelectCountAllTimersByOwnerAndState(this.getOwnerIdOfThisServer(), 0);
    }

    public int ejbHomeSelectCountAllCancelledTimersOwnedByThisServer() throws FinderException {
        return this.ejbSelectCountAllTimersByOwnerAndState(this.getOwnerIdOfThisServer(), 1);
    }

    public int ejbHomeSelectCountAllTimersOwnedBy(String ownerId) throws FinderException {
        return this.ejbSelectCountAllTimersByOwner(ownerId);
    }

    public int ejbHomeSelectCountAllActiveTimersOwnedBy(String ownerId) throws FinderException {
        return this.ejbSelectCountAllTimersByOwnerAndState(ownerId, 0);
    }

    public int ejbHomeSelectCountAllCancelledTimersOwnedBy(String ownerId) throws FinderException {
        return this.ejbSelectCountAllTimersByOwnerAndState(ownerId, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ejbHomeCheckStatus(String resourceJndiName, boolean checkDatabase) {
        boolean success = false;
        Connection connection = null;
        try {
            InitialContext ic = new InitialContext();
            DataSource dataSource = (DataSource)ic.lookup(resourceJndiName);
            if (checkDatabase) {
                connection = dataSource.getConnection();
                connection.close();
                connection = null;
                this.ejbSelectCountTimersByContainer(0L);
            }
            success = true;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "ejb.timer_service_init_error", "");
            logger.log(Level.FINE, "ejb.timer_service_init_error", e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "timer connection close exception", e);
                }
            }
        }
        return success;
    }

    public static void testCreate(String timerId, EJBContext context, String ownerId, Date initialExpiration, long intervalDuration, Serializable info) throws CreateException {
        EJBTimerService ejbTimerService = TimerBean.getEJBTimerService();
        TimerLocalHome timerLocalHome = ejbTimerService.getTimerBeanHome();
        EjbDescriptor ejbDesc = (EjbDescriptor)Switch.getSwitch().getDescriptorFor(((EJBContextImpl)context).getContainer());
        long containerId = ejbDesc.getUniqueId();
        Object timedObjectPrimaryKey = context instanceof EntityContext ? ((EntityContext)context).getPrimaryKey() : null;
        timerLocalHome.create(timerId, containerId, ownerId, timedObjectPrimaryKey, initialExpiration, intervalDuration, info);
    }

    public static void testMigrate(String fromOwnerId) {
        EJBTimerService ejbTimerService = TimerBean.getEJBTimerService();
        ejbTimerService.migrateTimers(fromOwnerId);
    }

    private BaseContainer getContainer(long containerId) {
        ContainerFactory cf = Switch.getSwitch().getContainerFactory();
        return (BaseContainer)cf.getContainer(containerId);
    }

    private static class TimerSynch
    implements Synchronization {
        private TimerPrimaryKey timerId_;
        private int state_;
        private Date timeout_;
        private BaseContainer container_;

        public TimerSynch(TimerPrimaryKey timerId, int state, Date timeout, BaseContainer container) {
            this.timerId_ = timerId;
            this.state_ = state;
            this.timeout_ = timeout;
            this.container_ = container;
        }

        public void afterCompletion(int status) {
            EJBTimerService timerService = TimerBean.getEJBTimerService();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "TimerSynch::afterCompletion. timer state = " + TimerBean.stateToString(this.state_) + " , " + "timer id = " + this.timerId_ + " , JTA TX status = " + TimerBean.txStatusToString(status) + " , " + "timeout = " + this.timeout_);
            }
            switch (this.state_) {
                case 0: {
                    if (status == 3) {
                        timerService.scheduleTask(this.timerId_, this.timeout_);
                        this.container_.incrementCreatedTimedObject();
                        break;
                    }
                    timerService.expungeTimer(this.timerId_);
                    break;
                }
                case 1: {
                    if (status == 4) {
                        if (this.timeout_ != null) {
                            timerService.scheduleTask(this.timerId_, this.timeout_);
                            break;
                        }
                        timerService.restoreTaskToDelivered(this.timerId_);
                        break;
                    }
                    timerService.expungeTimer(this.timerId_);
                    this.container_.incrementRemovedTimedObject();
                }
            }
        }

        public void beforeCompletion() {
        }
    }

    public static class Blob
    implements Serializable {
        private byte[] primaryKeyBytes_ = null;
        private byte[] infoBytes_ = null;

        public Blob() {
        }

        public Blob(Object primaryKey, Serializable info) throws IOException {
            if (primaryKey != null) {
                this.primaryKeyBytes_ = EJBUtils.serializeObject(primaryKey);
            }
            if (info != null) {
                this.infoBytes_ = EJBUtils.serializeObject(info);
            }
        }

        public Object getTimedObjectPrimaryKey(ClassLoader cl) throws Exception {
            Object pKey = null;
            if (this.primaryKeyBytes_ != null) {
                pKey = EJBUtils.deserializeObject(this.primaryKeyBytes_, cl);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Deserialized blob : " + pKey);
                }
            }
            return pKey;
        }

        public Serializable getInfo(ClassLoader cl) throws Exception {
            Serializable info = null;
            if (this.infoBytes_ != null) {
                info = (Serializable)EJBUtils.deserializeObject(this.infoBytes_, cl);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Deserialized blob : " + info);
                }
            }
            return info;
        }
    }
}

