/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor;

import com.sun.enterprise.admin.monitor.BaseMonitorMBean;
import com.sun.enterprise.admin.monitor.MonitorCommand;
import com.sun.enterprise.admin.monitor.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.MonitoringHelper;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;

public class MonitorListCommand
extends MonitorCommand {
    private static final int LIST_TYPE = 1;
    private static final int LIST_INSTANCE = 3;
    private static final int LIST_TYPE_AND_INSTANCE = 5;

    MonitorListCommand(ObjectName mbeanName) {
        this.objectName = mbeanName;
        this.actionCode = 5;
    }

    MonitorListCommand(ObjectName mbeanName, MonitoredObjectType type) {
        this.objectName = mbeanName;
        this.actionCode = 3;
        this.monitoredObjectType = type.getTypeName();
    }

    Object runCommand() throws InstanceNotFoundException {
        BaseMonitorMBean mbean = MonitoringHelper.getMonitorMBean(this.objectName);
        ArrayList childList = null;
        childList = this.actionCode == 3 ? mbean.getChildList(MonitoredObjectType.getMonitoredObjectType(this.monitoredObjectType)) : mbean.getChildList();
        String[] result = new String[childList.size()];
        Iterator iter = childList.iterator();
        int i = 0;
        while (iter.hasNext()) {
            BaseMonitorMBean child = (BaseMonitorMBean)iter.next();
            MonitoredObjectType childType = MonitoredObjectType.getMonitoredObjectType(child.getNodeType());
            result[i] = this.actionCode == 3 ? child.getNodeName() : (childType.isSingleton() ? child.getNodeType() : child.getNodeType() + "." + child.getNodeName());
            ++i;
        }
        return result;
    }
}

