/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.StaleWriteConfigException;
import com.sun.enterprise.config.serverbeans.AuditModule;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.MessageSecurityConfig;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.Serializable;
import java.util.Vector;
import org.netbeans.modules.schema2beans.BeanComparator;
import org.netbeans.modules.schema2beans.Common;
import org.netbeans.modules.schema2beans.ValidateException;
import org.netbeans.modules.schema2beans.Version;

public class SecurityService
extends ConfigBean
implements Serializable {
    static Vector comparators = new Vector();
    private static final Version runtimeVersion = new Version(4, 2, 0);
    public static final String AUTH_REALM = "AuthRealm";
    public static final String JACC_PROVIDER = "JaccProvider";
    public static final String AUDIT_MODULE = "AuditModule";
    public static final String MESSAGE_SECURITY_CONFIG = "MessageSecurityConfig";
    public static final String ELEMENT_PROPERTY = "ElementProperty";

    public SecurityService() {
        this(1);
    }

    public SecurityService(int options) {
        super(comparators, runtimeVersion);
        this.initPropertyTables(5);
        this.createProperty("auth-realm", AUTH_REALM, 66112, AuthRealm.class);
        this.createAttribute(AUTH_REALM, "name", "Name", 257, null, null);
        this.createAttribute(AUTH_REALM, "classname", "Classname", 257, null, null);
        this.createProperty("jacc-provider", JACC_PROVIDER, 66112, JaccProvider.class);
        this.createAttribute(JACC_PROVIDER, "name", "Name", 257, null, null);
        this.createAttribute(JACC_PROVIDER, "policy-provider", "PolicyProvider", 257, null, null);
        this.createAttribute(JACC_PROVIDER, "policy-configuration-factory-provider", "PolicyConfigurationFactoryProvider", 257, null, null);
        this.createProperty("audit-module", AUDIT_MODULE, 66096, AuditModule.class);
        this.createAttribute(AUDIT_MODULE, "name", "Name", 257, null, null);
        this.createAttribute(AUDIT_MODULE, "classname", "Classname", 257, null, null);
        this.createProperty("message-security-config", MESSAGE_SECURITY_CONFIG, 66096, MessageSecurityConfig.class);
        this.createAttribute(MESSAGE_SECURITY_CONFIG, "auth-layer", "AuthLayer", 257, null, null);
        this.createAttribute(MESSAGE_SECURITY_CONFIG, "default-provider", "DefaultProvider", 513, null, null);
        this.createAttribute(MESSAGE_SECURITY_CONFIG, "default-client-provider", "DefaultClientProvider", 513, null, null);
        this.createProperty("property", ELEMENT_PROPERTY, 66096, ElementProperty.class);
        this.createAttribute(ELEMENT_PROPERTY, "name", "Name", 257, null, null);
        this.createAttribute(ELEMENT_PROPERTY, "value", "Value", 257, null, null);
        this.initialize(options);
    }

    void initialize(int options) {
    }

    public void setAuthRealm(int index, AuthRealm value) {
        this.setValue(AUTH_REALM, index, value);
    }

    public AuthRealm getAuthRealm(int index) {
        return (AuthRealm)this.getValue(AUTH_REALM, index);
    }

    public void setAuthRealm(AuthRealm[] value) {
        this.setValue(AUTH_REALM, value);
    }

    public AuthRealm[] getAuthRealm() {
        return (AuthRealm[])this.getValues(AUTH_REALM);
    }

    public int sizeAuthRealm() {
        return this.size(AUTH_REALM);
    }

    public int addAuthRealm(AuthRealm value) throws ConfigException {
        return this.addAuthRealm(value, true);
    }

    public int addAuthRealm(AuthRealm value, boolean overwrite) throws ConfigException {
        AuthRealm old = this.getAuthRealmByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(SecurityService.class).getString("cannotAddDuplicate", AUTH_REALM));
        }
        return this.addValue(AUTH_REALM, value, overwrite);
    }

    public int removeAuthRealm(AuthRealm value) {
        return this.removeValue(AUTH_REALM, value);
    }

    public int removeAuthRealm(AuthRealm value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(AUTH_REALM, value, overwrite);
    }

    public AuthRealm getAuthRealmByName(String id) {
        AuthRealm[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getAuthRealm()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)"name")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public void setJaccProvider(int index, JaccProvider value) {
        this.setValue(JACC_PROVIDER, index, value);
    }

    public JaccProvider getJaccProvider(int index) {
        return (JaccProvider)this.getValue(JACC_PROVIDER, index);
    }

    public void setJaccProvider(JaccProvider[] value) {
        this.setValue(JACC_PROVIDER, value);
    }

    public JaccProvider[] getJaccProvider() {
        return (JaccProvider[])this.getValues(JACC_PROVIDER);
    }

    public int sizeJaccProvider() {
        return this.size(JACC_PROVIDER);
    }

    public int addJaccProvider(JaccProvider value) throws ConfigException {
        return this.addJaccProvider(value, true);
    }

    public int addJaccProvider(JaccProvider value, boolean overwrite) throws ConfigException {
        JaccProvider old = this.getJaccProviderByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(SecurityService.class).getString("cannotAddDuplicate", JACC_PROVIDER));
        }
        return this.addValue(JACC_PROVIDER, value, overwrite);
    }

    public int removeJaccProvider(JaccProvider value) {
        return this.removeValue(JACC_PROVIDER, value);
    }

    public int removeJaccProvider(JaccProvider value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(JACC_PROVIDER, value, overwrite);
    }

    public JaccProvider getJaccProviderByName(String id) {
        JaccProvider[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getJaccProvider()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)"name")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public void setAuditModule(int index, AuditModule value) {
        this.setValue(AUDIT_MODULE, index, value);
    }

    public AuditModule getAuditModule(int index) {
        return (AuditModule)this.getValue(AUDIT_MODULE, index);
    }

    public void setAuditModule(AuditModule[] value) {
        this.setValue(AUDIT_MODULE, value);
    }

    public AuditModule[] getAuditModule() {
        return (AuditModule[])this.getValues(AUDIT_MODULE);
    }

    public int sizeAuditModule() {
        return this.size(AUDIT_MODULE);
    }

    public int addAuditModule(AuditModule value) throws ConfigException {
        return this.addAuditModule(value, true);
    }

    public int addAuditModule(AuditModule value, boolean overwrite) throws ConfigException {
        AuditModule old = this.getAuditModuleByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(SecurityService.class).getString("cannotAddDuplicate", AUDIT_MODULE));
        }
        return this.addValue(AUDIT_MODULE, value, overwrite);
    }

    public int removeAuditModule(AuditModule value) {
        return this.removeValue(AUDIT_MODULE, value);
    }

    public int removeAuditModule(AuditModule value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(AUDIT_MODULE, value, overwrite);
    }

    public AuditModule getAuditModuleByName(String id) {
        AuditModule[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getAuditModule()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)"name")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public void setMessageSecurityConfig(int index, MessageSecurityConfig value) {
        this.setValue(MESSAGE_SECURITY_CONFIG, index, value);
    }

    public MessageSecurityConfig getMessageSecurityConfig(int index) {
        return (MessageSecurityConfig)this.getValue(MESSAGE_SECURITY_CONFIG, index);
    }

    public void setMessageSecurityConfig(MessageSecurityConfig[] value) {
        this.setValue(MESSAGE_SECURITY_CONFIG, value);
    }

    public MessageSecurityConfig[] getMessageSecurityConfig() {
        return (MessageSecurityConfig[])this.getValues(MESSAGE_SECURITY_CONFIG);
    }

    public int sizeMessageSecurityConfig() {
        return this.size(MESSAGE_SECURITY_CONFIG);
    }

    public int addMessageSecurityConfig(MessageSecurityConfig value) throws ConfigException {
        return this.addMessageSecurityConfig(value, true);
    }

    public int addMessageSecurityConfig(MessageSecurityConfig value, boolean overwrite) throws ConfigException {
        MessageSecurityConfig old = this.getMessageSecurityConfigByAuthLayer(value.getAuthLayer());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(SecurityService.class).getString("cannotAddDuplicate", MESSAGE_SECURITY_CONFIG));
        }
        return this.addValue(MESSAGE_SECURITY_CONFIG, value, overwrite);
    }

    public int removeMessageSecurityConfig(MessageSecurityConfig value) {
        return this.removeValue(MESSAGE_SECURITY_CONFIG, value);
    }

    public int removeMessageSecurityConfig(MessageSecurityConfig value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(MESSAGE_SECURITY_CONFIG, value, overwrite);
    }

    public MessageSecurityConfig getMessageSecurityConfigByAuthLayer(String id) {
        MessageSecurityConfig[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getMessageSecurityConfig()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)"auth-layer")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public void setElementProperty(int index, ElementProperty value) {
        this.setValue(ELEMENT_PROPERTY, index, value);
    }

    public ElementProperty getElementProperty(int index) {
        return (ElementProperty)this.getValue(ELEMENT_PROPERTY, index);
    }

    public void setElementProperty(ElementProperty[] value) {
        this.setValue(ELEMENT_PROPERTY, value);
    }

    public ElementProperty[] getElementProperty() {
        return (ElementProperty[])this.getValues(ELEMENT_PROPERTY);
    }

    public int sizeElementProperty() {
        return this.size(ELEMENT_PROPERTY);
    }

    public int addElementProperty(ElementProperty value) throws ConfigException {
        return this.addElementProperty(value, true);
    }

    public int addElementProperty(ElementProperty value, boolean overwrite) throws ConfigException {
        ElementProperty old = this.getElementPropertyByName(value.getName());
        if (old != null) {
            throw new ConfigException(StringManager.getManager(SecurityService.class).getString("cannotAddDuplicate", ELEMENT_PROPERTY));
        }
        return this.addValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public int removeElementProperty(ElementProperty value) {
        return this.removeValue(ELEMENT_PROPERTY, value);
    }

    public int removeElementProperty(ElementProperty value, boolean overwrite) throws StaleWriteConfigException {
        return this.removeValue(ELEMENT_PROPERTY, value, overwrite);
    }

    public ElementProperty getElementPropertyByName(String id) {
        ElementProperty[] o;
        if (null != id) {
            id = id.trim();
        }
        if ((o = this.getElementProperty()) == null) {
            return null;
        }
        for (int i = 0; i < o.length; ++i) {
            if (!o[i].getAttributeValue(Common.convertName((String)"name")).equals(id)) continue;
            return o[i];
        }
        return null;
    }

    public String getDefaultRealm() {
        return this.getAttributeValue("default-realm");
    }

    public void setDefaultRealm(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("default-realm", v, overwrite);
    }

    public void setDefaultRealm(String v) {
        this.setAttributeValue("default-realm", v);
    }

    public static String getDefaultDefaultRealm() {
        return "file".trim();
    }

    public String getDefaultPrincipal() {
        return this.getAttributeValue("default-principal");
    }

    public void setDefaultPrincipal(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("default-principal", v, overwrite);
    }

    public void setDefaultPrincipal(String v) {
        this.setAttributeValue("default-principal", v);
    }

    public String getDefaultPrincipalPassword() {
        return this.getAttributeValue("default-principal-password");
    }

    public void setDefaultPrincipalPassword(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("default-principal-password", v, overwrite);
    }

    public void setDefaultPrincipalPassword(String v) {
        this.setAttributeValue("default-principal-password", v);
    }

    public String getAnonymousRole() {
        return this.getAttributeValue("anonymous-role");
    }

    public void setAnonymousRole(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("anonymous-role", v, overwrite);
    }

    public void setAnonymousRole(String v) {
        this.setAttributeValue("anonymous-role", v);
    }

    public static String getDefaultAnonymousRole() {
        return "ANYONE".trim();
    }

    public boolean isAuditEnabled() {
        return SecurityService.toBoolean(this.getAttributeValue("audit-enabled"));
    }

    public void setAuditEnabled(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("audit-enabled", "" + v, overwrite);
    }

    public void setAuditEnabled(boolean v) {
        this.setAttributeValue("audit-enabled", "" + v);
    }

    public static String getDefaultAuditEnabled() {
        return "false".trim();
    }

    public String getJacc() {
        return this.getAttributeValue("jacc");
    }

    public void setJacc(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("jacc", v, overwrite);
    }

    public void setJacc(String v) {
        this.setAttributeValue("jacc", v);
    }

    public static String getDefaultJacc() {
        return "default".trim();
    }

    public String getAuditModules() {
        return this.getAttributeValue("audit-modules");
    }

    public void setAuditModules(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("audit-modules", v, overwrite);
    }

    public void setAuditModules(String v) {
        this.setAttributeValue("audit-modules", v);
    }

    public static String getDefaultAuditModules() {
        return "default".trim();
    }

    public boolean isActivateDefaultPrincipalToRoleMapping() {
        return SecurityService.toBoolean(this.getAttributeValue("activate-default-principal-to-role-mapping"));
    }

    public void setActivateDefaultPrincipalToRoleMapping(boolean v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("activate-default-principal-to-role-mapping", "" + v, overwrite);
    }

    public void setActivateDefaultPrincipalToRoleMapping(boolean v) {
        this.setAttributeValue("activate-default-principal-to-role-mapping", "" + v);
    }

    public static String getDefaultActivateDefaultPrincipalToRoleMapping() {
        return "false".trim();
    }

    public String getMappedPrincipalClass() {
        return this.getAttributeValue("mapped-principal-class");
    }

    public void setMappedPrincipalClass(String v, boolean overwrite) throws StaleWriteConfigException {
        this.setAttributeValue("mapped-principal-class", v, overwrite);
    }

    public void setMappedPrincipalClass(String v) {
        this.setAttributeValue("mapped-principal-class", v);
    }

    public AuthRealm newAuthRealm() {
        return new AuthRealm();
    }

    public JaccProvider newJaccProvider() {
        return new JaccProvider();
    }

    public AuditModule newAuditModule() {
        return new AuditModule();
    }

    public MessageSecurityConfig newMessageSecurityConfig() {
        return new MessageSecurityConfig();
    }

    public ElementProperty newElementProperty() {
        return new ElementProperty();
    }

    protected String getRelativeXPath() {
        String ret = null;
        ret = "security-service";
        return null != ret ? ret.trim() : null;
    }

    public static String getDefaultAttributeValue(String attr) {
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).equals("default-realm")) {
            return "file".trim();
        }
        if (attr.equals("anonymous-role")) {
            return "ANYONE".trim();
        }
        if (attr.equals("audit-enabled")) {
            return "false".trim();
        }
        if (attr.equals("jacc")) {
            return "default".trim();
        }
        if (attr.equals("audit-modules")) {
            return "default".trim();
        }
        if (attr.equals("activate-default-principal-to-role-mapping")) {
            return "false".trim();
        }
        return null;
    }

    public static void addComparator(BeanComparator c) {
        comparators.add(c);
    }

    public static void removeComparator(BeanComparator c) {
        comparators.remove(c);
    }

    public void validate() throws ValidateException {
    }

    public void dump(StringBuffer str, String indent) {
        ConfigBean n;
        int i;
        str.append(indent);
        str.append("AuthRealm[" + this.sizeAuthRealm() + "]");
        for (i = 0; i < this.sizeAuthRealm(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getAuthRealm(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(AUTH_REALM, i, str, indent);
        }
        str.append(indent);
        str.append("JaccProvider[" + this.sizeJaccProvider() + "]");
        for (i = 0; i < this.sizeJaccProvider(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getJaccProvider(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(JACC_PROVIDER, i, str, indent);
        }
        str.append(indent);
        str.append("AuditModule[" + this.sizeAuditModule() + "]");
        for (i = 0; i < this.sizeAuditModule(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getAuditModule(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(AUDIT_MODULE, i, str, indent);
        }
        str.append(indent);
        str.append("MessageSecurityConfig[" + this.sizeMessageSecurityConfig() + "]");
        for (i = 0; i < this.sizeMessageSecurityConfig(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getMessageSecurityConfig(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(MESSAGE_SECURITY_CONFIG, i, str, indent);
        }
        str.append(indent);
        str.append("ElementProperty[" + this.sizeElementProperty() + "]");
        for (i = 0; i < this.sizeElementProperty(); ++i) {
            str.append(indent + "\t");
            str.append("#" + i + ":");
            n = this.getElementProperty(i);
            if (n != null) {
                n.dump(str, indent + "\t");
            } else {
                str.append(indent + "\tnull");
            }
            this.dumpAttributes(ELEMENT_PROPERTY, i, str, indent);
        }
    }

    public String dumpBeanNode() {
        StringBuffer str = new StringBuffer();
        str.append("SecurityService\n");
        this.dump(str, "\n  ");
        return str.toString();
    }
}

