/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.selfmanagement;

import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.selfmanagement.ManagementRuleEvent;
import com.sun.enterprise.admin.selfmanagement.event.EventBuilder;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.serverbeans.Action;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.Event;
import com.sun.enterprise.config.serverbeans.ManagementRule;
import com.sun.enterprise.config.serverbeans.ManagementRules;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.management.selfmanagement.RuleManager;
import com.sun.enterprise.management.selfmanagement.reconfig.ManagementRuleReconfig;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;

public class SelfManagementService
implements ServerLifecycle {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.selfmanagement");
    private static SelfManagementService serviceInstance = null;
    private RuleManager rulesManager = null;
    private EventBuilder eventBuilder = null;
    private boolean isServiceEnabled = false;

    public void onInitialization(ServerContext sc) throws ServerLifecycleException {
        String RULES_MAIL_SMTP_HOST = "mail.smtp.host";
        String RULES_ALERT_RECIPIENTS = "rules.recipients";
        this.rulesManager = new RuleManager(this);
        this.eventBuilder = EventBuilder.getInstance();
        _logger.log(Level.FINE, "smgt.service_init");
        String mailSMTPHost = System.getProperty("mail.smtp.host");
        String alertRecip = System.getProperty("rules.recipients");
        this.rulesManager.setMailSMTPHost(mailSMTPHost);
        this.rulesManager.setRecipients(alertRecip);
        serviceInstance = this;
        _logger.log(Level.INFO, "sgmt.service_initialized");
    }

    public void onReady(ServerContext sc) throws ServerLifecycleException {
        try {
            ConfigContext instanceConfigContext = sc.getConfigContext();
            Config instanceConfig = ServerBeansFactory.getConfigBean(instanceConfigContext);
            ManagementRules selfManagementRules = instanceConfig.getManagementRules();
            if (selfManagementRules != null) {
                if (selfManagementRules.isEnabled()) {
                    _logger.log(Level.INFO, "smgt.service_enabled");
                    this.isServiceEnabled = true;
                    ManagementRule[] rules = selfManagementRules.getManagementRule();
                    if (rules != null) {
                        for (int i = 0; i < rules.length; ++i) {
                            ManagementRule rule = rules[i];
                            String ruleName = rule.getName();
                            String ruleDescription = rule.getDescription();
                            if (rule.isEnabled()) {
                                this.addRule(rule, null);
                                continue;
                            }
                            _logger.log(Level.INFO, "smgt.service_rule_disabled", new Object[]{ruleName, ruleDescription});
                            this.addDisabledRule(rule);
                        }
                    } else {
                        _logger.log(Level.INFO, "smgt.service_no_rules_defined");
                    }
                } else {
                    _logger.log(Level.INFO, "smgt.service_disabled");
                }
            } else {
                _logger.log(Level.INFO, "smgt.service_not_configured");
            }
            AdminEventListenerRegistry.addEventListener(ManagementRuleEvent.eventType, new ManagementRuleReconfig());
        }
        catch (ConfigException ex) {
            _logger.log(Level.SEVERE, "smgt.config_error", ex);
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "sgmt.config_error, ex");
        }
    }

    public void onStartup(ServerContext sc) throws ServerLifecycleException {
        _logger.log(Level.FINE, "smgt.service_onready");
    }

    public void onShutdown() throws ServerLifecycleException {
        _logger.log(Level.FINE, "smgt.service_ontermination");
    }

    public void onTermination() throws ServerLifecycleException {
        _logger.log(Level.FINE, "smgt.service_onshutdown");
    }

    private com.sun.enterprise.admin.selfmanagement.event.Event checkEventExist(String type, ElementProperty[] eventProps) {
        com.sun.enterprise.admin.selfmanagement.event.Event event = this.rulesManager.checkEventExists(type, eventProps);
        return event;
    }

    public void addRule(ManagementRule rule, ConfigContext ctxToUse) {
        String actionMBeanName = null;
        boolean isSkip = false;
        String ruleName = rule.getName();
        String ruleDescription = rule.getDescription();
        try {
            int ATTRIB_COUNT = 3;
            Event event = null;
            com.sun.enterprise.admin.selfmanagement.event.Event ruleEvent = null;
            HashMap<String, String> logHandback = new HashMap<String, String>(3);
            _logger.log(Level.INFO, "smgt.service_rule_enabled", new Object[]{ruleName, ruleDescription});
            event = rule.getEvent();
            String type = event.getType();
            String description = event.getDescription();
            logHandback.put("type", type);
            logHandback.put("record-event", String.valueOf(event.isRecordEvent()));
            logHandback.put("level", event.getLevel());
            ElementProperty[] eventProps = event.getElementProperty();
            ruleEvent = this.getEvent(type, eventProps, description, ruleName);
            if (ruleEvent == null) {
                return;
            }
            Action ruleAction = rule.getAction();
            if (ruleAction != null) {
                actionMBeanName = ruleAction.getActionMbeanName();
            }
            this.rulesManager.addRule(ruleName, description, ruleEvent, actionMBeanName, logHandback, ctxToUse);
        }
        catch (InstanceNotFoundException ex) {
            _logger.log(Level.INFO, "smgt.internal_error", ex);
        }
    }

    public void deleteRule(String rule) {
        this.rulesManager.deleteRule(rule);
    }

    public void addDisabledRule(ManagementRule rule) {
        String ruleName = rule.getName();
        String ruleDescription = rule.getDescription();
        this.rulesManager.addDisabledRule(ruleName, ruleDescription);
    }

    private com.sun.enterprise.admin.selfmanagement.event.Event getEvent(String type, ElementProperty[] eventProps, String description, String ruleName) {
        com.sun.enterprise.admin.selfmanagement.event.Event eventInstance = null;
        try {
            eventInstance = this.eventBuilder.getEvent(type, eventProps, description);
        }
        catch (IllegalArgumentException ex) {
            _logger.log(Level.INFO, "smgt.errorenous_event", new Object[]{ruleName, type});
        }
        return eventInstance;
    }

    public static SelfManagementService getService() {
        return serviceInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRulesUpdate(ConfigContext cfgCtx, ConfigUpdate configUp) throws Exception {
        Set attributesChg = configUp.getAttributeSet();
        for (String attribute : attributesChg) {
            SelfManagementService selfManagementService;
            if (!attribute.equals("enabled")) continue;
            String newValue = configUp.getNewValue(attribute);
            if (this.isServiceEnabled && newValue.equals("false")) {
                _logger.log(Level.INFO, "sgmt.disableservice");
                selfManagementService = this;
                synchronized (selfManagementService) {
                    this.isServiceEnabled = false;
                    this.rulesManager.disableService();
                    continue;
                }
            }
            if (this.isServiceEnabled || !newValue.equals("true")) continue;
            _logger.log(Level.INFO, "sgmt.enableservice");
            selfManagementService = this;
            synchronized (selfManagementService) {
                this.isServiceEnabled = true;
                this.handleEnableService(cfgCtx);
            }
        }
    }

    public void handleActionAdd(ManagementRule rule, ConfigContext ctxToUse) throws Exception {
        String ruleName = rule.getName();
        String description = rule.getDescription();
        Action actionToAdd = rule.getAction();
        if (actionToAdd != null) {
            String actionName = actionToAdd.getActionMbeanName();
            if (this.isServiceEnabled && rule.isEnabled()) {
                if (actionName != null) {
                    this.rulesManager.addAction(ruleName, actionName, ctxToUse);
                }
            } else {
                _logger.log(Level.INFO, "smgt.erroraddaction_notenabled", new Object[]{ruleName, actionName});
            }
        } else {
            _logger.log(Level.SEVERE, "smgt.error_add_noactionreceived", new Object[]{ruleName, description});
            throw new RuntimeException();
        }
    }

    public void handleActionUpdate(ManagementRule rule, ConfigUpdate configUp) {
    }

    public void handleRuleUpdate(ManagementRule rule, ConfigUpdate configUp, ConfigContext ctxToUse) throws Exception {
        this.rulesManager.updateRule(rule, configUp, ctxToUse);
    }

    void handleEnableService(ConfigContext configCtx) {
        try {
            ManagementRule[] rules;
            Config instanceConfig = ServerBeansFactory.getConfigBean(configCtx);
            ManagementRules selfManagementRules = instanceConfig.getManagementRules();
            for (ManagementRule rule : rules = selfManagementRules.getManagementRule()) {
                if (rule.isEnabled()) {
                    this.addRule(rule, configCtx);
                    continue;
                }
                this.addDisabledRule(rule);
            }
        }
        catch (ConfigException ex) {
            _logger.log(Level.WARNING, "sgmt.error_enableservice", ex);
        }
    }

    boolean isServiceEnabled() {
        return this.isServiceEnabled;
    }
}

