/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceBase;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.util.Utility;
import java.io.Serializable;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.XADataSource;

public class JdbcConnectionPool
extends J2EEResourceBase
implements Serializable {
    private String userName_;
    private String password_;
    private String datasourceClassname_;
    private String steadyPoolSize_;
    private String maxPoolSize_;
    private String maxWaitTimeInMillis_;
    private String poolResizeQuantity_;
    private String idleTimeoutInSeconds_;
    private boolean isConnectionValidationRequired_;
    private String connectionValidationMethod_;
    private String validationTableName_;
    private boolean failAllConnections_;
    private boolean perfMonitor = false;
    private String resType_;
    private String transactionIsolationLevel_;
    private boolean isIsolationLevelGuaranteed_;
    private transient Object cachedVendorDataSource = null;
    private boolean noNonTxOps = false;

    public JdbcConnectionPool(String name) {
        super(name);
    }

    protected J2EEResource doClone(String name) {
        JdbcConnectionPool clone = new JdbcConnectionPool(name);
        clone.setUserName(this.getUserName());
        clone.setPassword(this.getPassword());
        clone.setDatasourceClassname(this.getDatasourceClassname());
        clone.setMaxPoolSize(this.getMaxPoolSize());
        clone.setMaxWaitTimeInMillis(this.getMaxWaitTimeInMillis());
        clone.setPoolResizeQuantity(this.getPoolResizeQuantity());
        clone.setIdleTimeoutInSeconds(this.getIdleTimeoutInSeconds());
        clone.setIsConnectionValidationRequired(this.isIsConnectionValidationRequired());
        clone.setConnectionValidationMethod(this.getConnectionValidationMethod());
        clone.setValidationTableName(this.getValidationTableName());
        clone.setFailAllConnections(this.isFailAllConnections());
        clone.setResType(this.getResType());
        clone.setTransactionIsolationLevel(this.getTransactionIsolationLevel());
        clone.setIsIsolationLevelGuaranteed(this.isIsolationLevelGuaranteed());
        return clone;
    }

    public int getType() {
        return 8;
    }

    public String getUserName() {
        return this.userName_;
    }

    public void setUserName(String userName) {
        this.userName_ = userName;
    }

    public String getPassword() {
        return this.password_;
    }

    public void setPassword(String password) {
        this.password_ = password;
    }

    public String getDatasourceClassname() {
        return this.datasourceClassname_;
    }

    public void setDatasourceClassname(String datasourceClassname) {
        this.datasourceClassname_ = datasourceClassname;
    }

    public String getSteadyPoolSize() {
        return this.steadyPoolSize_;
    }

    public void setSteadyPoolSize(String steadyPoolSize) {
        this.steadyPoolSize_ = steadyPoolSize;
    }

    public String getMaxPoolSize() {
        return this.maxPoolSize_;
    }

    public void setMaxPoolSize(String maxPoolSize) {
        this.maxPoolSize_ = maxPoolSize;
    }

    public String getMaxWaitTimeInMillis() {
        return this.maxWaitTimeInMillis_;
    }

    public void setMaxWaitTimeInMillis(String maxWaitTimeInMillis) {
        this.maxWaitTimeInMillis_ = maxWaitTimeInMillis;
    }

    public String getPoolResizeQuantity() {
        return this.poolResizeQuantity_;
    }

    public void setPoolResizeQuantity(String poolResizeQuantity) {
        this.poolResizeQuantity_ = poolResizeQuantity;
    }

    public String getIdleTimeoutInSeconds() {
        return this.idleTimeoutInSeconds_;
    }

    public void setIdleTimeoutInSeconds(String idleTimeoutInSeconds) {
        this.idleTimeoutInSeconds_ = idleTimeoutInSeconds;
    }

    public boolean isIsConnectionValidationRequired() {
        return this.isConnectionValidationRequired_;
    }

    public void setIsConnectionValidationRequired(boolean isConnectionValidationRequired) {
        this.isConnectionValidationRequired_ = isConnectionValidationRequired;
    }

    public String getConnectionValidationMethod() {
        return this.connectionValidationMethod_;
    }

    public void setConnectionValidationMethod(String connectionValidationMethod) {
        this.connectionValidationMethod_ = connectionValidationMethod;
    }

    public String getValidationTableName() {
        return this.validationTableName_;
    }

    public void setValidationTableName(String validationTableName) {
        this.validationTableName_ = validationTableName;
    }

    public boolean isFailAllConnections() {
        return this.failAllConnections_;
    }

    public void setFailAllConnections(boolean failAllConnections) {
        this.failAllConnections_ = failAllConnections;
    }

    public String getResType() {
        return this.resType_;
    }

    public void setResType(String resType) {
        this.resType_ = resType;
    }

    public String getTransactionIsolationLevel() {
        return this.transactionIsolationLevel_;
    }

    public void setTransactionIsolationLevel(String transactionIsolationLevel) {
        this.transactionIsolationLevel_ = transactionIsolationLevel;
    }

    public boolean isIsolationLevelGuaranteed() {
        return this.isIsolationLevelGuaranteed_;
    }

    public void setIsIsolationLevelGuaranteed(boolean isIsolationLevelGuaranteed) {
        this.isIsolationLevelGuaranteed_ = isIsolationLevelGuaranteed;
    }

    public String toString() {
        return "< JDBC Connection Pool : " + this.getName() + "... >";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createDataSource() throws J2EEResourceException {
        JdbcConnectionPool jdbcConnectionPool = this;
        synchronized (jdbcConnectionPool) {
            if (this.cachedVendorDataSource == null) {
                try {
                    Class dataSourceClass = Utility.loadClass(this.getDatasourceClassname());
                    this.cachedVendorDataSource = dataSourceClass.newInstance();
                    for (ResourceProperty next : this.getProperties()) {
                        Utility.invokeSetMethodCaseInsensitive(this.cachedVendorDataSource, next.getName(), next.getValue().toString());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new J2EEResourceException(e);
                }
            }
        }
        return this.cachedVendorDataSource;
    }

    public boolean isXA() {
        boolean tf = false;
        if (this.resType_ == null) {
            return false;
        }
        if (this.resType_.equals("javax.sql.XADataSource") && this.datasourceClassname_ != null) {
            try {
                Class dsClass = Utility.loadClass(this.getDatasourceClassname());
                if (XADataSource.class.isAssignableFrom(dsClass)) {
                    tf = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return tf;
    }

    public boolean isCP() {
        boolean tf = false;
        if (this.resType_ == null) {
            return false;
        }
        if (this.resType_.equals("javax.sql.ConnectionPoolDataSource") && this.datasourceClassname_ != null) {
            try {
                Class dsClass = Utility.loadClass(this.getDatasourceClassname());
                if (ConnectionPoolDataSource.class.isAssignableFrom(dsClass)) {
                    tf = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return tf;
    }

    public void addProperty(ResourceProperty property) {
        String propName = property.getName();
        if (propName.equalsIgnoreCase("user")) {
            this.setUserName((String)property.getValue());
        } else if (propName.equalsIgnoreCase("password")) {
            this.setPassword((String)property.getValue());
        }
        if (propName.equalsIgnoreCase("xa-driver-does-not-support-non-tx-operations")) {
            if (((String)property.getValue()).equalsIgnoreCase("true")) {
                this.noNonTxOps = true;
            }
            return;
        }
        if (propName.equalsIgnoreCase("perf-monitor")) {
            if (((String)property.getValue()).equalsIgnoreCase("true")) {
                this.perfMonitor = true;
            }
            return;
        }
        super.addProperty(property);
    }

    public boolean isPerfMonitor() {
        return this.perfMonitor;
    }

    public boolean getNoNonTxOps() {
        return this.noNonTxOps;
    }
}

