/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.resource.AbstractResourcePool;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import javax.transaction.Transaction;

public class AssocWithThreadResourcePool
extends AbstractResourcePool {
    private static ThreadLocal<ResourceHandle> localResource = new ThreadLocal();

    public AssocWithThreadResourcePool(String poolName) throws PoolingException {
        super(poolName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResourceHandle prefetch(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) {
        ResourceHandle ar = localResource.get();
        if (ar != null) {
            Object object = ar.lock;
            synchronized (object) {
                if (ar.getThreadId() != Thread.currentThread().getId() || ar.hasConnectionErrorOccurred() || ar.isDirty() || !ar.isAssociated()) {
                    localResource.remove();
                    return null;
                }
                if (ar.getResourceState().isFree() && ar.getResourceState().isUnenlisted()) {
                    if (this.matchConnections) {
                        if (!alloc.matchConnection(ar)) {
                            localResource.remove();
                            ar.setAssociated(false);
                            if (this.monitoringEnabled) {
                                this.poolCounters.incrementNumConnNotSuccessfullyMatched();
                            }
                            return null;
                        }
                        if (this.monitoringEnabled) {
                            this.poolCounters.incrementNumConnSuccessfullyMatched();
                        }
                    }
                    ar.getResourceState().setBusy(true);
                    return ar;
                }
            }
        }
        return null;
    }

    private void setInThreadLocal(ResourceHandle h) {
        if (h != null) {
            h.setThreadId(Thread.currentThread().getId());
            h.setAssociated(true);
            localResource.set(h);
        }
    }

    protected boolean isResourceUnused(ResourceHandle h) {
        return h.getResourceState().isFree() && !h.isAssociated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized ResourceHandle getUnenlistedResource(ResourceSpec spec, ResourceAllocator alloc, Transaction tran) throws PoolingException {
        ResourceHandle result = null;
        result = super.getUnenlistedResource(spec, alloc, tran);
        if (result == null) {
            for (ResourceHandle h : this.resources) {
                Object object = h.lock;
                synchronized (object) {
                    if (h.getResourceState().isUnenlisted() && h.getResourceState().isFree()) {
                        if (this.matchConnections) {
                            if (!alloc.matchConnection(h)) {
                                if (this.monitoringEnabled) {
                                    this.poolCounters.incrementNumConnNotSuccessfullyMatched();
                                }
                                continue;
                            }
                            if (this.monitoringEnabled) {
                                this.poolCounters.incrementNumConnSuccessfullyMatched();
                            }
                        }
                        if (h.hasConnectionErrorOccurred()) {
                            continue;
                        }
                        result = h;
                        result.getResourceState().setBusy(true);
                        result.setAssociated(false);
                        break;
                    }
                }
            }
        }
        if (localResource.get() == null) {
            this.setInThreadLocal(result);
        }
        return result;
    }

    protected synchronized void freeUnenlistedResource(ResourceHandle h) {
        if (!h.isAssociated()) {
            this.free.add(h);
        }
        this.notifyWaitingThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyResource(ResourceHandle resourceHandle) {
        try {
            super.destroyResource(resourceHandle);
        }
        finally {
            Object object = resourceHandle.lock;
            synchronized (object) {
                resourceHandle.setDirty();
            }
        }
    }
}

