/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.jauth;

import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageDescriptor;
import com.sun.enterprise.deployment.runtime.common.MessageSecurityDescriptor;
import com.sun.enterprise.deployment.runtime.common.ProtectionDescriptor;
import com.sun.enterprise.security.jauth.AuthPolicy;
import com.sun.enterprise.webservice.WsUtil;
import com.sun.logging.LogDomains;
import com.sun.xml.rpc.spi.runtime.StreamingHandler;
import com.sun.xml.ws.handler.SHDSOAPMessageContext;
import com.sun.xml.ws.spi.runtime.Invoker;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public class BaseAuthConfig {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    private Object defaultContext_;
    private MessageSecurityDescriptor superMSD_;
    private int superIndex_;
    private ArrayList contexts_;
    private ArrayList messageSecurityDescriptors_;
    private ArrayList contextsForOpcodes_;
    private HashMap contextsForOpNames_;
    private boolean onePolicy_;
    private Object contextLock = new Object();
    private ExplicitNull explicitNull = new ExplicitNull();
    private static QName[] mechanisms = new QName[]{new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security", "wsse")};

    protected BaseAuthConfig(Object context) {
        this.defaultContext_ = context;
        this.superMSD_ = null;
        this.superIndex_ = -1;
        this.messageSecurityDescriptors_ = null;
        this.contexts_ = null;
        this.contextsForOpcodes_ = null;
        this.contextsForOpNames_ = null;
        this.onePolicy_ = true;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("WSS: New BAC defaultContext: " + this.defaultContext_);
        }
    }

    protected BaseAuthConfig(ArrayList descriptors, ArrayList authContexts) {
        MessageSecurityDescriptor msd;
        int i;
        this.defaultContext_ = null;
        this.superMSD_ = null;
        this.superIndex_ = -1;
        this.messageSecurityDescriptors_ = descriptors;
        this.contexts_ = authContexts;
        this.contextsForOpcodes_ = null;
        this.contextsForOpNames_ = null;
        this.onePolicy_ = true;
        for (i = 0; i < descriptors.size(); ++i) {
            msd = (MessageSecurityDescriptor)descriptors.get(i);
            for (int j = 0; j < descriptors.size(); ++j) {
                if (j == i || BaseAuthConfig.policiesAreEqual(msd, (MessageSecurityDescriptor)descriptors.get(j))) continue;
                this.onePolicy_ = false;
            }
        }
        block2: for (i = 0; this.defaultContext_ == null && i < descriptors.size(); ++i) {
            boolean noProtection;
            msd = (MessageSecurityDescriptor)descriptors.get(i);
            AuthPolicy requestPolicy = BaseAuthConfig.getAuthPolicy(msd.getRequestProtectionDescriptor());
            AuthPolicy responsePolicy = BaseAuthConfig.getAuthPolicy(msd.getResponseProtectionDescriptor());
            boolean bl = noProtection = !requestPolicy.authRequired() && !responsePolicy.authRequired();
            if (i == 0 && this.onePolicy_ && noProtection) {
                this.defaultContext_ = this.explicitNull;
                break;
            }
            ArrayList mDs = msd.getMessageDescriptors();
            for (int j = 0; mDs != null && j < mDs.size(); ++j) {
                MessageDescriptor mD = (MessageDescriptor)mDs.get(j);
                MethodDescriptor methD = mD.getMethodDescriptor();
                if ((mD.getOperationName() != null || methD != null) && (methD == null || methD.getStyle() != 1)) continue;
                if (this.onePolicy_) {
                    this.defaultContext_ = this.contexts_.get(i);
                    if (this.defaultContext_ != null) continue block2;
                    this.defaultContext_ = this.explicitNull;
                    continue block2;
                }
                if (this.superIndex_ == -1) {
                    if (noProtection) {
                        this.defaultContext_ = this.explicitNull;
                        continue;
                    }
                    this.superIndex_ = i;
                    continue;
                }
                if (BaseAuthConfig.policiesAreEqual(msd, (MessageSecurityDescriptor)descriptors.get(this.superIndex_))) continue;
                this.defaultContext_ = this.explicitNull;
                this.superIndex_ = -1;
                continue block2;
            }
        }
        if (this.superIndex_ >= 0) {
            this.superMSD_ = (MessageSecurityDescriptor)descriptors.get(this.superIndex_);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("WSS: new BAC defaultContext_: " + this.defaultContext_ + " superMSD index: " + this.superIndex_ + " onePolicy_: " + this.onePolicy_);
        }
    }

    protected static AuthPolicy getAuthPolicy(ProtectionDescriptor pd) {
        int sourceAuthType = 0;
        boolean recipientAuth = false;
        boolean beforeContent = false;
        if (pd != null) {
            String recipient;
            String source = pd.getAttributeValue("AuthSource");
            if (source != null) {
                if (source.equals("sender")) {
                    sourceAuthType = 1;
                } else if (source.equals("content")) {
                    sourceAuthType = 2;
                }
            }
            if ((recipient = pd.getAttributeValue("AuthRecipient")) != null) {
                recipientAuth = true;
                if (recipient.equals("before-content")) {
                    beforeContent = true;
                } else if (recipient.equals("after-content")) {
                    beforeContent = false;
                }
            }
        }
        return new AuthPolicy(sourceAuthType, recipientAuth, beforeContent);
    }

    private static boolean isMatchingMSD(MethodDescriptor targetMD, MessageSecurityDescriptor mSD) {
        ArrayList messageDescriptors = mSD.getMessageDescriptors();
        if (messageDescriptors.size() == 0) {
            return true;
        }
        for (int i = 0; i < messageDescriptors.size(); ++i) {
            MessageDescriptor nextMD = (MessageDescriptor)messageDescriptors.get(i);
            MethodDescriptor mD = nextMD.getMethodDescriptor();
            String opName = nextMD.getOperationName();
            if (opName != null || mD != null && !mD.implies(targetMD)) continue;
            return true;
        }
        return false;
    }

    private static boolean policiesAreEqual(MessageSecurityDescriptor reference, MessageSecurityDescriptor other) {
        return BaseAuthConfig.getAuthPolicy(reference.getRequestProtectionDescriptor()).equals(BaseAuthConfig.getAuthPolicy(other.getRequestProtectionDescriptor())) && BaseAuthConfig.getAuthPolicy(reference.getResponseProtectionDescriptor()).equals(BaseAuthConfig.getAuthPolicy(other.getResponseProtectionDescriptor()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getContextForMethod(Method m) {
        Object rvalue = null;
        Object object = this.contextLock;
        synchronized (object) {
            if (this.defaultContext_ != null) {
                rvalue = this.defaultContext_;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("WSS: ForMethod returning default_context: " + rvalue);
                }
                return rvalue;
            }
        }
        if (m != null) {
            int match = -1;
            MethodDescriptor targetMD = new MethodDescriptor(m);
            for (int i = 0; i < this.messageSecurityDescriptors_.size(); ++i) {
                if (!BaseAuthConfig.isMatchingMSD(targetMD, (MessageSecurityDescriptor)this.messageSecurityDescriptors_.get(i))) continue;
                if (match < 0) {
                    match = i;
                    continue;
                }
                if (BaseAuthConfig.policiesAreEqual((MessageSecurityDescriptor)this.messageSecurityDescriptors_.get(match), (MessageSecurityDescriptor)this.messageSecurityDescriptors_.get(i))) continue;
                rvalue = this.explicitNull;
                match = -1;
                if (!logger.isLoggable(Level.FINE)) break;
                logger.fine("WSS: ForMethod detected conflicting policies: " + match + "." + i);
                break;
            }
            if (match >= 0) {
                rvalue = this.contexts_.get(match);
                if (rvalue == null) {
                    rvalue = this.explicitNull;
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("WSS: ForMethod returning matched context: " + rvalue);
                }
            }
        } else if (this.onePolicy_ && this.contexts_.size() > 0) {
            rvalue = this.contexts_.get(0);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("WSS: ForMethod resorting to first context: " + rvalue);
            }
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("WSS: Unable to select policy for SOAP Message");
            }
            throw new RuntimeException("Unable to select policy for Message");
        }
        return rvalue;
    }

    private boolean methodIsCovered(Method m) {
        boolean rvalue = true;
        if (this.messageSecurityDescriptors_ != null) {
            MethodDescriptor targetMD = new MethodDescriptor(m);
            for (int i = 0; i < this.messageSecurityDescriptors_.size(); ++i) {
                if (i == 0) {
                    rvalue = false;
                }
                if (!BaseAuthConfig.isMatchingMSD(targetMD, (MessageSecurityDescriptor)this.messageSecurityDescriptors_.get(i))) continue;
                rvalue = true;
                break;
            }
        }
        return rvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getExplicitContextForOpCode(StreamingHandler handler, int opcode) throws ClassNotFoundException, NoSuchMethodException {
        Object rvalue = null;
        Object object = this.contextLock;
        synchronized (object) {
            if (this.contextsForOpcodes_ == null && this.defaultContext_ == null) {
                boolean onePolicyForAll = this.onePolicy_;
                Method m = null;
                for (int i = 0; i == 0 || m != null; ++i) {
                    if (i == 0) {
                        this.contextsForOpcodes_ = new ArrayList();
                    }
                    if (handler != null) {
                        m = handler.getMethodForOpcode(i);
                    }
                    if (m == null) continue;
                    Object o = this.getContextForMethod(m);
                    this.contextsForOpcodes_.add(o);
                    if (o != null) continue;
                    onePolicyForAll = false;
                }
                if (onePolicyForAll && this.contextsForOpcodes_.size() > 0) {
                    this.defaultContext_ = this.contextsForOpcodes_.get(0);
                }
            }
            if (this.defaultContext_ != null) {
                rvalue = this.defaultContext_;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("WSS: ForOpCode returning default_context: " + rvalue);
                }
            }
        }
        if (rvalue == null) {
            if (opcode >= 0 && opcode < this.contextsForOpcodes_.size()) {
                rvalue = this.contextsForOpcodes_.get(opcode);
            } else if (opcode < 0) {
                rvalue = this.getContextForMethod(null);
            }
        }
        return rvalue;
    }

    protected Object getContextForOpCode(StreamingHandler handler, int opcode) throws ClassNotFoundException, NoSuchMethodException {
        Object rvalue = this.getExplicitContextForOpCode(handler, opcode);
        if (rvalue != null && rvalue instanceof ExplicitNull) {
            rvalue = null;
        }
        return rvalue;
    }

    private static String getOpName(SOAPMessage message) {
        Name name;
        String[] actions;
        String rvalue = null;
        MimeHeaders headers = message.getMimeHeaders();
        if (headers != null && (actions = headers.getHeader("SOAPAction")) != null && actions.length > 0 && (rvalue = actions[0]) != null && rvalue.equals("\"\"")) {
            rvalue = null;
        }
        if (rvalue == null && (name = BaseAuthConfig.getName(message)) != null) {
            rvalue = name.getLocalName();
        }
        return rvalue;
    }

    private static String getOpName(SOAPMessageContext soapMC) {
        String rvalue = null;
        QName qName = (QName)soapMC.get((Object)"javax.xml.ws.wsdl.operation");
        rvalue = qName != null ? qName.getLocalPart() : BaseAuthConfig.getOpName(WsUtil.getMessageWithName(soapMC));
        return rvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getContextForOpName(String operation) {
        Object object = this.contextLock;
        synchronized (object) {
            if (this.contextsForOpNames_ == null) {
                this.contextsForOpNames_ = new HashMap();
                for (int i = 0; this.messageSecurityDescriptors_ != null && i < this.messageSecurityDescriptors_.size(); ++i) {
                    MessageSecurityDescriptor mSD = (MessageSecurityDescriptor)this.messageSecurityDescriptors_.get(i);
                    ArrayList mDs = mSD.getMessageDescriptors();
                    for (int j = 0; mDs != null && j < mDs.size(); ++j) {
                        MessageDescriptor mD = (MessageDescriptor)mDs.get(j);
                        String opName = mD.getOperationName();
                        if (opName == null) continue;
                        if (this.contextsForOpNames_.containsKey(opName)) {
                            MessageSecurityDescriptor other;
                            Integer k = (Integer)this.contextsForOpNames_.get(opName);
                            if (k == null || BaseAuthConfig.policiesAreEqual(mSD, other = (MessageSecurityDescriptor)this.messageSecurityDescriptors_.get(k))) continue;
                            this.contextsForOpNames_.put(opName, null);
                            continue;
                        }
                        if (this.superMSD_ != null && !BaseAuthConfig.policiesAreEqual(mSD, this.superMSD_)) {
                            this.contextsForOpNames_.put(opName, null);
                            continue;
                        }
                        this.contextsForOpNames_.put(opName, new Integer(i));
                    }
                }
            }
        }
        ExplicitNull rvalue = null;
        if (operation != null) {
            if (this.contextsForOpNames_.containsKey(operation)) {
                Integer k = (Integer)this.contextsForOpNames_.get(operation);
                if (k != null) {
                    rvalue = this.contexts_.get(k);
                }
            } else if (this.superIndex_ >= 0) {
                rvalue = this.contexts_.get(this.superIndex_);
            }
            if (rvalue == null) {
                rvalue = this.explicitNull;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("WSS: ForOpName=" + operation + " context: " + rvalue);
            }
        }
        return rvalue;
    }

    private Object getContextForMessage(SOAPMessage message) {
        String opName = BaseAuthConfig.getOpName(message);
        Object rvalue = this.getContextForOpName(opName);
        if (rvalue == null) {
            rvalue = this.getContextForMethod(null);
        }
        return rvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getContext(StreamingHandler handler, SOAPMessage message) {
        Object rvalue = null;
        Object object = this.contextLock;
        synchronized (object) {
            if (this.defaultContext_ != null) {
                rvalue = this.defaultContext_;
            }
        }
        if (rvalue == null) {
            if (handler == null) {
                rvalue = this.getContextForMessage(message);
            } else {
                int opCode = handler.getOpcodeForRequestMessage(message);
                if (opCode == -1) {
                    rvalue = this.getContextForMethod(null);
                } else {
                    try {
                        rvalue = this.getExplicitContextForOpCode(handler, opCode);
                        if (rvalue == null) {
                            rvalue = this.getContextForMessage(message);
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        throw new RuntimeException(cnfe);
                    }
                    catch (NoSuchMethodException nsme) {
                        throw new RuntimeException(nsme);
                    }
                }
            }
        }
        if (rvalue != null && rvalue instanceof ExplicitNull) {
            rvalue = null;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("WSS: getContext returning: " + rvalue);
        }
        return rvalue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getContext(SOAPMessageContext soapMC) {
        Object rvalue = null;
        Object object = this.contextLock;
        synchronized (object) {
            if (this.defaultContext_ != null) {
                rvalue = this.defaultContext_;
            }
        }
        if (rvalue == null) {
            Method m = BaseAuthConfig.getMethod(soapMC);
            String opName = null;
            if (m != null) {
                rvalue = this.getContextForMethod(m);
            }
            if (rvalue == null && (opName = BaseAuthConfig.getOpName(soapMC)) != null) {
                rvalue = this.getContextForOpName(opName);
            }
            if (rvalue == null && (m == null || opName == null)) {
                rvalue = this.getContextForMethod(null);
            }
        }
        if (rvalue != null && rvalue instanceof ExplicitNull) {
            rvalue = null;
        }
        return rvalue;
    }

    private static Name getName(SOAPMessage message) {
        Name rvalue;
        block4: {
            rvalue = null;
            SOAPPart soap = message.getSOAPPart();
            if (soap != null) {
                try {
                    SOAPBody body;
                    SOAPEnvelope envelope = soap.getEnvelope();
                    if (envelope == null || (body = envelope.getBody()) == null) break block4;
                    Iterator it = body.getChildElements();
                    while (it.hasNext()) {
                        Object o = it.next();
                        if (!(o instanceof SOAPElement)) continue;
                        rvalue = ((SOAPElement)o).getElementName();
                        break;
                    }
                }
                catch (SOAPException se) {
                    if (!logger.isLoggable(Level.FINE)) break block4;
                    logger.log(Level.FINE, "WSS: Unable to get SOAP envelope", se);
                }
            }
        }
        return rvalue;
    }

    public static Method getMethod(SOAPMessageContext soapMC) {
        Method m = null;
        if (soapMC instanceof SHDSOAPMessageContext && (m = ((SHDSOAPMessageContext)soapMC).getMethod()) == null) {
            Name name;
            QName qName = (QName)soapMC.get((Object)"javax.xml.ws.wsdl.operation");
            if (qName == null && (name = BaseAuthConfig.getName(WsUtil.getMessageWithName(soapMC))) != null) {
                String prefix = name.getPrefix();
                qName = new QName(name.getURI(), name.getLocalName(), prefix != null ? prefix : "");
            }
            if (qName != null) {
                Invoker invoker = ((SHDSOAPMessageContext)soapMC).getInvoker();
                m = invoker.getMethod(qName);
            }
        }
        return m;
    }

    public QName[] getMechanisms() {
        return mechanisms;
    }

    class ExplicitNull {
        ExplicitNull() {
        }

        public boolean equals(Object other) {
            return other != null && other instanceof ExplicitNull;
        }

        public String toString() {
            return "ExplicitNull";
        }
    }
}

