/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.common.properties;

import com.sun.enterprise.tools.common.properties.PropertyElements;
import com.sun.enterprise.tools.common.properties.PropertyElementsTableModel;
import com.sun.enterprise.tools.common.util.diagnostics.Reporter;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditorSupport;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class PropertyElementsEditor
extends PropertyEditorSupport {
    private PropertyElements propElements;
    private static ResourceBundle bundle = ResourceBundle.getBundle("com.sun.enterprise.tools.common.properties.Bundle");
    private JTable table = null;
    TableCellEditor acell = new DefaultCellEditor(new JTextField());

    public String getAsText() {
        return null;
    }

    public boolean isPaintable() {
        return true;
    }

    public Component getCustomEditor() {
        this.table = new JTable(new PropertyElementsTableModel(this.propElements));
        this.table.setDefaultEditor(Object.class, this.acell);
        if (this.table.getModel().getRowCount() > 0) {
            this.table.editCellAt(0, 0);
        }
        JScrollPane sp = new JScrollPane(this.table);
        return sp;
    }

    public Object getValue() {
        return new PropertyElements(this.propElements);
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        int num = this.propElements.getLength();
        String s = "" + num + " ";
        String format = null;
        format = num == 1 ? bundle.getString("PROP_TEXT_ONE_PROPERTY") : bundle.getString("PROP_TEXT_N_PROPERTIES");
        s = MessageFormat.format(format, s);
        FontMetrics fm = gfx.getFontMetrics();
        gfx.drawString(s, 4, (box.height - fm.getHeight()) / 2 + 1 + fm.getMaxAscent());
    }

    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException(bundle.getString("ERR_SET_AS_TEXT_ILLEGAL"));
    }

    public List isValueValid(PropertyElements value) {
        String propName = null;
        String propValue = null;
        Vector<String> errors = new Vector<String>();
        HashSet<String> propNames = new HashSet<String>();
        try {
            for (int row = 0; row < value.getLength(); ++row) {
                String format;
                propName = (String)value.getAttributeDetail(row, 0);
                if (propName == null || propName.trim().length() == 0 || (propValue = (String)value.getAttributeDetail(row, 1)) == null || propValue.trim().length() == 0) {
                    format = bundle.getString("ERR_InvalidEntry");
                    errors.add(MessageFormat.format(format, new Integer(row + 1)));
                    continue;
                }
                if (propNames.contains(propName)) {
                    format = bundle.getString("ERR_DuplicateProperty");
                    errors.add(MessageFormat.format(format, propName, new Integer(row + 1)));
                    continue;
                }
                propNames.add(propName);
            }
        }
        catch (Exception ex) {
            errors.add(ex.getLocalizedMessage());
        }
        Reporter.info(new Integer(errors.size()));
        return errors;
    }

    public void setValue(Object value) {
        List errors = null;
        if (this.table != null) {
            Reporter.info("table");
            TableCellEditor cell = this.table.getCellEditor();
            if (null != cell) {
                Reporter.info("There is a cell: " + cell);
                Reporter.info("  this is the value of the cell: " + cell.getCellEditorValue());
                int r = this.table.getEditingRow();
                int c = this.table.getEditingColumn();
                if (r > -1 && c > -1) {
                    this.table.setValueAt(cell.getCellEditorValue(), r, c);
                }
            }
            if (value instanceof PropertyElements && !(errors = this.isValueValid((PropertyElements)value)).isEmpty()) {
                StringBuffer str = new StringBuffer(bundle.getString("ERR_Properties"));
                Iterator iter = errors.iterator();
                while (iter.hasNext()) {
                    str.append("\n\t -" + (String)iter.next());
                }
                JOptionPane.showMessageDialog(null, str.toString(), bundle.getString("Error"), 0);
            }
        }
        if (value instanceof PropertyElements && (errors == null || errors.isEmpty())) {
            Reporter.info("");
            this.propElements = (PropertyElements)value;
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

