/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.ServletFilterDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.deployment.deploy.shared.Archive;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

public class IconImageTypeTest
extends VerifierTest
implements VerifierCheck {
    private Collection<String> smallIconUris = new ArrayList<String>();
    private Collection<String> largeIconUris = new ArrayList<String>();
    private Descriptor descriptor;
    private Result result;
    ComponentNameConstructor compName;
    private static final String[] allowableImageTypesForJavaEEOlderThan5 = new String[]{".gif", ".jpg"};
    private static final String[] allowableImageTypesForJavaEE5 = new String[]{".gif", ".jpg", ".png"};

    public Result check(Descriptor descriptor) {
        this.descriptor = descriptor;
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        this.result = this.getInitializedResult();
        this.result.setStatus(0);
        this.addGoodDetails(this.result, this.compName);
        this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "No errors were detected."));
        this.collectIconURIs();
        this.testIconURIType();
        this.testIconURIExistence();
        return this.result;
    }

    private void testIconURIType() {
        String JavaEESchemaVersion = this.getVerifierContext().getJavaEEVersion();
        String[] allowableImageTypes = JavaEESchemaVersion.compareTo("5") < 0 ? allowableImageTypesForJavaEEOlderThan5 : allowableImageTypesForJavaEE5;
        ArrayList<String> allURIs = new ArrayList<String>(this.smallIconUris);
        allURIs.addAll(this.largeIconUris);
        for (String uri : allURIs) {
            boolean passed = false;
            for (String allowableType : allowableImageTypes) {
                if (!uri.endsWith(allowableType)) continue;
                passed = true;
                break;
            }
            if (passed) continue;
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedImageType", "Error: Unsupported image type used in icon image URI [ {0} ].", new Object[]{uri}));
        }
    }

    private void testIconURIExistence() {
        ArrayList<String> allURIs = new ArrayList<String>(this.smallIconUris);
        allURIs.addAll(this.largeIconUris);
        for (String uri : allURIs) {
            Archive moduleArchive = this.getVerifierContext().getModuleArchive();
            boolean passed = false;
            Enumeration entries = moduleArchive.entries();
            while (entries.hasMoreElements()) {
                if (!uri.equals(entries.nextElement())) continue;
                passed = true;
                break;
            }
            if (passed) continue;
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedExistence", "Error: icon image URI [ {0} ] is not packaged inside [ {1} ].", new Object[]{uri, this.getVerifierContext().getModuleArchive().getURI()}));
        }
    }

    private void collectIconURIs() {
        if (this.descriptor instanceof Application) {
            this.collectIconURIs((Application)this.descriptor);
        } else if (this.descriptor instanceof ApplicationClientDescriptor) {
            this.collectIconURIs((ApplicationClientDescriptor)this.descriptor);
        } else if (this.descriptor instanceof EjbDescriptor) {
            this.collectIconURIs((EjbDescriptor)this.descriptor);
        } else if (this.descriptor instanceof ConnectorDescriptor) {
            this.collectIconURIs((ConnectorDescriptor)this.descriptor);
        } else if (this.descriptor instanceof WebBundleDescriptor) {
            this.collectIconURIs((WebBundleDescriptor)this.descriptor);
        } else if (this.descriptor instanceof WebServiceEndpoint) {
            this.collectIconURIs((WebServiceEndpoint)this.descriptor);
        } else if (this.descriptor instanceof ServiceReferenceDescriptor) {
            this.collectIconURIs((ServiceReferenceDescriptor)this.descriptor);
        } else {
            throw new RuntimeException("Unexpected descriptor type.");
        }
    }

    private void collectIconURIs(Descriptor desc) {
        String uri = desc.getSmallIconUri();
        if (uri != null && uri.length() > 0) {
            this.smallIconUris.add(uri);
        }
        if ((uri = desc.getLargeIconUri()) != null && uri.length() > 0) {
            this.largeIconUris.add(uri);
        }
    }

    private void collectIconURIs(WebBundleDescriptor webBundleDescriptor) {
        this.collectIconURIs((Descriptor)webBundleDescriptor);
        for (Object o : webBundleDescriptor.getWebComponentDescriptorsSet()) {
            this.collectIconURIs((Descriptor)WebComponentDescriptor.class.cast(o));
        }
        for (Object o : webBundleDescriptor.getServletFilterDescriptors()) {
            this.collectIconURIs((Descriptor)ServletFilterDescriptor.class.cast(o));
        }
    }

    private void collectIconURIs(WebServiceEndpoint webServiceEndpoint) {
        this.collectIconURIs(webServiceEndpoint.getWebService().getWebServicesDescriptor());
        this.collectIconURIs(webServiceEndpoint.getWebService());
        this.collectIconURIs((Descriptor)webServiceEndpoint);
        for (Object o : webServiceEndpoint.getHandlers()) {
            this.collectIconURIs((Descriptor)WebServiceHandler.class.cast(o));
        }
    }

    private void collectIconURIs(EjbDescriptor desc) {
        this.collectIconURIs(desc.getEjbBundleDescriptor());
        this.collectIconURIs(this.descriptor);
    }
}

