/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.appclient.elements;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientCheck;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientTest;
import java.util.Iterator;
import java.util.Set;

public class AppClientEjbReferencesElement
extends AppClientTest
implements AppClientCheck {
    public Result check(ApplicationClientDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof ApplicationClientDescriptor) {
            Set references = descriptor.getEjbReferenceDescriptors();
            Iterator iterator = references.iterator();
            if (iterator.hasNext()) {
                boolean oneFailed = false;
                while (iterator.hasNext()) {
                    EjbReferenceDescriptor ejbReference = (EjbReferenceDescriptor)iterator.next();
                    String homeClassName = ejbReference.getHomeClassName();
                    if (homeClassName == null) {
                        oneFailed = true;
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "Error: {0} class cannot be null.", new Object[]{"home"}));
                    } else {
                        try {
                            Class.forName(homeClassName, false, this.getVerifierContext().getClassLoader());
                        }
                        catch (ClassNotFoundException e) {
                            Verifier.debug(e);
                            oneFailed = true;
                            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] class [ {1} ] cannot be found within this jar [ {2} ].", new Object[]{ejbReference.getName(), homeClassName, descriptor.getModuleDescriptor().getArchiveUri()}));
                        }
                        result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "The referenced bean's home interface [ {0} ] exists and is loadable within [ {1} ].", new Object[]{ejbReference.getHomeClassName(), descriptor.getModuleDescriptor().getArchiveUri()}));
                    }
                    String remoteClassName = ejbReference.getEjbInterface();
                    if (remoteClassName == null) {
                        oneFailed = true;
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "Error: {0} class cannot be null.", new Object[]{"remote"}));
                        continue;
                    }
                    try {
                        Class.forName(remoteClassName, false, this.getVerifierContext().getClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        Verifier.debug(e);
                        oneFailed = true;
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] class [ {1} ] cannot be found within this jar [ {2} ].", new Object[]{ejbReference.getName(), remoteClassName, descriptor.getModuleDescriptor().getArchiveUri()}));
                    }
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed3", "The referenced bean's remote interface [ {0} ] exists and is loadable within [ {1} ].", new Object[]{ejbReference.getEjbInterface(), descriptor.getModuleDescriptor().getArchiveUri()}));
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else {
                    result.setStatus(0);
                }
            } else {
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "There are no ejb references to other beans within this application client [ {0} ]", new Object[]{descriptor.getName()}));
            }
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] not called with a application client.", new Object[]{this.getClass()}));
        return result;
    }
}

