/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.messagebean;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.messagebean.MessageBeanTest;
import java.util.Collection;

public class HasValidMethodDescriptor
extends MessageBeanTest {
    public Result check(EjbMessageBeanDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor.getTransactionType().equals("Container")) {
            Collection methods = descriptor.getTransactionMethodDescriptors();
            if (methods.size() == 0) {
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "Message-driven bean [ {0} ] does not define any method", new Object[]{descriptor.getName()}));
                return result;
            }
            for (MethodDescriptor method : methods) {
                if (descriptor.isTimedObject() && method.getName().equals("ejbTimeout")) continue;
                ContainerTransaction txAttr = descriptor.getContainerTransactionFor(method);
                if (txAttr == null) {
                    if (this.getVerifierContext().getJavaEEVersion().compareTo("5") >= 0) continue;
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed4", "Error : Message-driven bean [ {0} ] method definition [ {1} ] does not have a valid container transaction descriptor.", new Object[]{descriptor.getName(), method.getName()}));
                    continue;
                }
                String ta = txAttr.getTransactionAttribute();
                if (ContainerTransaction.REQUIRED.equals(ta) || ContainerTransaction.NOT_SUPPORTED.equals(ta)) {
                    this.addGoodDetails(result, compName);
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Message-driven bean [ {0} ] method definition [ {1} ] in assembly-descriptor is correct", new Object[]{descriptor.getName(), method.getName()}));
                    continue;
                }
                this.addErrorDetails(result, compName);
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed3", "Error : Message-driven bean [ {0} ] method definition [ {1} ] transaction attribute must be Required or NotSupported", new Object[]{descriptor.getName(), method.getName()}));
            }
            return result;
        }
        this.addNaDetails(result, compName);
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Message-driven bean [ {0} ] does not use container-managed transaction", new Object[]{descriptor.getName()}));
        return result;
    }
}

