/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;
import java.util.Collection;

public class SEIEJBTxAttrChk
extends WSTest
implements WSCheck {
    public Result check(WebServiceEndpoint wsdescriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean pass = true;
        if (wsdescriptor.implementedByEjbComponent()) {
            EjbDescriptor descriptor = wsdescriptor.getEjbComponentImpl();
            try {
                ContainerTransaction ctx = descriptor.getContainerTransaction();
                if (ctx != null && ContainerTransaction.MANDATORY.equals(ctx.getTransactionAttribute())) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "[{0}] of this WebService [{1}] have Mandatory Transaction Attribute.", new Object[]{"All the methods", compName.toString()}));
                    return result;
                }
                Collection txMethDescs = descriptor.getTransactionMethodDescriptors();
                String s = descriptor.getWebServiceEndpointInterfaceName();
                if (s == null) {
                    result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{"Service Endpoint Interface Class Name Null"}));
                    pass = false;
                }
                ClassLoader cl = this.getVerifierContext().getClassLoader();
                Class<?> sei = null;
                try {
                    sei = Class.forName(s, false, cl);
                }
                catch (ClassNotFoundException e) {
                    result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{"Could not Load Service Endpoint Interface Class"}));
                    pass = false;
                }
                for (MethodDescriptor methdesc : txMethDescs) {
                    if (!this.isSEIMethod(methdesc, descriptor, sei, cl) || (ctx = descriptor.getContainerTransactionFor(methdesc)) == null || !ContainerTransaction.MANDATORY.equals(ctx.getTransactionAttribute())) continue;
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "[{0}] of this WebService [{1}] have Mandatory Transaction Attribute.", new Object[]{methdesc.getName(), compName.toString()}));
                    pass = false;
                }
            }
            catch (Exception e) {
                result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{e.getMessage()}));
                pass = false;
            }
            if (pass) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "None of the methods of this WebService [{0}] have Mandatory Transaction Attribute.", new Object[]{compName.toString()}));
            }
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notapp", "Not applicable since this is not an EJB Service Endpoint."));
        return result;
    }
}

