/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.Switch;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.enterprise.web.ShutdownCleanupCapable;
import com.sun.enterprise.web.WebContainer;
import com.sun.enterprise.web.WebModule;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.core.ContainerBase;

public class ConnectionShutdownUtil {
    protected EmbeddedWebContainer _embedded = null;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private WebContainer webContainer = null;

    public ConnectionShutdownUtil() {
    }

    public ConnectionShutdownUtil(EmbeddedWebContainer embedded) {
        this._embedded = embedded;
    }

    public String getApplicationId(Context ctx) {
        WebModule wm = (WebModule)ctx;
        return wm.getID();
    }

    public String getApplicationName(Context ctx) {
        return ctx.getName();
    }

    public ArrayList runGetShutdownCapables() {
        _logger.finest("IN ConnectionShutdownUtil:runGetShutdownCapables");
        ArrayList<Object> shutdownCapablesList = new ArrayList<Object>();
        try {
            Engine[] engines = this._embedded.getEngines();
            for (int h = 0; h < engines.length; ++h) {
                Engine engine = engines[h];
                Container[] hosts = engine.findChildren();
                for (int i = 0; i < hosts.length; ++i) {
                    Container nextHost = hosts[i];
                    Container[] webModules = nextHost.findChildren();
                    for (int j = 0; j < webModules.length; ++j) {
                        Container nextWebModule = webModules[j];
                        Context ctx = (Context)nextWebModule;
                        String webAppName = this.getApplicationId(ctx);
                        Manager nextManager = nextWebModule.getManager();
                        if (!(nextManager instanceof ShutdownCleanupCapable)) continue;
                        _logger.finest("found a shutdown capable manager:" + nextManager.getClass().getName());
                        shutdownCapablesList.add(nextManager);
                    }
                    _logger.finest("1) shutdownCapablesList Size = " + shutdownCapablesList.size());
                    Valve[] valves = ((ContainerBase)nextHost).getValves();
                    for (int k = 0; k < valves.length; ++k) {
                        Valve nextValve = valves[k];
                        _logger.finest("VALVE = " + nextValve.getClass().getName());
                        if (!(nextValve instanceof ShutdownCleanupCapable)) continue;
                        _logger.finest("found a shutdown capable valve");
                        shutdownCapablesList.add(nextValve);
                    }
                }
            }
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "Exception thrown", th);
        }
        _logger.finest("1) shutdownCapablesList Size = " + shutdownCapablesList.size());
        return shutdownCapablesList;
    }

    public ArrayList runGetShutdownCapablesForAppName(String appName) {
        _logger.finest("IN ConnectionShutdownUtil:runGetShutdownCapablesForAppName");
        ArrayList<Manager> shutdownCapablesList = new ArrayList<Manager>();
        try {
            Engine[] engines = this._embedded.getEngines();
            for (int h = 0; h < engines.length; ++h) {
                Engine engine = engines[h];
                Container[] hosts = engine.findChildren();
                for (int i = 0; i < hosts.length; ++i) {
                    Container nextHost = hosts[i];
                    Container[] webModules = nextHost.findChildren();
                    for (int j = 0; j < webModules.length; ++j) {
                        Container nextWebModule = webModules[j];
                        Context ctx = (Context)nextWebModule;
                        String webAppName = this.getApplicationName(ctx);
                        Manager nextManager = nextWebModule.getManager();
                        if (!(nextManager instanceof ShutdownCleanupCapable) || !webAppName.equals(appName)) continue;
                        _logger.finest("found a shutdown capable manager:" + nextManager.getClass().getName());
                        shutdownCapablesList.add(nextManager);
                    }
                }
            }
        }
        catch (Throwable th) {
            _logger.log(Level.SEVERE, "Exception thrown", th);
        }
        _logger.finest("1) shutdownCapablesList Size = " + shutdownCapablesList.size());
        return shutdownCapablesList;
    }

    public void runShutdownCleanupFromShutdownCleanupCapableList(ArrayList shutdownCapablesList) {
        for (int i = 0; i < shutdownCapablesList.size(); ++i) {
            ShutdownCleanupCapable nextOne = (ShutdownCleanupCapable)shutdownCapablesList.get(i);
            nextOne.doShutdownCleanup();
        }
    }

    public void runCloseAllConnections() {
        ArrayList list = this.runGetShutdownCapables();
        this.runShutdownCleanupFromShutdownCleanupCapableList(list);
    }

    public void runCloseCachedConnectionForApp(String appName) {
        ArrayList list = this.runGetShutdownCapablesForAppName(appName);
        this.runCloseCachedConnectionFromShutdownCleanupCapableList(list, appName);
    }

    public void runCloseCachedConnectionFromShutdownCleanupCapableList(ArrayList shutdownCapablesList, String appName) {
        for (int i = 0; i < shutdownCapablesList.size(); ++i) {
            ShutdownCleanupCapable nextOne = (ShutdownCleanupCapable)shutdownCapablesList.get(i);
            nextOne.doCloseCachedConnection();
        }
    }

    public void clearoutJDBCPool() {
        String hadbPoolname = this.getHadbJdbcConnectionPoolNameFromConfig();
        if (hadbPoolname == null) {
            return;
        }
        ResourceSpec resourceSpec = new ResourceSpec(hadbPoolname, 1);
        resourceSpec.setConnectionPoolName(hadbPoolname);
        if (resourceSpec == null) {
            return;
        }
        Switch.getSwitch().getPoolManager().emptyResourcePool(resourceSpec);
        resourceSpec = new ResourceSpec(hadbPoolname, 0);
        resourceSpec.setConnectionPoolName(hadbPoolname);
        if (resourceSpec == null) {
            return;
        }
        Switch.getSwitch().getPoolManager().emptyResourcePool(resourceSpec);
    }

    private String getHadbJdbcConnectionPoolNameFromConfig() {
        ServerConfigLookup configLookup = new ServerConfigLookup();
        return configLookup.getHadbJdbcConnectionPoolNameFromConfig();
    }
}

