/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.deployment.runtime.web.LocaleCharsetInfo;
import com.sun.enterprise.deployment.runtime.web.LocaleCharsetMap;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.web.ServletFilterMapping;
import com.sun.enterprise.web.AdHocContextValve;
import com.sun.enterprise.web.AdHocServletInfo;
import com.sun.enterprise.web.PwcWebModule;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebContainer;
import com.sun.logging.LogDomains;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardPipeline;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.FilterMap;

public class WebModule
extends PwcWebModule {
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.container.web");
    private SunWebApp iasBean = null;
    private LocaleCharsetMap[] _lcMap = null;
    private boolean hasBeenXmlConfigured = false;
    private WebContainer webContainer;
    private HashMap<String, AdHocServletInfo> adHocPaths;
    private boolean hasAdHocPaths;
    private HashMap<String, AdHocServletInfo> adHocSubtrees;
    private boolean hasAdHocSubtrees;
    private StandardPipeline adHocPipeline;
    private String fileEncoding;
    protected Object[] cachedFinds;

    public WebModule(WebContainer webContainer) {
        this.webContainer = webContainer;
        this.adHocPaths = new HashMap();
        this.adHocSubtrees = new HashMap();
        this.adHocPipeline = new StandardPipeline(this);
        this.adHocPipeline.setBasic(new AdHocContextValve(this));
    }

    public void setIasWebAppConfigBean(SunWebApp iasBean) {
        this.iasBean = iasBean;
    }

    public SunWebApp getIasWebAppConfigBean() {
        return this.iasBean;
    }

    public void setI18nInfo() {
        LocaleCharsetInfo lcinfo;
        if (this.iasBean == null) {
            return;
        }
        if (this.iasBean.isParameterEncoding()) {
            this.formHintField = this.iasBean.getAttributeValue("ParameterEncoding", "FormHintField");
            this.defaultCharset = this.iasBean.getAttributeValue("ParameterEncoding", "DefaultCharset");
        }
        if ((lcinfo = this.iasBean.getLocaleCharsetInfo()) != null) {
            if (lcinfo.getAttributeValue("DefaultLocale") != null) {
                logger.warning("webmodule.default_locale_deprecated");
            }
            if (lcinfo.isParameterEncoding() && !this.iasBean.isParameterEncoding()) {
                this.formHintField = lcinfo.getAttributeValue("ParameterEncoding", "FormHintField");
                this.defaultCharset = lcinfo.getAttributeValue("ParameterEncoding", "DefaultCharset");
            }
            this._lcMap = lcinfo.getLocaleCharsetMap();
        }
    }

    public LocaleCharsetMap[] getLocaleCharsetMap() {
        return this._lcMap;
    }

    public boolean hasLocaleToCharsetMapping() {
        LocaleCharsetMap[] locCharsetMap = this.getLocaleCharsetMap();
        return locCharsetMap != null && locCharsetMap.length > 0;
    }

    public String mapLocalesToCharset(Enumeration locales) {
        String encoding = null;
        LocaleCharsetMap[] locCharsetMap = this.getLocaleCharsetMap();
        if (locCharsetMap != null && locCharsetMap.length > 0) {
            boolean matchFound = false;
            while (locales.hasMoreElements() && !matchFound) {
                Locale reqLoc = (Locale)locales.nextElement();
                for (int i = 0; i < locCharsetMap.length && !matchFound; ++i) {
                    String language = locCharsetMap[i].getAttributeValue("Locale");
                    if (language == null || language.equals("")) continue;
                    String country = null;
                    int index = language.indexOf(95);
                    if (index != -1) {
                        country = language.substring(index + 1);
                        language = language.substring(0, index);
                    }
                    Locale mapLoc = null;
                    mapLoc = country != null ? new Locale(language, country) : new Locale(language);
                    if (!mapLoc.equals(reqLoc)) continue;
                    encoding = locCharsetMap[i].getAttributeValue("Charset");
                    matchFound = true;
                }
            }
        }
        return encoding;
    }

    public void setXmlConfigured(boolean hasBeenXmlConfigured) {
        this.hasBeenXmlConfigured = hasBeenXmlConfigured;
    }

    public boolean hasBeenXmlConfigured() {
        return this.hasBeenXmlConfigured;
    }

    public void setCachedFindOperation(Object[] cachedFinds) {
        this.cachedFinds = cachedFinds;
    }

    public Object[] getCachedFindOperation() {
        return this.cachedFinds;
    }

    public synchronized void start() throws LifecycleException {
        super.start();
        this.webContainer.enableMonitoring(this, ((VirtualServer)this.getParent()).getID());
    }

    public boolean hasAdHocPaths() {
        return this.hasAdHocPaths;
    }

    public boolean hasAdHocSubtrees() {
        return this.hasAdHocSubtrees;
    }

    void addAdHocPathAndSubtree(String path, String subtree, AdHocServletInfo servletInfo) {
        if (path == null && subtree == null) {
            return;
        }
        Wrapper adHocWrapper = (Wrapper)this.findChild(servletInfo.getServletName());
        if (adHocWrapper == null) {
            adHocWrapper = this.createAdHocWrapper(servletInfo);
            this.addChild(adHocWrapper);
        }
        if (path != null) {
            this.adHocPaths.put(path, servletInfo);
            this.hasAdHocPaths = true;
        }
        if (subtree != null) {
            this.adHocSubtrees.put(subtree, servletInfo);
            this.hasAdHocSubtrees = true;
        }
    }

    void addAdHocPaths(HashMap newPaths) {
        if (newPaths == null || newPaths.isEmpty()) {
            return;
        }
        for (String adHocPath : newPaths.keySet()) {
            AdHocServletInfo servletInfo = (AdHocServletInfo)newPaths.get(adHocPath);
            Wrapper adHocWrapper = (Wrapper)this.findChild(servletInfo.getServletName());
            if (adHocWrapper == null) {
                adHocWrapper = this.createAdHocWrapper(servletInfo);
                this.addChild(adHocWrapper);
            }
            this.adHocPaths.put(adHocPath, servletInfo);
        }
        this.hasAdHocPaths = true;
    }

    void addAdHocSubtrees(HashMap newSubtrees) {
        if (newSubtrees == null || newSubtrees.isEmpty()) {
            return;
        }
        for (String adHocSubtree : newSubtrees.keySet()) {
            AdHocServletInfo servletInfo = (AdHocServletInfo)newSubtrees.get(adHocSubtree);
            Wrapper adHocWrapper = (Wrapper)this.findChild(servletInfo.getServletName());
            if (adHocWrapper == null) {
                adHocWrapper = this.createAdHocWrapper(servletInfo);
                this.addChild(adHocWrapper);
            }
            this.adHocSubtrees.put(adHocSubtree, servletInfo);
        }
        this.hasAdHocSubtrees = true;
    }

    HashMap getAdHocPaths() {
        return this.adHocPaths;
    }

    HashMap getAdHocSubtrees() {
        return this.adHocSubtrees;
    }

    public String getAdHocServletName(String path) {
        if (!this.hasAdHocPaths() && !this.hasAdHocSubtrees()) {
            return null;
        }
        AdHocServletInfo servletInfo = null;
        servletInfo = path == null ? this.adHocPaths.get("") : this.adHocPaths.get(path);
        if (servletInfo == null && path != null && this.hasAdHocSubtrees()) {
            for (String adHocSubtree : this.adHocSubtrees.keySet()) {
                if (!path.startsWith(adHocSubtree)) continue;
                servletInfo = this.adHocSubtrees.get(adHocSubtree);
                break;
            }
        }
        if (servletInfo != null) {
            return servletInfo.getServletName();
        }
        return null;
    }

    void removeAdHocPath(String path) {
        if (path == null) {
            return;
        }
        this.adHocPaths.remove(path);
        if (this.adHocPaths.isEmpty()) {
            this.hasAdHocPaths = false;
        }
    }

    void removeAdHocSubtree(String subtree) {
        if (subtree == null) {
            return;
        }
        this.adHocSubtrees.remove(subtree);
        if (this.adHocSubtrees.isEmpty()) {
            this.hasAdHocSubtrees = false;
        }
    }

    public void addAdHocValve(Valve valve) {
        this.adHocPipeline.addValve(valve);
    }

    public void removeAdHocValve(Valve valve) {
        this.adHocPipeline.removeValve(valve);
    }

    public Pipeline getAdHocPipeline() {
        return this.adHocPipeline;
    }

    public void setFileEncoding(String enc) {
        this.fileEncoding = enc;
    }

    public String getFileEncoding() {
        return this.fileEncoding;
    }

    void addFilterMap(ServletFilterMapping sfm) {
        List<String> urlPatterns;
        FilterMap filterMap = null;
        Iterator<String> i1 = null;
        Iterator i2 = null;
        List<String> servletNames = sfm.getServletNames();
        if (servletNames != null) {
            i1 = servletNames.iterator();
            while (i1.hasNext()) {
                filterMap = new FilterMap();
                filterMap.setFilterName(sfm.getName());
                filterMap.setServletName(i1.next());
                Set dispatchers = sfm.getDispatchers();
                if (dispatchers != null) {
                    i2 = dispatchers.iterator();
                    while (i2.hasNext()) {
                        filterMap.setDispatcher((String)i2.next());
                    }
                }
                this.addFilterMap(filterMap);
            }
        }
        if ((urlPatterns = sfm.getURLPatterns()) != null) {
            i1 = urlPatterns.iterator();
            while (i1.hasNext()) {
                filterMap = new FilterMap();
                filterMap.setFilterName(sfm.getName());
                filterMap.setURLPattern(i1.next());
                Set dispatchers = sfm.getDispatchers();
                if (dispatchers != null) {
                    i2 = dispatchers.iterator();
                    while (i2.hasNext()) {
                        filterMap.setDispatcher((String)i2.next());
                    }
                }
                this.addFilterMap(filterMap);
            }
        }
    }

    private Wrapper createAdHocWrapper(AdHocServletInfo servletInfo) {
        StandardWrapper adHocWrapper = new StandardWrapper();
        adHocWrapper.setServletClass(servletInfo.getServletClass().getName());
        adHocWrapper.setName(servletInfo.getServletName());
        Map<String, String> initParams = servletInfo.getServletInitParams();
        if (initParams != null && !initParams.isEmpty()) {
            for (String paramName : initParams.keySet()) {
                adHocWrapper.addInitParameter(paramName, initParams.get(paramName));
            }
        }
        return adHocWrapper;
    }
}

