/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.Constants;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.org.apache.commons.modeler.Registry;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.apache.coyote.http11.Http11Protocol;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.ServerSocketFactory;

public class GrizzlyHttpProtocol
extends Http11Protocol {
    private int socketBuffer = 9000;
    private SelectorThread selectorThread;
    private String noCompressionUserAgents = null;
    private String restrictedUserAgents = null;
    private String compressableMimeTypes = "text/html,text/xml,text/plain";
    private int compressionMinSize = 2048;

    protected void create() {
        this.selectorThread = new SelectorThread();
        this.setSoLinger(-1);
        this.setSoTimeout(Constants.DEFAULT_CONNECTION_TIMEOUT);
        this.setServerSoTimeout(0);
        this.setTcpNoDelay(true);
    }

    public void init() throws Exception {
        try {
            this.checkSocketFactory();
        }
        catch (Exception ex) {
            SelectorThread.logger().log(Level.SEVERE, "grizzlyHttpProtocol.socketfactory.initerror", ex);
            throw ex;
        }
        if (this.socketFactory != null) {
            Enumeration attE = this.attributes.keys();
            while (attE.hasMoreElements()) {
                String key = (String)attE.nextElement();
                Object v = this.attributes.get(key);
                this.socketFactory.setAttribute(key, v);
            }
        }
        try {
            this.selectorThread.setAdapter(this.adapter);
            this.selectorThread.initEndpoint();
        }
        catch (Exception ex) {
            SelectorThread.logger().log(Level.SEVERE, "grizzlyHttpProtocol.endpoint.initerror", ex);
            throw ex;
        }
    }

    public void start() throws Exception {
        try {
            if (this.oname != null) {
                try {
                    Registry.getRegistry().registerComponent(this.selectorThread, this.domain, "selectorThread", "type=Selector,name=http" + this.selectorThread.getPort());
                }
                catch (Exception ex) {
                    SelectorThread.logger().log(Level.SEVERE, "grizzlyHttpProtocol.selectorRegistrationFailed", ex);
                }
            } else {
                SelectorThread.logger().log(Level.INFO, "grizzlyHttpProtocol.selectorRegisterProtocol");
            }
            this.selectorThread.start();
        }
        catch (Exception ex) {
            SelectorThread.logger().log(Level.SEVERE, "grizzlyHttpProtocol.endpoint.starterror", ex);
            throw ex;
        }
        SelectorThread.logger().log(Level.INFO, "grizzlyHttpProtocol.start", String.valueOf(this.getPort()));
    }

    public void pause() throws Exception {
        try {
            this.selectorThread.pauseEndpoint();
        }
        catch (Exception ex) {
            SelectorThread.logger().log(Level.SEVERE, "grizzlyHttpProtocol.endpoint.pauseerror", ex);
            throw ex;
        }
        SelectorThread.logger().log(Level.INFO, "grizzlyHttpProtocol.pause", String.valueOf(this.getPort()));
    }

    public void resume() throws Exception {
        try {
            this.selectorThread.resumeEndpoint();
        }
        catch (Exception ex) {
            SelectorThread.logger().log(Level.SEVERE, "grizzlyHttpProtocol.endpoint.resumeerror", ex);
            throw ex;
        }
        SelectorThread.logger().log(Level.INFO, "grizzlyHttpProtocol.resume", String.valueOf(this.getPort()));
    }

    public void destroy() throws Exception {
        SelectorThread.logger().log(Level.INFO, "grizzlyHttpProtocol.stop", String.valueOf(this.getPort()));
        if (this.domain != null) {
            Registry.getRegistry().unregisterComponent(new ObjectName(this.domain, "type", "Selector"));
        }
        this.selectorThread.stopEndpoint();
    }

    public int getMaxThreads() {
        return this.selectorThread.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.selectorThread.setMaxThreads(maxThreads);
        this.setAttribute("maxThreads", "" + maxThreads);
    }

    public int getProcessorThreadsIncrement() {
        return this.selectorThread.threadsIncrement;
    }

    public void setProcessorThreadsIncrement(int threadsIncrement) {
        this.selectorThread.threadsIncrement = threadsIncrement;
        this.setAttribute("threadsIncrement", "" + threadsIncrement);
    }

    public void setProcessorWorkerThreadsTimeout(int timeout) {
        this.selectorThread.threadsTimeout = timeout;
        this.setAttribute("threadsTimeout", "" + timeout);
    }

    public int getProcessorWorkerThreadsTimeout() {
        return this.selectorThread.threadsTimeout;
    }

    public int getBacklog() {
        return this.selectorThread.ssBackLog;
    }

    public void setBacklog(int i) {
    }

    public int getPort() {
        return this.selectorThread.getPort();
    }

    public void setPort(int port) {
        this.selectorThread.setPort(port);
        this.setAttribute("port", "" + port);
    }

    public InetAddress getAddress() {
        return this.selectorThread.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.selectorThread.setAddress(ia);
        this.setAttribute("address", "" + ia);
    }

    public String getName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = "" + this.getAddress();
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr) + "-";
        }
        return "http-" + encodedAddr + this.selectorThread.getPort();
    }

    public boolean getTcpNoDelay() {
        return this.selectorThread.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean b) {
        this.selectorThread.setTcpNoDelay(b);
        this.setAttribute("tcpNoDelay", "" + b);
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setSocketBuffer(int valueI) {
        this.socketBuffer = valueI;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        super.setMaxHttpHeaderSize(maxHttpHeaderSize);
        this.selectorThread.setMaxHttpHeaderSize(maxHttpHeaderSize);
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String valueS) {
        this.restrictedUserAgents = valueS;
        this.setAttribute("restrictedUserAgents", valueS);
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String valueS) {
        this.noCompressionUserAgents = valueS;
        this.setAttribute("noCompressionUserAgents", valueS);
    }

    public String getCompressableMimeType() {
        return this.compressableMimeTypes;
    }

    public void setCompressableMimeType(String valueS) {
        this.compressableMimeTypes = valueS;
        this.setAttribute("compressableMimeTypes", valueS);
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int valueI) {
        this.compressionMinSize = valueI;
        this.setAttribute("compressionMinSize", "" + valueI);
    }

    public int getSoLinger() {
        return this.selectorThread.getSoLinger();
    }

    public void setSoLinger(int i) {
        this.selectorThread.setSoLinger(i);
        this.setAttribute("soLinger", "" + i);
    }

    public int getSoTimeout() {
        return this.selectorThread.getSoTimeout();
    }

    public void setSoTimeout(int i) {
        this.selectorThread.setSoTimeout(i);
        this.setAttribute("soTimeout", "" + i);
    }

    public int getServerSoTimeout() {
        return this.selectorThread.getServerSoTimeout();
    }

    public void setServerSoTimeout(int i) {
        this.selectorThread.setServerSoTimeout(i);
        this.setAttribute("serverSoTimeout", "" + i);
    }

    public void setSecure(boolean b) {
        super.setSecure(b);
        this.selectorThread.setSecure(b);
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.selectorThread.setMaxKeepAliveRequests(mkar);
    }

    public void setKeepAliveTimeoutInSeconds(int timeout) {
        this.selectorThread.setKeepAliveTimeoutInSeconds(timeout);
    }

    public void setKeepAliveThreadCount(int threadCount) {
        this.selectorThread.setKeepAliveThreadCount(threadCount);
    }

    public void setMinThreads(int minThreads) {
        this.selectorThread.setMinThreads(minThreads);
    }

    public void setBufferSize(int requestBufferSize) {
        super.setBufferSize(requestBufferSize);
        this.selectorThread.setBufferSize(requestBufferSize);
    }

    public void setSelectorTimeout(int selectorTimeout) {
        SelectorThread.selectorTimeout = selectorTimeout;
    }

    public int getSelectorTimeout() {
        return SelectorThread.selectorTimeout;
    }

    public void setMaxReadWorkerThreads(int maxReadWorkerThreads) {
        this.selectorThread.maxReadWorkerThreads = maxReadWorkerThreads;
    }

    public int getMaxReadWorkerThreads() {
        return this.selectorThread.maxReadWorkerThreads;
    }

    public void setDisplayConfiguration(boolean displayConfiguration) {
        this.selectorThread.displayConfiguration = displayConfiguration;
    }

    public boolean getDisplayConfiguration() {
        return this.selectorThread.displayConfiguration;
    }

    public void setRecycleTasks(boolean recycleTasks) {
        this.selectorThread.recycleTasks = recycleTasks;
    }

    public boolean getRecycleTasks() {
        return this.selectorThread.recycleTasks;
    }

    public void setUseByteBufferView(boolean useByteBufferView) {
        this.selectorThread.useByteBufferView = useByteBufferView;
    }

    public boolean getUseByteBufferView() {
        return this.selectorThread.useByteBufferView;
    }

    public void setMaxProcessorWorkerThreads(int maxProcessorWorkerThreads) {
        this.selectorThread.maxProcessorWorkerThreads = maxProcessorWorkerThreads;
    }

    public int getMaxProcessorWorkerThreads() {
        return this.selectorThread.maxProcessorWorkerThreads;
    }

    public void setMinReadQueueLength(int minReadQueueLength) {
        this.selectorThread.minReadQueueLength = minReadQueueLength;
    }

    public int getMinReadQueueLength() {
        return this.selectorThread.minReadQueueLength;
    }

    public void setMinProcessorQueueLength(int minProcessorQueueLength) {
        this.selectorThread.minProcessorQueueLength = minProcessorQueueLength;
    }

    public int getMinProcessorQueueLength() {
        return this.selectorThread.minProcessorQueueLength;
    }

    public void setUseDirectByteBuffer(boolean useDirectByteBuffer) {
        this.selectorThread.useDirectByteBuffer = useDirectByteBuffer;
    }

    public boolean getUseDirectByteBuffer() {
        return this.selectorThread.useDirectByteBuffer;
    }

    public void setQueueSizeInBytes(int maxQueueSizeInBytes) {
        this.selectorThread.maxQueueSizeInBytes = maxQueueSizeInBytes;
    }

    public void setSocketServerBacklog(int ssBackLog) {
        this.selectorThread.ssBackLog = ssBackLog;
    }

    public void setSelectorReadThreadsCount(int selectorReadThreadsCount) {
        this.selectorThread.selectorReadThreadsCount = selectorReadThreadsCount;
    }

    public void setDefaultResponseType(String defaultResponseType) {
        this.selectorThread.defaultResponseType = defaultResponseType;
    }

    public String getDefaultResponseType() {
        return this.selectorThread.defaultResponseType;
    }

    public void setForcedResponseType(String forcedResponseType) {
        this.selectorThread.forcedResponseType = forcedResponseType;
    }

    public String getForcedResponseType() {
        return this.selectorThread.forcedResponseType;
    }

    public void setSecondsMaxAge(int sMaxAges) {
        this.selectorThread.secondsMaxAge = sMaxAges;
    }

    public void setMaxCacheEntries(int mEntries) {
        this.selectorThread.maxCacheEntries = mEntries;
    }

    public int getMaxCacheEntries() {
        return this.selectorThread.maxCacheEntries;
    }

    public void setMinEntrySize(long mSize) {
        this.selectorThread.minEntrySize = mSize;
    }

    public long getMinEntrySize() {
        return this.selectorThread.minEntrySize;
    }

    public void setMaxEntrySize(long mEntrySize) {
        this.selectorThread.maxEntrySize = mEntrySize;
    }

    public long getMaxEntrySize() {
        return this.selectorThread.maxEntrySize;
    }

    public void setMaxLargeCacheSize(long mCacheSize) {
        this.selectorThread.maxLargeFileCacheSize = mCacheSize;
    }

    public long getMaxLargeCacheSize() {
        return this.selectorThread.maxLargeFileCacheSize;
    }

    public void setMaxSmallCacheSize(long mCacheSize) {
        this.selectorThread.maxSmallFileCacheSize = mCacheSize;
    }

    public long getMaxSmallCacheSize() {
        return this.selectorThread.maxSmallFileCacheSize;
    }

    public boolean isFileCacheEnabled() {
        return this.selectorThread.isFileCacheEnabled;
    }

    public void setFileCacheEnabled(boolean isFileCacheEnabled) {
        this.selectorThread.isFileCacheEnabled = isFileCacheEnabled;
    }

    public void setLargeFileCacheEnabled(boolean isLargeEnabled) {
        this.selectorThread.isLargeFileCacheEnabled = isLargeEnabled;
    }

    public boolean getLargeFileCacheEnabled() {
        return this.selectorThread.isLargeFileCacheEnabled;
    }

    public void setWebAppRootPath(String rootFolder) {
        SelectorThread.rootFolder = rootFolder;
    }

    public String getWebAppRootPath() {
        return SelectorThread.rootFolder;
    }

    public void setLogger(Logger logger) {
        if (logger != null) {
            SelectorThread.logger = logger;
        }
    }

    public Logger getLogger() {
        return SelectorThread.logger;
    }

    public SelectorThread selectorThread() {
        return this.selectorThread;
    }

    private void checkSocketFactory() throws Exception {
        if (this.secure) {
            this.sslImplementation = SSLImplementation.getInstance(this.sslImplementationName);
            this.socketFactory = this.sslImplementation.getServerSocketFactory();
            this.selectorThread.setSSLImplementation(this.sslImplementation);
        } else if (this.socketFactoryName != null) {
            this.socketFactory = GrizzlyHttpProtocol.string2SocketFactory(this.socketFactoryName);
        }
        if (this.socketFactory == null) {
            this.socketFactory = ServerSocketFactory.getDefault();
        }
        this.selectorThread.setServerSocketFactory(this.socketFactory);
    }
}

