/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ssi;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TimeZone;
import org.apache.catalina.ssi.SSIExternalResolver;
import org.apache.catalina.util.DateTool;
import org.apache.catalina.util.Strftime;
import org.apache.catalina.util.URLEncoder;

public class SSIMediator {
    protected static final String DEFAULT_CONFIG_ERR_MSG = "[an error occurred while processing this directive]";
    protected static final String DEFAULT_CONFIG_TIME_FMT = "%A, %d-%b-%Y %T %Z";
    protected static final String DEFAULT_CONFIG_SIZE_FMT = "abbrev";
    protected static URLEncoder urlEncoder = new URLEncoder();
    protected String configErrMsg = "[an error occurred while processing this directive]";
    protected String configTimeFmt = "%A, %d-%b-%Y %T %Z";
    protected String configSizeFmt = "abbrev";
    protected String className = this.getClass().getName();
    protected SSIExternalResolver ssiExternalResolver;
    protected Date lastModifiedDate;
    protected int debug;
    protected Strftime strftime;

    public SSIMediator(SSIExternalResolver ssiExternalResolver, Date lastModifiedDate, int debug) {
        this.ssiExternalResolver = ssiExternalResolver;
        this.lastModifiedDate = lastModifiedDate;
        this.debug = debug;
        this.setConfigTimeFmt(DEFAULT_CONFIG_TIME_FMT, true);
    }

    public void setConfigErrMsg(String configErrMsg) {
        this.configErrMsg = configErrMsg;
    }

    public void setConfigTimeFmt(String configTimeFmt) {
        this.setConfigTimeFmt(configTimeFmt, false);
    }

    public void setConfigTimeFmt(String configTimeFmt, boolean fromConstructor) {
        this.configTimeFmt = configTimeFmt;
        this.strftime = new Strftime(configTimeFmt, DateTool.LOCALE_US);
        this.setDateVariables(fromConstructor);
    }

    public void setConfigSizeFmt(String configSizeFmt) {
        this.configSizeFmt = configSizeFmt;
    }

    public String getConfigErrMsg() {
        return this.configErrMsg;
    }

    public String getConfigTimeFmt() {
        return this.configTimeFmt;
    }

    public String getConfigSizeFmt() {
        return this.configSizeFmt;
    }

    public Collection getVariableNames() {
        HashSet<String> variableNames = new HashSet<String>();
        variableNames.add("DATE_GMT");
        variableNames.add("DATE_LOCAL");
        variableNames.add("LAST_MODIFIED");
        this.ssiExternalResolver.addVariableNames(variableNames);
        Iterator iter = variableNames.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            if (!this.isNameReserved(name)) continue;
            iter.remove();
        }
        return variableNames;
    }

    public long getFileSize(String path, boolean virtual) throws IOException {
        return this.ssiExternalResolver.getFileSize(path, virtual);
    }

    public long getFileLastModified(String path, boolean virtual) throws IOException {
        return this.ssiExternalResolver.getFileLastModified(path, virtual);
    }

    public String getFileText(String path, boolean virtual) throws IOException {
        return this.ssiExternalResolver.getFileText(path, virtual);
    }

    protected boolean isNameReserved(String name) {
        return name.startsWith(this.className + ".");
    }

    public String getVariableValue(String variableName) {
        return this.getVariableValue(variableName, "none");
    }

    public void setVariableValue(String variableName, String variableValue) {
        if (!this.isNameReserved(variableName)) {
            this.ssiExternalResolver.setVariableValue(variableName, variableValue);
        }
    }

    public String getVariableValue(String variableName, String encoding) {
        String lowerCaseVariableName = variableName.toLowerCase();
        String variableValue = null;
        if (!this.isNameReserved(lowerCaseVariableName)) {
            variableValue = this.ssiExternalResolver.getVariableValue(variableName);
            if (variableValue == null) {
                variableName = variableName.toUpperCase();
                variableValue = this.ssiExternalResolver.getVariableValue(this.className + "." + variableName);
            }
            if (variableValue != null) {
                variableValue = this.encode(variableValue, encoding);
            }
        }
        return variableValue;
    }

    protected String formatDate(Date date, TimeZone timeZone) {
        String retVal;
        if (timeZone != null) {
            TimeZone oldTimeZone = this.strftime.getTimeZone();
            this.strftime.setTimeZone(timeZone);
            retVal = this.strftime.format(date);
            this.strftime.setTimeZone(oldTimeZone);
        } else {
            retVal = this.strftime.format(date);
        }
        return retVal;
    }

    protected String encode(String value, String encoding) {
        String retVal = null;
        if (encoding.equalsIgnoreCase("url")) {
            retVal = urlEncoder.encode(value);
        } else if (encoding.equalsIgnoreCase("none")) {
            retVal = value;
        } else if (encoding.equalsIgnoreCase("entity")) {
            retVal = value;
        } else {
            throw new IllegalArgumentException("Unknown encoding: " + encoding);
        }
        return retVal;
    }

    public void log(String message) {
        this.ssiExternalResolver.log(message, null);
    }

    public void log(String message, Throwable throwable) {
        this.ssiExternalResolver.log(message, throwable);
    }

    protected void setDateVariables(boolean fromConstructor) {
        boolean alreadySet;
        boolean bl = alreadySet = this.ssiExternalResolver.getVariableValue(this.className + ".alreadyset") != null;
        if (!fromConstructor || !alreadySet) {
            this.ssiExternalResolver.setVariableValue(this.className + ".alreadyset", "true");
            Date date = new Date();
            TimeZone timeZone = TimeZone.getTimeZone("GMT");
            String retVal = this.formatDate(date, timeZone);
            this.setVariableValue("DATE_GMT", null);
            this.ssiExternalResolver.setVariableValue(this.className + ".DATE_GMT", retVal);
            retVal = this.formatDate(date, null);
            this.setVariableValue("DATE_LOCAL", null);
            this.ssiExternalResolver.setVariableValue(this.className + ".DATE_LOCAL", retVal);
            retVal = this.formatDate(this.lastModifiedDate, null);
            this.setVariableValue("LAST_MODIFIED", null);
            this.ssiExternalResolver.setVariableValue(this.className + ".LAST_MODIFIED", retVal);
        }
    }

    static {
        urlEncoder.addSafeCharacter(',');
        urlEncoder.addSafeCharacter(':');
        urlEncoder.addSafeCharacter('-');
        urlEncoder.addSafeCharacter('_');
        urlEncoder.addSafeCharacter('.');
        urlEncoder.addSafeCharacter('*');
        urlEncoder.addSafeCharacter('/');
        urlEncoder.addSafeCharacter('!');
        urlEncoder.addSafeCharacter('~');
        urlEncoder.addSafeCharacter('\'');
        urlEncoder.addSafeCharacter('(');
        urlEncoder.addSafeCharacter(')');
    }
}

