/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cli.commands;

import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.servermgmt.AgentConfig;
import com.sun.enterprise.ee.admin.servermgmt.AgentManager;
import com.sun.enterprise.ee.admin.servermgmt.EEFileLayout;
import com.sun.enterprise.ee.cli.commands.BaseNodeAgentCommand;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class StartNodeAgentCommand
extends BaseNodeAgentCommand {
    private static final StringManager _strMgr = StringManager.getManager(StartNodeAgentCommand.class);
    private static final String DAS_PROPERTY_FILE_NAME = "das.properties";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        try {
            String[] extraPasswordOptions;
            String adminPwdAlias;
            String agentName = this.getAgentName();
            AgentConfig agentConfig = new AgentConfig(agentName, this.getAgentPath());
            AgentManager manager = this.getAgentManager(agentConfig);
            manager.validateNodeAgent(agentConfig, true);
            if (!this.isNotRunning(manager, agentConfig)) {
                CLILogger.getInstance().printDetailMessage(_strMgr.getString("TargetAlreadyRunning", new Object[]{agentName}));
                return;
            }
            this.getPortAndHost(agentConfig);
            agentConfig.put((Object)"agent.das.user", (Object)this.getUser());
            agentConfig.put((Object)"agent.das.password", (Object)this.getPassword());
            agentConfig.put((Object)"agent.masterpassword", (Object)this.getMasterPasswordWithDefaultPrompt((RepositoryManager)manager, (RepositoryConfig)agentConfig));
            manager.validateMasterPassword(agentConfig, false);
            if (this.getOption("passwordfile") != null && (adminPwdAlias = RelativePathResolver.getAlias((String)((String)agentConfig.get((Object)"agent.das.password")))) != null) {
                String masterPwd = (String)agentConfig.get((Object)"agent.masterpassword");
                String clearPwd = manager.getClearPasswordForAlias((RepositoryConfig)agentConfig, masterPwd, adminPwdAlias);
                agentConfig.put((Object)"agent.das.password", (Object)clearPwd);
            }
            if ((extraPasswordOptions = manager.getExtraPasswordOptions(agentConfig)) != null) {
                agentConfig.put((Object)"agent.extraPasswords", (Object)this.getExtraPasswords(extraPasswordOptions));
            }
            String startInstancesOverride = this.getOption("startinstances");
            String syncInstancesOverride = this.getOption("syncinstances");
            CLILogger.getInstance().printDebugMessage("startInstanceOverride = " + startInstancesOverride);
            CLILogger.getInstance().printDebugMessage("syncInstanceOverride = " + syncInstancesOverride);
            if (this.getBooleanOption("verbose")) {
                agentConfig.put((Object)"domain.verbose", (Object)Boolean.TRUE);
            }
            manager.startNodeAgent(startInstancesOverride, syncInstancesOverride);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                CLILogger.getInstance().printDetailMessage(e.getLocalizedMessage());
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), (Throwable)e);
        }
    }

    private void getPortAndHost(AgentConfig ac) {
        EEFileLayout efl = new EEFileLayout((RepositoryConfig)ac);
        try {
            ConfigContext cc;
            HttpListener admin;
            File xmlFile = efl.getDomainConfigFile();
            if (xmlFile.exists() && (admin = ServerHelper.getHttpListener((ConfigContext)(cc = ConfigFactory.createConfigContext((String)xmlFile.getAbsolutePath())), (String)"server", (String)"admin-listener")) != null) {
                String port = admin.getPort();
                this.setOption("port", port);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            File dasProperties = new File(efl.getConfigRoot(), DAS_PROPERTY_FILE_NAME);
            if (dasProperties.exists()) {
                Properties prop = new Properties();
                prop.load(new BufferedInputStream(new FileInputStream(dasProperties)));
                String host = prop.getProperty("agent.das.host");
                this.setOption("host", host);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

