/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.SignalAcquireException;
import com.sun.enterprise.ee.cms.core.SignalReleaseException;
import com.sun.enterprise.ee.cms.impl.common.GMSContext;
import com.sun.enterprise.ee.cms.impl.common.GMSContextFactory;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlannedShutdownSignalImpl
implements PlannedShutdownSignal {
    private String memberToken;
    private String groupName;
    protected static final Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private static final String MEMBER_DETAILS = "MEMBERDETAILS";
    private static GMSContext ctx;
    private long startTime;
    private GMSConstants.shutdownType shutdownType;

    public PlannedShutdownSignalImpl(String memberToken, String groupName, long startTime, GMSConstants.shutdownType shutdownType2) {
        this.memberToken = memberToken;
        this.groupName = groupName;
        this.startTime = startTime;
        this.shutdownType = shutdownType2;
        ctx = GMSContextFactory.getGMSContext(groupName);
    }

    PlannedShutdownSignalImpl(PlannedShutdownSignal signal) {
        this.memberToken = signal.getMemberToken();
        this.groupName = signal.getGroupName();
        this.startTime = signal.getStartTime();
        this.shutdownType = signal.getEventSubType();
        ctx = GMSContextFactory.getGMSContext(this.groupName);
    }

    @Override
    public void acquire() throws SignalAcquireException {
    }

    @Override
    public void release() throws SignalReleaseException {
        this.memberToken = null;
    }

    @Override
    public String getMemberToken() {
        return this.memberToken;
    }

    @Override
    public Map<Serializable, Serializable> getMemberDetails() {
        return ctx.getDistributedStateCache().getFromCacheForPattern(MEMBER_DETAILS, this.memberToken);
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public GMSConstants.shutdownType getEventSubType() {
        return this.shutdownType;
    }
}

