/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import com.sun.enterprise.jxtamgmt.ClusterManager;
import com.sun.enterprise.jxtamgmt.ClusterView;
import com.sun.enterprise.jxtamgmt.ClusterViewEvent;
import com.sun.enterprise.jxtamgmt.ClusterViewEventListener;
import com.sun.enterprise.jxtamgmt.ClusterViewEvents;
import com.sun.enterprise.jxtamgmt.JxtaUtil;
import com.sun.enterprise.jxtamgmt.SystemAdvertisement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.id.ID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterViewManager {
    private static final Logger LOG = JxtaUtil.getLogger(ClusterViewManager.class.getName());
    private TreeMap<String, SystemAdvertisement> view = new TreeMap();
    private SystemAdvertisement advertisement = null;
    private SystemAdvertisement masterAdvertisement = null;
    private List<ClusterViewEventListener> cvListeners = new ArrayList<ClusterViewEventListener>();
    private long viewId = 0L;
    private long masterViewID = 0L;
    private ClusterManager manager;
    private ReentrantLock viewLock = new ReentrantLock();

    public ClusterViewManager(SystemAdvertisement advertisement, ClusterManager manager, List<ClusterViewEventListener> listeners) {
        this.advertisement = advertisement;
        this.manager = manager;
        this.cvListeners.addAll(listeners);
    }

    public void start() {
        this.setMaster(this.advertisement, true);
    }

    public void addClusterViewEventListener(ClusterViewEventListener listener) {
        this.cvListeners.add(listener);
    }

    public void removeClusterViewEventListener(ClusterViewEventListener listener) {
        this.cvListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(SystemAdvertisement advertisement) {
        this.lockLog("add()");
        this.viewLock.lock();
        try {
            if (!this.view.containsKey(advertisement.getID().toString())) {
                LOG.log(Level.FINER, new StringBuffer().append("Adding ").append(advertisement.getName()).append("   ").append(advertisement.getID().toString()).toString());
                this.view.put(advertisement.getID().toString(), advertisement);
                LOG.log(Level.FINER, MessageFormat.format("Cluster view now contains {0} entries", this.getViewSize()));
            }
        }
        finally {
            this.viewLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaster(SystemAdvertisement advertisement, boolean notify) {
        if (!advertisement.equals(this.masterAdvertisement)) {
            this.masterAdvertisement = advertisement;
            this.lockLog("setMaster()");
            this.viewLock.lock();
            try {
                this.view.put(this.masterAdvertisement.getID().toString(), this.masterAdvertisement);
            }
            finally {
                this.viewLock.unlock();
            }
            if (notify) {
                this.notifyListeners(new ClusterViewEvent(ClusterViewEvents.MASTER_CHANGE_EVENT, advertisement));
            }
            if (advertisement.getID().equals(this.advertisement.getID())) {
                LOG.log(Level.FINER, "Setting MasterNode Role");
            } else {
                LOG.log(Level.FINER, new StringBuffer().append("Setting Master Node :").append(advertisement.getName()).append(' ').append(advertisement.getID()).toString());
            }
        }
    }

    public SystemAdvertisement getMaster() {
        return this.masterAdvertisement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SystemAdvertisement get(ID id) {
        SystemAdvertisement adv;
        this.lockLog("get()");
        this.viewLock.lock();
        try {
            adv = this.view.get(id.toString());
        }
        finally {
            this.viewLock.unlock();
        }
        return adv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SystemAdvertisement remove(SystemAdvertisement advertisement) {
        ID id = advertisement.getID();
        if (this.containsKey(id)) {
            this.lockLog("remove()");
            this.viewLock.lock();
            try {
                this.view.remove(id.toString());
            }
            finally {
                this.viewLock.unlock();
            }
            LOG.log(Level.FINER, "Removed " + advertisement.getName() + "   " + advertisement.getID().toString());
        } else {
            LOG.log(Level.FINEST, "Skipping removal of " + id + " Not in view");
        }
        return advertisement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(ID id) {
        boolean contains;
        this.viewLock.lock();
        try {
            contains = this.view.containsKey(id.toString());
        }
        finally {
            this.viewLock.unlock();
        }
        return contains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reset() {
        LOG.log(Level.FINEST, "Resetting View");
        this.lockLog("reset()");
        this.viewLock.lock();
        try {
            this.view.clear();
            this.view.put(this.advertisement.getID().toString(), this.advertisement);
        }
        finally {
            this.viewLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterView getLocalView() {
        TreeMap temp;
        this.lockLog("getLocalView()");
        this.viewLock.lock();
        try {
            temp = (TreeMap)this.view.clone();
        }
        finally {
            this.viewLock.unlock();
        }
        LOG.log(Level.FINEST, "returning new ClusterView with view size:" + this.view.size());
        return new ClusterView(temp, this.viewId++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getViewSize() {
        int size;
        this.lockLog("getViewSize()");
        this.viewLock.lock();
        try {
            size = this.view.size();
        }
        finally {
            this.viewLock.unlock();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SystemAdvertisement getMasterCandidate() {
        SystemAdvertisement adv;
        String id = this.view.firstKey();
        this.lockLog("getMasterCandidate()");
        this.viewLock.lock();
        try {
            adv = this.view.get(id);
        }
        finally {
            this.viewLock.unlock();
        }
        LOG.log(Level.FINER, new StringBuffer().append("Returning Master Candidate Node :").append(adv.getName()).append(' ').append(adv.getID()).toString());
        return adv;
    }

    public boolean isMaster() {
        return this.masterAdvertisement != null && this.masterAdvertisement.getID().equals(this.advertisement.getID());
    }

    public boolean isFirst() {
        String id = this.view.firstKey();
        return this.advertisement.getID().toString().equals(id);
    }

    public int indexOf(ID id) {
        if (id == null) {
            return -1;
        }
        String idStr = id.toString();
        int index = 0;
        for (String s : this.view.keySet()) {
            String key = s;
            if (key.equals(idStr)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public ID getID(String name) {
        return this.manager.getID(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToView(List<SystemAdvertisement> newView, boolean authoritative, ClusterViewEvent cvEvent) {
        if (cvEvent == null) {
            return;
        }
        if (authoritative) {
            LOG.log(Level.FINER, "Resetting View");
            this.reset();
        }
        if (authoritative) {
            boolean changed = false;
            this.lockLog("addToView()");
            this.viewLock.lock();
            try {
                if (!newView.contains(this.manager.getSystemAdvertisement())) {
                    this.view.put(this.manager.getSystemAdvertisement().getID().toString(), this.manager.getSystemAdvertisement());
                }
                for (SystemAdvertisement elem : newView) {
                    LOG.log(Level.FINER, new StringBuffer().append("Adding ").append(elem.getID()).append(" to view").toString());
                    if (!this.view.containsKey(elem.getID().toString())) {
                        changed = true;
                    }
                    this.view.put(elem.getID().toString(), elem);
                }
            }
            finally {
                this.viewLock.unlock();
            }
            if (changed) {
                this.notifyListeners(cvEvent);
            }
        }
    }

    void notifyListeners(ClusterViewEvent event) {
        LOG.log(Level.FINER, MessageFormat.format("Notifying the {0} to listeners, peer in event is {1}", event.getEvent().toString(), event.getAdvertisement().getName()));
        for (ClusterViewEventListener elem : this.cvListeners) {
            elem.clusterViewEvent(event, this.getLocalView());
        }
    }

    public void setInDoubtPeerState(SystemAdvertisement adv) {
        if (adv == null) {
            throw new IllegalArgumentException("SystemAdvertisment may not be null");
        }
        this.notifyListeners(new ClusterViewEvent(ClusterViewEvents.IN_DOUBT_EVENT, adv));
    }

    public void setPeerStoppingState(SystemAdvertisement adv) {
        if (adv == null) {
            throw new IllegalArgumentException("SystemAdvertisment may not be null");
        }
        this.notifyListeners(new ClusterViewEvent(ClusterViewEvents.PEER_STOP_EVENT, adv));
    }

    public void setClusterStoppingState(SystemAdvertisement adv) {
        if (adv == null) {
            throw new IllegalArgumentException("SystemAdvertisment may not be null");
        }
        this.notifyListeners(new ClusterViewEvent(ClusterViewEvents.CLUSTER_STOP_EVENT, adv));
    }

    public void setPeerNoLongerInDoubtState(SystemAdvertisement adv) {
        if (adv == null) {
            throw new IllegalArgumentException("SystemAdvertisment may not be null");
        }
        this.notifyListeners(new ClusterViewEvent(ClusterViewEvents.NO_LONGER_INDOUBT_EVENT, adv));
    }

    public long getMasterViewID() {
        return this.masterViewID;
    }

    public void setMasterViewID(long masterViewID) {
        this.masterViewID = masterViewID;
    }

    private void lockLog(String method) {
        LOG.log(Level.FINE, MessageFormat.format("{0} viewLock Hold count :{1}, lock queue count:{2}", method, this.viewLock.getHoldCount(), this.viewLock.getQueueLength()));
    }
}

