/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import com.sun.enterprise.jxtamgmt.JxtaConfigConstants;
import com.sun.enterprise.jxtamgmt.JxtaUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.document.AdvertisementFactory;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peer.PeerID;
import net.jxta.peergroup.NetPeerGroupFactory;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.PipeID;
import net.jxta.platform.NetworkConfigurator;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.rendezvous.RendezVousService;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;

public class NetworkManager
implements RendezvousListener {
    private static final Logger LOG = JxtaUtil.getLogger();
    private static MessageDigest digest;
    private static PeerGroup netPeerGroup;
    private static boolean started;
    private static boolean stopped;
    private RendezVousService rendezvous;
    private String groupName = "defaultGroup";
    private String instanceName;
    private static final String PREFIX = "SHOAL";
    private static final String connectLock = "connectLock";
    private static final File home;
    private final PipeID socketID;
    private final PipeID pipeID;
    private static String SOCKETSEED;
    private static String PIPESEED;
    private static String HEALTHSEED;
    private static String MASTERSEED;
    private static String SESSIONQUERYSEED;
    private static String APPSERVICESEED;
    private String mcastAddress;
    private int mcastPort = 0;

    public NetworkManager(String groupName, String instanceName, Map properties) {
        System.setProperty("net.jxta.logging.Logging", Level.OFF.toString());
        this.groupName = groupName;
        this.instanceName = instanceName;
        this.socketID = this.getSocketID(instanceName);
        this.pipeID = this.getPipeID(instanceName);
        if (properties != null && !properties.isEmpty()) {
            Object mp;
            Object ma = properties.get(JxtaConfigConstants.MULTICASTADDRESS.toString());
            if (ma != null) {
                this.mcastAddress = (String)ma;
            }
            if ((mp = properties.get(JxtaConfigConstants.MULTICASTPORT.toString())) != null) {
                if (mp instanceof String) {
                    this.mcastPort = Integer.parseInt((String)mp);
                } else if (mp instanceof Integer) {
                    this.mcastPort = (Integer)mp;
                }
            }
        }
    }

    private static byte[] hash(String expression) {
        byte[] digArray;
        if (expression == null) {
            throw new IllegalArgumentException("Invalid null expression");
        }
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException ex) {
                LOG.log(Level.WARNING, ex.getLocalizedMessage());
            }
        }
        digest.reset();
        try {
            digArray = digest.digest(expression.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException impossible) {
            LOG.log(Level.WARNING, "digestEncoding unsupported:" + impossible.getLocalizedMessage() + ":returning digest with default encoding");
            digArray = digest.digest(expression.getBytes());
        }
        return digArray;
    }

    public PipeID getPipeID(String instanceName) {
        String seed = instanceName + PIPESEED;
        return IDFactory.newPipeID((PeerGroupID)PeerGroupID.defaultNetPeerGroupID, (byte[])NetworkManager.hash(seed.toUpperCase()));
    }

    public PipeID getSocketID(String instanceName) {
        String seed = instanceName + SOCKETSEED;
        return IDFactory.newPipeID((PeerGroupID)PeerGroupID.defaultNetPeerGroupID, (byte[])NetworkManager.hash(seed.toUpperCase()));
    }

    public PeerID getPeerID(String instanceName) {
        return IDFactory.newPeerID((PeerGroupID)this.getInfraPeerGroupID(), (byte[])NetworkManager.hash(PREFIX + instanceName.toUpperCase()));
    }

    public PeerGroupID getPeerGroupID(String groupName) {
        if (this.mcastAddress == null && this.mcastPort <= 0) {
            return IDFactory.newPeerGroupID((PeerGroupID)PeerGroupID.defaultNetPeerGroupID, (byte[])NetworkManager.hash(PREFIX + groupName.toUpperCase()));
        }
        return IDFactory.newPeerGroupID((PeerGroupID)PeerGroupID.defaultNetPeerGroupID, (byte[])NetworkManager.hash(PREFIX + groupName.toUpperCase() + this.mcastAddress + this.mcastPort));
    }

    public PipeID getHealthPipeID() {
        return IDFactory.newPipeID((PeerGroupID)this.getInfraPeerGroupID(), (byte[])NetworkManager.hash(HEALTHSEED.toUpperCase()));
    }

    public PipeID getMasterPipeID() {
        return IDFactory.newPipeID((PeerGroupID)this.getInfraPeerGroupID(), (byte[])NetworkManager.hash(MASTERSEED.toUpperCase()));
    }

    public PipeID getSessionQueryPipeID() {
        return IDFactory.newPipeID((PeerGroupID)this.getInfraPeerGroupID(), (byte[])NetworkManager.hash(SESSIONQUERYSEED.toUpperCase()));
    }

    public PipeID getAppServicePipeID() {
        return IDFactory.newPipeID((PeerGroupID)this.getInfraPeerGroupID(), (byte[])NetworkManager.hash(APPSERVICESEED.toUpperCase()));
    }

    private PipeAdvertisement getTemplatePipeAdvertisement(String instanceName) {
        PipeAdvertisement advertisement = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
        advertisement.setType("JxtaUnicast");
        advertisement.setName(instanceName);
        return advertisement;
    }

    public PipeAdvertisement getSocketAdvertisement(String instanceName) {
        PipeAdvertisement advertisement = this.getTemplatePipeAdvertisement(instanceName);
        advertisement.setPipeID((ID)this.getSocketID(instanceName));
        return advertisement;
    }

    public PipeAdvertisement getPipeAdvertisement(String instanceName) {
        PipeAdvertisement advertisement = this.getTemplatePipeAdvertisement(instanceName);
        advertisement.setPipeID((ID)this.getPipeID(instanceName));
        return advertisement;
    }

    public PeerGroupID getInfraPeerGroupID() {
        return this.getPeerGroupID(this.groupName);
    }

    public synchronized void start() throws PeerGroupException, IOException {
        if (started) {
            return;
        }
        File userHome = new File(home, this.instanceName);
        NetworkManager.clearCache(userHome);
        NetworkConfigurator config = new NetworkConfigurator(5576, userHome.toURI());
        config.setPeerID(this.getPeerID(this.instanceName));
        config.setName(this.instanceName);
        config.setDescription("Created by Jxta Cluster Management NetworkManager");
        config.setTcpStartPort(9701);
        config.setTcpEndPort(9999);
        config.setMulticastSize(65536);
        config.setInfrastructureID((ID)this.getInfraPeerGroupID());
        config.setInfrastructureName(this.groupName);
        config.setInfrastructureDescriptionStr(this.groupName + " Infrastructure Group Name");
        if (this.mcastAddress != null) {
            config.setMulticastAddress(this.mcastAddress);
        }
        if (this.mcastPort > 0) {
            config.setMulticastPort(this.mcastPort);
        }
        NetPeerGroupFactory factory = new NetPeerGroupFactory(config.getPlatformConfig(), userHome.toURI());
        netPeerGroup = factory.getInterface();
        this.rendezvous = netPeerGroup.getRendezVousService();
        this.rendezvous.addListener((RendezvousListener)this);
        stopped = false;
        started = true;
    }

    private static void clearCache(File rootDir) {
        try {
            if (rootDir.exists()) {
                File[] list;
                for (File aList : list = rootDir.listFiles()) {
                    if (aList.isDirectory()) {
                        NetworkManager.clearCache(aList);
                        continue;
                    }
                    aList.delete();
                }
            }
            rootDir.delete();
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Unable to clear " + rootDir.toString(), t);
        }
    }

    public synchronized void stop() {
        if (stopped && !started) {
            return;
        }
        try {
            this.rendezvous.removeListener((RendezvousListener)this);
            netPeerGroup.stopApp();
            netPeerGroup.unref();
            netPeerGroup = null;
            File userHome = new File(home, this.instanceName);
            NetworkManager.clearCache(userHome);
        }
        catch (Throwable th) {
            LOG.log(Level.FINEST, th.getLocalizedMessage());
        }
        stopped = true;
        started = false;
    }

    public PeerGroup getNetPeerGroup() {
        return netPeerGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void waitForRendezvousConncection(long timeout) {
        if (this.rendezvous.isConnectedToRendezVous()) return;
        try {
            if (this.rendezvous.isConnectedToRendezVous()) return;
            String string = connectLock;
            synchronized (connectLock) {
                connectLock.wait(timeout);
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
        }
        catch (InterruptedException e) {
            LOG.log(Level.WARNING, e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rendezvousEvent(RendezvousEvent event) {
        if (event.getType() != 0 && event.getType() != 1 && event.getType() != 8) return;
        String string = connectLock;
        synchronized (connectLock) {
            connectLock.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public PeerID getPeerID() {
        if (stopped && !started) {
            return null;
        }
        return netPeerGroup.getPeerID();
    }

    public boolean isStarted() {
        return !stopped && started;
    }

    public PipeID getSocketID() {
        return this.socketID;
    }

    public PipeID getPipeID() {
        return this.pipeID;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public File getHome() {
        return home;
    }

    static {
        started = false;
        stopped = false;
        home = new File(System.getProperty("JXTA_HOME", ".shoal"));
        SOCKETSEED = "SHOALsocket";
        PIPESEED = "SHOALBIDI";
        HEALTHSEED = "SHOALHEALTH";
        MASTERSEED = "SHOALMASTER";
        SESSIONQUERYSEED = "SHOALSESSIONQ";
        APPSERVICESEED = "APPSERVICE";
    }
}

