/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiTargetTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;

public class JbiInstallComponentTask
extends JbiTargetTask {
    private static final String SUCCESS_STATUS_KEY = "jbi.ui.ant.install.successful";
    private static final String FAILED_STATUS_KEY = "jbi.ui.ant.install.failed";
    private File mInstallFile;
    private List mParamList;
    private File mParamsFile = null;
    private String mComponentName = null;

    public String getName() {
        return this.mComponentName;
    }

    public void setName(String name) {
        this.mComponentName = name;
    }

    public File getFile() {
        return this.mInstallFile;
    }

    public void setFile(File file) {
        this.mInstallFile = file;
    }

    public File getParams() {
        return this.mParamsFile;
    }

    public void setParams(File paramsFile) {
        this.mParamsFile = paramsFile;
    }

    protected void validateInstallFile(File installFile) throws BuildException {
        if (installFile == null) {
            this.throwTaskBuildException("jbi.ui.ant.install.error.comp.archive.file.path.null");
        }
        if (installFile.getPath().trim().length() <= 0) {
            this.throwTaskBuildException("jbi.ui.ant.install.error.comp.archive.file.path.required");
        }
        if (!installFile.exists()) {
            this.throwTaskBuildException("jbi.ui.ant.install.error.comp.archive.file.not.exist", installFile.getName());
        }
        if (installFile.isDirectory()) {
            this.throwTaskBuildException("jbi.ui.ant.install.error.comp.archive.file.is.directory");
        }
    }

    protected void validateInstallFromDomainAttributes(String compName, String target) throws BuildException {
        if (compName.trim().length() == 0) {
            this.throwTaskBuildException("jbi.ui.ant.install.from.domain.error.comp.name.required");
        }
        if ("domain".equals(target)) {
            this.throwTaskBuildException("jbi.ui.ant.install.error.comp.invalid.target.with.name.attrib");
        }
    }

    public void executeTask() throws BuildException {
        String installFileAbsolutePath = null;
        boolean installFromDoamin = false;
        String compName = this.getName();
        File installFile = this.getFile();
        String target = this.getValidTarget();
        if (compName == null && installFile == null) {
            this.throwTaskBuildException("jbi.ui.ant.install.error.comp.name.or.file.required");
        }
        if (compName != null && installFile != null) {
            this.throwTaskBuildException("jbi.ui.ant.install.error.comp.name.and.file.set");
        }
        if (compName != null) {
            this.validateInstallFromDomainAttributes(compName, target);
            installFromDoamin = true;
        } else {
            this.validateInstallFile(installFile);
            installFileAbsolutePath = installFile.getAbsolutePath();
        }
        try {
            String result = null;
            Properties params = this.getParamsAsProperties();
            result = installFromDoamin ? this.getJBIAdminCommands().installComponentFromDomain(compName, params, target) : this.getJBIAdminCommands().installComponent(installFileAbsolutePath, params, target);
            this.printTaskSuccess(result);
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    protected String getTaskFailedStatusI18NKey() {
        return FAILED_STATUS_KEY;
    }

    protected String getTaskSuccessStatusI18NKey() {
        return SUCCESS_STATUS_KEY;
    }

    protected List getParamList() {
        if (this.mParamList == null) {
            this.mParamList = new ArrayList();
        }
        return this.mParamList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadParamsFromFile(File file) throws BuildException {
        String absFilePath = null;
        String fileName = null;
        if (file != null) {
            absFilePath = file.getAbsolutePath();
            fileName = file.getName();
        }
        if (file == null || !file.exists()) {
            String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.params.file.not.exist", new Object[]{fileName});
            throw new BuildException(msg, this.getLocation());
        }
        if (file.isDirectory()) {
            String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.params.file.is.directory", null);
            throw new BuildException(msg, this.getLocation());
        }
        Properties props = new Properties();
        this.logDebug("Loading " + file.getAbsolutePath());
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                props.load(fis);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
            return props;
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex, this.getLocation());
        }
    }

    protected Properties getParamsAsProperties() throws BuildException {
        Properties props = new Properties();
        for (Param param : this.getParamList()) {
            String name = param.getName().trim();
            String value = param.getValue().trim();
            if (name.length() <= 0 || value.length() <= 0) {
                String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.param.invalid", new Object[]{name, value});
                throw new BuildException(msg, this.getLocation());
            }
            if (name.length() > 0) {
                props.setProperty(name, value);
                continue;
            }
            this.logDebug("Blank parameter name passed to the install task using <param> nested element.");
        }
        Properties paramsProps = null;
        paramsProps = null;
        File paramsFile = this.getParams();
        if (paramsFile != null) {
            paramsProps = this.loadParamsFromFile(paramsFile);
            props.putAll((Map<?, ?>)paramsProps);
        } else {
            this.logDebug("No File based Parameters passed to installer Task via nested params element");
        }
        return props;
    }

    public Param createParam() {
        Param param = new Param();
        this.getParamList().add(param);
        return param;
    }

    public class Param {
        private String mName = "";
        private String mValue = "";

        public String getName() {
            return this.mName;
        }

        public void setName(String name) {
            this.mName = name;
        }

        public String getValue() {
            return this.mValue;
        }

        public void setValue(String value) {
            this.mValue = value;
        }
    }
}

