/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.ant;

import com.sun.jbi.ui.ant.JbiTargetTask;
import com.sun.jbi.ui.common.JBIManagementMessage;
import com.sun.jbi.ui.common.JBIResultXmlBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;

public class JbiSetConfigurationTask
extends JbiTargetTask {
    private static final String SUCCESS_STATUS_KEY = "jbi.ui.ant.set.configuration.successful";
    private static final String FAILED_STATUS_KEY = "jbi.ui.ant.set.configuration.failed";
    private static final String PARTIAL_SUCCESS_STATUS_KEY = "jbi.ui.ant.set.configuration.partial.success";
    private List mParamList;
    private File mParamsFile = null;
    private String mComponentName = null;

    public String getComponentName() {
        return this.mComponentName;
    }

    public void setComponentName(String componentName) {
        this.mComponentName = componentName;
    }

    public File getParams() {
        return this.mParamsFile;
    }

    public void setParams(File paramsFile) {
        this.mParamsFile = paramsFile;
    }

    private void debugPrintParams(Properties params) {
        if (params == null) {
            this.logDebug("Set Configuration params are NULL");
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter out = new PrintWriter(stringWriter);
        params.list(out);
        out.close();
        this.logDebug(stringWriter.getBuffer().toString());
    }

    private String createFormatedSuccessJbiResultMessage(String i18nKey, Object[] args) {
        String msgCode = this.getI18NBundle().getMessage(i18nKey + ".ID");
        String msg = this.getI18NBundle().getMessage(i18nKey, args);
        String jbiResultXml = JBIResultXmlBuilder.getInstance().createJbiResultXml("JBI_ANT_TASK_SET_CONFIG", true, "INFO", msgCode, msg, args, null);
        JBIManagementMessage mgmtMsg = null;
        mgmtMsg = JBIManagementMessage.createJBIManagementMessage(jbiResultXml);
        return mgmtMsg != null ? mgmtMsg.getMessage() : msg;
    }

    private void executeSetRuntimeConfiguration() throws BuildException {
        this.logDebug("Executing Set Runtime Configuration ....");
        String target = this.getValidTarget();
        boolean restartRequired = false;
        try {
            Properties params = this.getParamsAsProperties();
            this.debugPrintParams(params);
            restartRequired = this.getJBIAdminCommands().setRuntimeConfiguration(params, target);
            String i18nKey = restartRequired ? "jbi.ui.ant.task.info.config.restart.required" : "jbi.ui.ant.task.info.config.done.on.target";
            Object[] args = new Object[]{target};
            this.printTaskSuccess(this.createFormatedSuccessJbiResultMessage(i18nKey, args));
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    private void executeSetComponentConfiguration(String componentName) throws BuildException {
        this.logDebug("Executing Set Component Configuration ....");
        String target = this.getValidTarget();
        try {
            Properties params = this.getParamsAsProperties();
            this.debugPrintParams(params);
            this.getJBIAdminCommands().setComponentConfiguration(componentName, params, target);
            String i18nKey = "jbi.ui.ant.task.info.config.comp.done.on.target";
            Object[] args = new Object[]{componentName, target};
            this.printTaskSuccess(this.createFormatedSuccessJbiResultMessage(i18nKey, args));
        }
        catch (Exception ex) {
            this.processTaskException(ex);
        }
    }

    public void executeTask() throws BuildException {
        this.logDebug("Executing Set Configuration Task....");
        String compName = this.getComponentName();
        if (compName != null && compName.trim().length() > 0) {
            this.executeSetComponentConfiguration(compName);
        } else {
            this.executeSetRuntimeConfiguration();
        }
    }

    protected String getTaskFailedStatusI18NKey() {
        return FAILED_STATUS_KEY;
    }

    protected String getTaskSuccessStatusI18NKey() {
        return SUCCESS_STATUS_KEY;
    }

    protected String getTaskPartialSuccessStatusI18NKey() {
        return PARTIAL_SUCCESS_STATUS_KEY;
    }

    protected List getParamList() {
        if (this.mParamList == null) {
            this.mParamList = new ArrayList();
        }
        return this.mParamList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadParamsFromFile(File file) throws BuildException {
        String absFilePath = null;
        String fileName = null;
        if (file != null) {
            absFilePath = file.getAbsolutePath();
            fileName = file.getName();
        }
        if (file == null || !file.exists()) {
            String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.config.params.file.not.exist", new Object[]{fileName});
            throw new BuildException(msg, this.getLocation());
        }
        if (file.isDirectory()) {
            String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.config.params.file.is.directory", null);
            throw new BuildException(msg, this.getLocation());
        }
        Properties props = new Properties();
        this.logDebug("Loading " + file.getAbsolutePath());
        try {
            FileInputStream fis = new FileInputStream(file);
            try {
                props.load(fis);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
            return props;
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex, this.getLocation());
        }
    }

    protected Properties getParamsAsProperties() throws BuildException {
        Properties props = new Properties();
        for (Param param : this.getParamList()) {
            String name = param.getName().trim();
            String value = param.getValue().trim();
            if (name.length() <= 0 || value.length() <= 0) {
                String msg = this.createFailedFormattedJbiAdminResult("jbi.ui.ant.task.error.config.param.invalid", new Object[]{name, value});
                throw new BuildException(msg, this.getLocation());
            }
            if (name.length() > 0) {
                props.setProperty(name, value);
                continue;
            }
            this.logDebug("Blank parameter name passed to the install task using <param> nested element.");
        }
        Properties paramsProps = null;
        paramsProps = null;
        File paramsFile = this.getParams();
        if (paramsFile != null) {
            paramsProps = this.loadParamsFromFile(paramsFile);
            props.putAll((Map<?, ?>)paramsProps);
        } else {
            this.logDebug("No File based Parameters passed to installer Task via nested params element");
        }
        return props;
    }

    public Param createParam() {
        Param param = new Param();
        this.getParamList().add(param);
        return param;
    }

    public class Param {
        private String mName = "";
        private String mValue = "";

        public String getName() {
            return this.mName;
        }

        public void setName(String name) {
            this.mName = name;
        }

        public String getValue() {
            return this.mValue;
        }

        public void setValue(String value) {
            this.mValue = value;
        }
    }
}

