/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.i18n;

import com.sun.logging.LogDomains;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StringManagerBase {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private ResourceBundle _resourceBundle = null;
    private static final String NO_DEFAULT = "No local string defined";
    private static Hashtable managers = new Hashtable();

    protected StringManagerBase(String resourceBundleName) {
        try {
            this._resourceBundle = ResourceBundle.getBundle(resourceBundleName);
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "iplanet_util.no_resource_bundle", e);
        }
    }

    public static synchronized StringManagerBase getStringManager(String resourceBundleName) {
        StringManagerBase mgr = (StringManagerBase)managers.get(resourceBundleName);
        if (mgr == null) {
            mgr = new StringManagerBase(resourceBundleName);
            try {
                managers.put(resourceBundleName, mgr);
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "iplanet_util.error_while_caching", e);
            }
        }
        return mgr;
    }

    public String getString(String key) {
        return this.getStringWithDefault(key, NO_DEFAULT);
    }

    public String getStringWithDefault(String key, String defaultValue) {
        String value = null;
        try {
            value = this._resourceBundle.getString(key);
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "No local string for: " + key, e);
        }
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public String getStringWithDefault(String key, String defaultFormat, Object[] arguments) {
        MessageFormat f = new MessageFormat(this.getStringWithDefault(key, defaultFormat));
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] == null) {
                arguments[i] = "null";
                continue;
            }
            if (arguments[i] instanceof String || arguments[i] instanceof Number || arguments[i] instanceof Date) continue;
            arguments[i] = arguments[i].toString();
        }
        String fmtStr = null;
        try {
            fmtStr = f.format(arguments);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "iplanet_util.error_while_formating", e);
            fmtStr = defaultFormat;
        }
        return fmtStr;
    }

    public String getString(String key, Object arg1) {
        return this.getStringWithDefault(key, NO_DEFAULT, new Object[]{arg1});
    }

    public String getString(String key, Object arg1, Object arg2) {
        return this.getStringWithDefault(key, NO_DEFAULT, new Object[]{arg1, arg2});
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3) {
        return this.getStringWithDefault(key, NO_DEFAULT, new Object[]{arg1, arg2, arg3});
    }

    public String getString(String key, Object arg1, Object arg2, Object arg3, Object arg4) {
        return this.getStringWithDefault(key, NO_DEFAULT, new Object[]{arg1, arg2, arg3, arg4});
    }

    public String getString(String key, Object[] args) {
        return this.getStringWithDefault(key, NO_DEFAULT, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long b = System.currentTimeMillis();
        try {
            StringManagerBase sm = StringManagerBase.getStringManager("com.sun.enterprise.util.i18n.LocalStrings");
            String ls = sm.getString("test", 7, new Date(System.currentTimeMillis()), "a disturbance in the Force");
            System.out.println(ls);
            System.out.println(sm.getString("bad"));
        }
        catch (Exception e) {
            System.out.println("---- Error ---- ");
            e.printStackTrace();
        }
        finally {
            long a = System.currentTimeMillis();
            System.out.println("Time: " + (a - b));
        }
    }
}

