/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.connection;

import com.sun.mfwk.agent.appserv.connection.ConnectorFactory;
import com.sun.mfwk.agent.appserv.connection.TrustAnyConnectionFactory;
import com.sun.mfwk.agent.appserv.connection.X509TrustManagerImpl;
import com.sun.mfwk.agent.appserv.logging.LogDomains;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;

public class ConnectionRegistry {
    private static Map _connectors = null;
    private static Map _connectorInfo = null;
    private static final ConnectionRegistry _instance = new ConnectionRegistry();

    public static ConnectionRegistry getInstance() {
        return _instance;
    }

    private ConnectionRegistry() {
        _connectors = new Hashtable();
        _connectorInfo = new Hashtable();
    }

    public MBeanServerConnection getConnection(String serverName, String domainName) throws IOException {
        String instanceName = domainName + serverName;
        MBeanServerConnection connection = null;
        JMXConnector connector = (JMXConnector)_connectors.get(instanceName);
        if (connector == null) {
            throw new IllegalArgumentException();
        }
        try {
            connection = connector.getMBeanServerConnection();
            if (TrustAnyConnectionFactory.isStaleConnection(connection)) {
                connection = this.refreshConnection(instanceName);
            }
        }
        catch (Exception e) {
            connection = this.refreshConnection(instanceName);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MBeanServerConnection refreshConnection(String instanceName) throws MalformedURLException, IOException {
        LogDomains.getLogger().fine("Refreshing connection for server: " + instanceName);
        Map info = (Map)_connectorInfo.get(instanceName);
        if (info == null) {
            throw new IllegalArgumentException();
        }
        ConnectorFactory factory = new ConnectorFactory();
        JMXConnector connector = factory.getConnector(info);
        ConnectionRegistry connectionRegistry = this;
        synchronized (connectionRegistry) {
            _connectors.put(instanceName, connector);
        }
        return connector.getMBeanServerConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionCredentials(String serverName, String domainName, Map info) throws MalformedURLException, IOException {
        String instanceName = domainName + serverName;
        LogDomains.getLogger().fine("Setting connection credentials for server: " + instanceName);
        ConnectorFactory factory = new ConnectorFactory();
        JMXConnector connector = factory.getConnector(info);
        ConnectionRegistry connectionRegistry = this;
        synchronized (connectionRegistry) {
            _connectors.put(instanceName, connector);
            _connectorInfo.put(instanceName, info);
        }
    }

    public synchronized void removeConnection(String serverName, String domainName) {
        String instanceName = domainName + serverName;
        LogDomains.getLogger().fine("Removing connection for server: " + instanceName);
        _connectors.remove(instanceName);
        _connectorInfo.remove(instanceName);
        X509TrustManagerImpl.removeCertificate(instanceName);
    }
}

