/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.connection;

import com.sun.mfwk.agent.appserv.logging.LogDomains;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Map;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

class X509TrustManagerImpl
implements X509TrustManager {
    private static Map _certDB = new Hashtable();

    public X509TrustManagerImpl(String serverName, X509Certificate cert) {
        _certDB.put(serverName, cert);
    }

    static X509Certificate removeCertificate(String serverName) {
        return (X509Certificate)_certDB.remove(serverName);
    }

    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType) throws IllegalArgumentException, CertificateException {
        boolean trusted = false;
        if (chain == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < chain.length; ++i) {
            if (!this.isCertTrusted(chain[i])) continue;
            trusted = true;
            break;
        }
        if (!trusted) {
            LogDomains.getLogger().warning("Server certificate chain is unknown; can not be trusted.");
            throw new CertificateException();
        }
    }

    private boolean isCertTrusted(X509Certificate cert) {
        boolean trusted = false;
        try {
            Collection collection = _certDB.values();
            for (X509Certificate c2 : collection) {
                if (!this.isCertEqual(cert, c2)) continue;
                trusted = true;
                break;
            }
        }
        catch (Exception e) {
            trusted = false;
        }
        return trusted;
    }

    private boolean isCertEqual(X509Certificate cert1, X509Certificate cert2) {
        boolean equal = false;
        try {
            BigInteger serial1 = cert1.getSerialNumber();
            BigInteger serial2 = cert2.getSerialNumber();
            if (serial1 != null && serial1.equals(serial2)) {
                X500Principal p1 = cert1.getSubjectX500Principal();
                X500Principal p2 = cert2.getSubjectX500Principal();
                if (p1 != null && p1.equals(p2) && this.isSignatureEqual(cert1, cert2)) {
                    equal = true;
                }
            }
        }
        catch (Exception e) {
            equal = false;
        }
        return equal;
    }

    private boolean isSignatureEqual(X509Certificate c1, X509Certificate c2) {
        boolean equal = false;
        try {
            byte[] s1 = c1.getSignature();
            byte[] s2 = c2.getSignature();
            if (s1.length == s2.length) {
                boolean allBytesEqual = true;
                for (int j = 0; j < s1.length; ++j) {
                    if (s1[j] == s2[j]) continue;
                    allBytesEqual = false;
                    break;
                }
                if (allBytesEqual) {
                    equal = true;
                }
            }
        }
        catch (Exception e) {
            equal = false;
        }
        return equal;
    }

    public void checkClientTrusted(X509Certificate[] chain, String authType) {
    }
}

