/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.delegate;

import com.sun.mfwk.agent.appserv.delegate.BaseHandler;
import com.sun.mfwk.agent.appserv.delegate.HandlerException;
import com.sun.mfwk.agent.appserv.util.Utils;
import java.io.IOException;
import java.util.logging.Level;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class InstanceCountHandler
extends BaseHandler {
    public Object handleAttribute(ObjectName peer, String attribute, MBeanServerConnection mbs) throws HandlerException, AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException, IOException {
        int runningCount = 0;
        int stoppedCount = 0;
        String type = (String)this._handlerProperties.get("type");
        try {
            String clusterName = peer.getKeyProperty("name");
            ObjectName[] instances = (ObjectName[])mbs.invoke(new ObjectName("com.sun.appserv:type=cluster,name=" + clusterName + ",category=config"), "listServerInstances", null, null);
            for (int i = 0; i < instances.length; ++i) {
                Object[] instanceName = new String[]{instances[i].getKeyProperty("name")};
                Integer status = (Integer)mbs.invoke(new ObjectName("com.sun.appserv:name=domain-status"), "getstate", instanceName, new String[]{"java.lang.String"});
                if (status == 0) {
                    ++runningCount;
                    continue;
                }
                if (status != 3) continue;
                ++stoppedCount;
            }
            Utils.log(Level.SEVERE, "runningCount = " + runningCount + " stoppedCount = " + stoppedCount);
        }
        catch (Exception ex) {
            throw new HandlerException(ex);
        }
        if ("RunningInstanceCount".equals(attribute)) {
            return new Integer(runningCount);
        }
        if ("StoppedInstanceCount".equals(attribute)) {
            return new Integer(stoppedCount);
        }
        throw new HandlerException("Invalid attribute name " + peer + " for this handler");
    }
}

