/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.modeler;

import com.sun.mfwk.CMM_MBean;
import com.sun.mfwk.MfDelegate;
import com.sun.mfwk.MfDelegateFactory;
import com.sun.mfwk.MfObjectFactory;
import com.sun.mfwk.agent.appserv.connection.ConnectionRegistry;
import com.sun.mfwk.agent.appserv.delegate.AttributeHandler;
import com.sun.mfwk.agent.appserv.delegate.DefaultDelegate;
import com.sun.mfwk.agent.appserv.logging.LogDomains;
import com.sun.mfwk.agent.appserv.mapping.MappingQueryService;
import com.sun.mfwk.agent.appserv.modeler.ConfigReader;
import com.sun.mfwk.agent.appserv.modeler.DelegateFactory;
import com.sun.mfwk.agent.appserv.modeler.ModelerContext;
import com.sun.mfwk.agent.appserv.modeler.ObjectNameHelper;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class MBeanFactory {
    static Map map;
    private static final String CMM_NAME_TAG = "cmm-name";
    private static final String MAPPING_TAG = "mapping";
    private static final String MAPPING_CLASS_TAG = "mapping-class";
    private static final String TYPE_KEY = "type";
    private static final String CAPABILITIES_TYPE = "CMM_Capabilities";
    private ModelerContext _context = null;
    private static Hashtable _delegateReg;

    MBeanFactory(ModelerContext ctx) {
        this._context = ctx;
    }

    CMM_MBean model(ObjectName asON, Element CMM_MbeanDescriptor, MappingQueryService mapping) throws Exception {
        NodeList defAttr;
        if (asON == null || CMM_MbeanDescriptor == null || mapping == null) {
            throw new IllegalArgumentException();
        }
        CMM_MBean sourceMbean = null;
        MfObjectFactory objectFactory = MfObjectFactory.getObjectFactory((String)this._context.getModuleName());
        if (map == null) {
            map = new Hashtable();
        }
        String mbeanName = CMM_MbeanDescriptor.getAttribute("name").trim();
        map.put(mbeanName, DefaultDelegate.class);
        MfDelegateFactory delegateFactory = objectFactory.getDelegateFactory(map);
        MBeanServerConnection mbs = this.getConnection();
        String objectName = mapping.getCMM_ObjectName(CMM_MbeanDescriptor);
        String tokenizedON = ObjectNameHelper.tokenizeON(asON, objectName, this._context.getTokens());
        DefaultDelegate delegate = null;
        if (!objectFactory.isObjectCreated(tokenizedON)) {
            sourceMbean = objectFactory.createObject(tokenizedON);
            delegate = (DefaultDelegate)delegateFactory.createDelegate(mbs, sourceMbean, asON);
            _delegateReg.put(tokenizedON, delegate);
        } else {
            sourceMbean = objectFactory.getObject(tokenizedON);
            delegate = (DefaultDelegate)_delegateReg.get(tokenizedON);
        }
        if (sourceMbean == null || delegate == null) {
            String msg = "MBean or the delegate must not be null";
            throw new IllegalStateException(msg);
        }
        Map attributes = mapping.getAttributeMappings(CMM_MbeanDescriptor);
        Set asAttributes = attributes.keySet();
        for (String asAttr : asAttributes) {
            String mfAttr = (String)attributes.get(asAttr);
            LogDomains.getLogger().finest("AS Attribute: " + asAttr);
            LogDomains.getLogger().finest("MF Attribute: " + mfAttr);
            LogDomains.getLogger().finest("AS Object Name: " + asON);
            if (asAttr == null || mfAttr == null) continue;
            try {
                if (mapping.isAttributeHandlerDefined(CMM_MbeanDescriptor, asAttr, mfAttr)) {
                    AttributeHandler handler = MBeanFactory.buildAttrHandler(CMM_MbeanDescriptor, mapping, asAttr, mfAttr);
                    delegate.addMappingEntry(mfAttr, asAttr, asON, handler);
                    continue;
                }
                delegate.addMappingEntry(mfAttr, asAttr, asON);
            }
            catch (Exception e) {
                LogDomains.getLogger().log(Level.WARNING, "Error while adding mapping entry", e);
            }
        }
        if (this.isCapabilitiesType(tokenizedON)) {
            delegate.initCapabilitiesMappings();
        }
        if ((defAttr = mapping.getDefaultAttributeMappings(CMM_MbeanDescriptor)) != null) {
            int defSize = defAttr.getLength();
            for (int i = 0; i < defSize; ++i) {
                try {
                    Element e = (Element)defAttr.item(i);
                    String cmmAttr = e.getAttribute(CMM_NAME_TAG).trim();
                    String mappingAttr = e.getAttribute(MAPPING_TAG).trim();
                    String classAttr = e.getAttribute(MAPPING_CLASS_TAG);
                    LogDomains.getLogger().finest("CMM Attribute: " + cmmAttr);
                    LogDomains.getLogger().finest("Mapping: " + mappingAttr);
                    LogDomains.getLogger().finest("Mapping Class: " + classAttr);
                    if (cmmAttr == null || mappingAttr == null) continue;
                    Object type = this.convertType(mappingAttr, classAttr);
                    delegate.addDefaultMappingEntry(cmmAttr, type);
                    continue;
                }
                catch (Exception e) {
                    LogDomains.getLogger().log(Level.WARNING, "Error while adding default mapping entry", e);
                }
            }
        }
        String serverName = this._context.getServerName();
        delegate.setServerName(serverName);
        String domainName = this._context.getDomainName();
        delegate.setDomainName(domainName);
        return sourceMbean;
    }

    private boolean isCapabilitiesType(String tokenizedON) {
        boolean tf = false;
        try {
            ObjectName on = new ObjectName(tokenizedON);
            String type = on.getKeyProperty(TYPE_KEY);
            if (type != null && CAPABILITIES_TYPE.equals(type)) {
                tf = true;
            }
        }
        catch (Exception e) {
            tf = false;
        }
        return tf;
    }

    private Object convertType(String mappingAttr, String classAttr) {
        if (classAttr == null || "".equals(classAttr)) {
            return mappingAttr;
        }
        if ("java.lang.Double".equals(classAttr)) {
            return new Double(mappingAttr);
        }
        if ("java.lang.Float".equals(classAttr)) {
            return new Float(mappingAttr);
        }
        if ("java.lang.Integer".equals(classAttr)) {
            return new Integer(mappingAttr);
        }
        if ("java.lang.Long".equals(classAttr)) {
            return new Long(mappingAttr);
        }
        if ("java.lang.Short".equals(classAttr)) {
            return new Short(mappingAttr);
        }
        if ("java.lang.Boolean".equals(classAttr)) {
            return new Boolean(mappingAttr);
        }
        return mappingAttr;
    }

    CMM_MBean create(Element mbean) throws Exception {
        if (mbean == null) {
            throw new IllegalArgumentException();
        }
        MfObjectFactory objectFactory = MfObjectFactory.getObjectFactory((String)this._context.getModuleName());
        Hashtable<String, Class<DefaultDelegate>> map = new Hashtable<String, Class<DefaultDelegate>>();
        String mbeanName = mbean.getAttribute("name").trim();
        try {
            String delegateClassName = mbean.getAttribute(TYPE_KEY).trim();
            Class c = (Class)Class.forName(delegateClassName).newInstance();
            map.put(mbeanName, c);
        }
        catch (ClassNotFoundException cnfe) {
            LogDomains.getLogger().fine("Error: " + cnfe.getMessage() + ". Using default delegate class.");
            map.put(mbeanName, DefaultDelegate.class);
        }
        MfDelegateFactory delegateFactory = objectFactory.getDelegateFactory(map);
        MBeanServerConnection mbs = this.getConnection();
        CMM_MBean sourceMbean = null;
        String objectName = ConfigReader.getMBeanObjectName(mbean, false);
        String tokenizedON = ObjectNameHelper.tokenize(objectName, this._context.getTokens());
        if (!objectFactory.isObjectCreated(tokenizedON)) {
            sourceMbean = objectFactory.createObject(tokenizedON);
            String proxyObjectName = ConfigReader.getMBeanObjectName(mbean, true);
            String tokenizedPON = ObjectNameHelper.tokenize(proxyObjectName, this._context.getTokens());
            ObjectName pon = ObjectNameHelper.getObjectName(tokenizedPON, mbs);
            MfDelegate delegate = delegateFactory.createDelegate(mbs, sourceMbean, pon);
            DelegateFactory df = new DelegateFactory(mbean, delegate, this._context, mbs);
            Object d = df.create();
            LogDomains.getLogger().fine("Created delegate: " + d);
        }
        return sourceMbean;
    }

    private MBeanServerConnection getConnection() throws IOException {
        ConnectionRegistry reg = ConnectionRegistry.getInstance();
        String serverName = this._context.getServerName();
        String domainName = this._context.getDomainName();
        MBeanServerConnection mbs = reg.getConnection(serverName, domainName);
        return mbs;
    }

    public static AttributeHandler buildAttrHandler(Element CMM_MbeanDescriptor, MappingQueryService mapping, String asAttr, String cmmAttr) throws Exception {
        AttributeHandler handler = null;
        try {
            Map handlerProperties = mapping.getHandlerAttributeMappings(CMM_MbeanDescriptor, asAttr, cmmAttr);
            String handlerName = mapping.getAttributeHandlerClass(CMM_MbeanDescriptor, asAttr, cmmAttr);
            Class<?> c = Class.forName(handlerName);
            handler = (AttributeHandler)c.newInstance();
            handler.setCMM_MBeanDescriptor(CMM_MbeanDescriptor);
            handler.setMappingQueryService(mapping);
            handler.setHandlerProperties(handlerProperties);
        }
        catch (Exception e) {
            LogDomains.getLogger().log(Level.WARNING, "Error while creating attribute handler", e);
            throw e;
        }
        return handler;
    }

    static {
        _delegateReg = new Hashtable();
    }
}

