/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.modeler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ObjectNameHelper {
    private static final String WILD_CARD = "*";
    private static final String DEF_DELIM_TOKEN = "[$]";
    private static final String DEF_START_TOKEN = "{";
    private static final String DEF_END_TOKEN = "}";

    public static ObjectName getObjectName(String on, MBeanServerConnection mbs) throws MalformedObjectNameException, IOException {
        if (mbs == null) {
            return new ObjectName(on);
        }
        ObjectName objectName = null;
        if (on != null) {
            int idx = on.indexOf(WILD_CARD);
            if (idx != -1) {
                ObjectName pattern = new ObjectName(on);
                Set<ObjectName> mbeans = mbs.queryNames(pattern, null);
                if (mbeans.size() > 1) {
                    String msg = "Object name is not unique: " + on;
                    throw new MalformedObjectNameException(msg);
                }
                Iterator<ObjectName> iter = mbeans.iterator();
                objectName = iter.next();
            } else {
                objectName = new ObjectName(on);
            }
        }
        if (objectName == null) {
            String msg = "Object name is malformed: " + on;
            throw new MalformedObjectNameException(msg);
        }
        return objectName;
    }

    public static String tokenize(String on, Map env) throws NoSuchFieldException {
        if (on == null) {
            return on;
        }
        String[] result = on.split(DEF_DELIM_TOKEN);
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < result.length; ++i) {
            if (result[i].startsWith(DEF_START_TOKEN)) {
                int idx = result[i].indexOf(DEF_END_TOKEN);
                String key = result[i].substring(1, idx);
                if (!env.containsKey(key)) {
                    String msg = "Key not found in environment: " + key;
                    throw new NoSuchFieldException(msg);
                }
                String value = (String)env.get(key);
                s.append(value);
                s.append(result[i].substring(idx + 1));
                continue;
            }
            s.append(result[i]);
        }
        return s.toString();
    }

    public static List getTokensKeys(String objectNameTemplate) {
        ArrayList<String> list = new ArrayList<String>();
        if (objectNameTemplate == null) {
            return list;
        }
        String[] result = objectNameTemplate.split(DEF_DELIM_TOKEN);
        String key = null;
        int idx = -1;
        for (int i = 0; i < result.length; ++i) {
            if (!result[i].startsWith(DEF_START_TOKEN)) continue;
            idx = result[i].indexOf(DEF_END_TOKEN);
            key = result[i].substring(1, idx);
            list.add(key);
        }
        return list;
    }

    public static String tokenizeON(ObjectName asObjectName, String objectName, Map tokens) throws IOException, NoSuchFieldException {
        if (tokens == null) {
            tokens = new Hashtable<String, String>();
        }
        List keys = ObjectNameHelper.getTokensKeys(objectName);
        String key = null;
        String value = null;
        for (int i = 0; i < keys.size(); ++i) {
            key = (String)keys.get(i);
            value = asObjectName.getKeyProperty(key);
            if (value == null && !tokens.containsKey(key)) {
                String msg = "Key not found: " + key;
                throw new NoSuchFieldException(msg);
            }
            if (value == null) continue;
            tokens.put(key, value);
        }
        return ObjectNameHelper.tokenize(objectName, tokens);
    }

    public static Map getKeysAndProperties(String objectName) {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        int start = objectName.indexOf(":");
        if (start >= 0 && start < objectName.length()) {
            StringTokenizer tokenizer = new StringTokenizer(objectName.substring(start + 1, objectName.length()), "=,");
            while (tokenizer.hasMoreTokens()) {
                String key = (String)tokenizer.nextElement();
                if (!tokenizer.hasMoreElements()) continue;
                map.put(key, tokenizer.nextElement());
            }
        }
        return map;
    }

    public static boolean keysMatch(Map map1, String objectName) {
        Map map2 = ObjectNameHelper.getKeysAndProperties(objectName);
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Object key : map1.keySet()) {
            if (map2.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    public static boolean keysMatch(String objectName1, String objectName2) {
        return ObjectNameHelper.keysMatch(ObjectNameHelper.getKeysAndProperties(objectName1), objectName2);
    }
}

