/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common.arguments;

import com.sun.enterprise.tools.upgrade.common.PasswordVerifier;
import com.sun.enterprise.tools.upgrade.common.arguments.CertificateArgumentHandler;
import com.sun.enterprise.tools.upgrade.common.arguments.ParsedArgument;

public class ARG_capwdfile
extends CertificateArgumentHandler {
    private String jkscaPwdFile;

    public ARG_capwdfile(ParsedArgument pa) {
        super(pa);
        if (this.parameters.isEmpty()) {
            this.helpUsage(this.sm.getString("enterprise.tools.upgrade.cli.argument_missing", (Object)"--capwdfile/-p"));
            System.exit(1);
        }
        this.jkscaPwdFile = (String)this.parameters.firstElement();
        this.processCertificatePasswords(this.jkscaPwdFile);
    }

    protected void setCertificatePassword(String password) {
        if (password == null) {
            this._logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.password_error", (Object)this.jkscaPwdFile));
            System.exit(1);
        }
        this.commonInfo.setJksCAKeystorePassword(password);
        String trustJksPath = "";
        if (this.commonInfo.isUpgradeNSStoJKS()) {
            if (!this.interactiveMap.containsKey("target")) {
                return;
            }
            trustJksPath = this.commonInfo.getTargetTrustedJKSKeyStorePath();
        } else {
            if (!this.interactiveMap.containsKey("source")) {
                return;
            }
            trustJksPath = this.commonInfo.getSourceTrustedJKSKeyStorePath();
        }
        boolean validpwd = PasswordVerifier.verifyKeystorePassword(trustJksPath, password);
        if (!validpwd) {
            this.commonInfo.recover();
            this._logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.Invalid_jks_CA_password"));
            System.exit(1);
        }
        this.interactiveMap.put("capwd-" + this.commonInfo.getCurrentDomain(), this.jkscaPwdFile);
    }
}

