/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.BreakIterator;
import java.util.Enumeration;
import java.util.Vector;

public class FlowLabel
extends Canvas {
    private String labelText = "";
    private Vector textVector = new Vector();
    private transient Object textVectorLock = new Object();
    private static Font labelFont = null;
    private static String[] addAttr = new String[]{"<bold>", "<b>", "<italics>", "<i>", "<tt>", "<br>", "<p>"};
    private static int attrBold = 3;
    private static int attrItalics = 12;
    private static int attrTt = 16;
    private static int attrBreak;
    private static int attrParagraph;
    private static int attrFlowControlOnly;
    private static String[] removeAttr;
    private transient Dimension currentSize = new Dimension(0, 0);
    private transient Object currentSizeLock = new Object();
    private transient Vector paintVector = new Vector();
    private transient Object paintVectorLock = new Object();
    private int horizontalMargin = 10;
    private int verticalMargin = 5;
    private transient boolean resizePerformed = false;
    static final long serialVersionUID = -4025711393515048887L;

    public FlowLabel() {
    }

    public FlowLabel(String s) {
        this.labelText = s;
        this.textVector = this.createTextVector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector createPaintVector(Dimension dimension) {
        Vector vector = new Vector();
        try {
            Dimension dimension1 = new Dimension(dimension);
            dimension1.width -= this.horizontalMargin * 2;
            dimension1.height -= this.verticalMargin * 2;
            int i = 0;
            boolean flag = false;
            Vector vector1 = new Vector();
            Enumeration enumeration = null;
            boolean flag1 = false;
            int i1 = 0;
            boolean flag2 = false;
            int k1 = 0;
            Font font = this.getFont();
            font = new Font(font.getName(), 0, font.getSize());
            FontMetrics fontmetrics = this.getToolkit().getFontMetrics(font);
            Vector vector2 = this.textVector;
            synchronized (vector2) {
                enumeration = this.textVector.elements();
            }
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                if (obj instanceof Integer) {
                    int l1 = (Integer)obj;
                    if ((l1 & attrBreak) != 0) {
                        vector.addElement(vector1);
                        vector1 = new Vector();
                        int j = i1;
                        k1 = 0;
                        i = 0;
                    } else if ((l1 & attrParagraph) != 0) {
                        vector.addElement(vector1);
                        vector1 = new Vector();
                        vector.addElement(vector1);
                        vector1 = new Vector();
                        int k = i1;
                        k1 = 0;
                        i = 0;
                    }
                    font = this.getNewFont(font, (Integer)obj);
                    fontmetrics = this.getToolkit().getFontMetrics(font);
                    vector1.addElement(obj);
                    continue;
                }
                String s1 = (String)obj;
                int l = 0;
                i1 = 0;
                while (i1 < s1.length() - 1) {
                    if (k1 == 0) {
                        l = this.skipWhitespace(s1, l);
                        i1 = this.getNextWordIndex(s1, i1);
                        ++k1;
                    }
                    int j1 = this.getNextWordIndex(s1, i1);
                    while (j1 <= s1.length() && fontmetrics.stringWidth(s1.substring(l, j1)) + i < dimension1.width) {
                        i1 = j1;
                        j1 = this.getNextWordIndex(s1, i1);
                        ++k1;
                    }
                    if (i1 >= s1.length() - 1) {
                        i = fontmetrics.stringWidth(s1.substring(l, i1)) + i;
                        vector1.addElement(s1.substring(l, i1));
                        continue;
                    }
                    vector1.addElement(s1.substring(l, i1));
                    vector.addElement(vector1);
                    vector1 = new Vector();
                    l = i1;
                    k1 = 0;
                    i = 0;
                }
            }
            if (vector1.size() > 0) {
                vector.addElement(vector1);
            }
        }
        catch (Exception _ex) {
            return this.createPaintVector(dimension);
        }
        return vector;
    }

    private Vector createTextVector() {
        Vector<Object> vector = new Vector<Object>();
        int i = 0;
        int j = 0;
        StringBuffer stringbuffer = new StringBuffer();
        boolean flag = false;
        while (i < this.labelText.length()) {
            boolean flag1 = false;
            while (i < this.labelText.length() && this.labelText.charAt(i) == '<') {
                for (int k = 0; k < addAttr.length; ++k) {
                    if (this.labelText.length() >= i + addAttr[k].length() && this.labelText.substring(i, i + addAttr[k].length()).equalsIgnoreCase(addAttr[k])) {
                        j |= 1 << k;
                        i += addAttr[k].length();
                        flag1 = true;
                    }
                    if (this.labelText.length() < i + removeAttr[k].length() || !this.labelText.substring(i, i + removeAttr[k].length()).equalsIgnoreCase(removeAttr[k])) continue;
                    j &= 255 - (1 << k);
                    i += removeAttr[k].length();
                    flag1 = (1 << k & attrFlowControlOnly) == 0;
                }
                if (flag1) continue;
            }
            if (flag1) {
                int l = stringbuffer.length();
                if (l > 0) {
                    vector.addElement(stringbuffer.toString());
                    stringbuffer = new StringBuffer();
                }
                vector.addElement(new Integer(j));
                j &= ~attrFlowControlOnly;
                continue;
            }
            if (this.labelText.charAt(i) == '\n') {
                if (stringbuffer.length() > 0) {
                    vector.addElement(stringbuffer.toString());
                    stringbuffer = new StringBuffer();
                }
                vector.addElement(new Integer(attrBreak));
                ++i;
            }
            if (i >= this.labelText.length()) continue;
            stringbuffer.append(this.labelText.charAt(i));
            ++i;
        }
        if (stringbuffer.length() > 0) {
            vector.addElement(stringbuffer.toString());
        }
        return vector;
    }

    public void forceResize() {
        if (!this.resizePerformed) {
            Container container;
            this.resizePerformed = true;
            this.invalidate();
            for (container = this.getParent(); container != null && container.getParent() != null; container = container.getParent()) {
            }
            container.validate();
        }
    }

    public String getContentString() {
        String s = "";
        Vector vector = this.createTextVector();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object obj = enumeration.nextElement();
            if (!(obj instanceof String)) continue;
            s = s + obj;
        }
        return s;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private Font getNewFont(Font font, int i) {
        if (font != null) {
            if (labelFont == null && (i & attrTt) != 0) {
                labelFont = font;
                if ((font = new Font("Monospaced", 0, font.getSize())) == null) {
                    font = labelFont;
                    labelFont = null;
                }
            } else if (labelFont != null && (i & attrTt) == 0) {
                font = labelFont;
                labelFont = null;
            }
            font = new Font(font.getName(), ((i & attrBold) == 0 ? 0 : 1) | ((i & attrItalics) == 0 ? 0 : 2), font.getSize());
        }
        return font;
    }

    private int getNextWordIndex(String s, int i) {
        int j;
        for (j = i + 1; j < s.length() && Character.isWhitespace(s.charAt(j)); ++j) {
        }
        if (j < s.length()) {
            BreakIterator breakiterator = BreakIterator.getLineInstance();
            breakiterator.setText(s.substring(j, s.length()));
            int k = breakiterator.first();
            k = breakiterator.next();
            if (k != -1) {
                if (s.charAt(k + j - 1) == '.') {
                    BreakIterator breakiterator1 = BreakIterator.getSentenceInstance();
                    breakiterator1.setText(s);
                    int l = breakiterator1.first();
                    while (l != -1 && l < k + j) {
                        l = breakiterator1.next();
                    }
                    if (l != k + j) {
                        return this.getNextWordIndex(s, k + j);
                    }
                }
                return k + j;
            }
        }
        return j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        Container container = this.getParent();
        Dimension dimension = container.getSize();
        Dimension dimension1 = new Dimension(1, 1);
        if (dimension.width == 0) {
            dimension = new Dimension(400, 200);
        }
        Insets insets = container.getInsets();
        try {
            Font font = this.getNewFont(this.getFont(), 0);
            FontMetrics fontmetrics = this.getToolkit().getFontMetrics(font);
            dimension1 = new Dimension(dimension.width - insets.right - insets.left, dimension.height - insets.top - insets.bottom);
            Object object = this.currentSizeLock;
            synchronized (object) {
                Object object2 = this.paintVectorLock;
                synchronized (object2) {
                    Vector vector = this.createPaintVector(dimension1);
                    dimension1.height = this.verticalMargin * 2 + fontmetrics.getHeight() * vector.size();
                }
            }
        }
        catch (Error _ex) {
            return this.getPreferredSize();
        }
        return dimension1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        Dimension dimension = this.getSize();
        Object object = this.currentSizeLock;
        synchronized (object) {
            if (this.currentSize.width != dimension.width) {
                this.sizeChanged(dimension);
            }
        }
        Dimension dimension1 = this.getPreferredSize();
        if (dimension.height < dimension1.height && !this.resizePerformed) {
            this.forceResize();
            return;
        }
        g.setClip(0, 0, dimension.width, dimension.height);
        g.setColor(Color.blue);
        Font font = this.getFont();
        font = new Font(font.getName(), 0, font.getSize());
        FontMetrics fontmetrics = this.getToolkit().getFontMetrics(font);
        g.setFont(font);
        int i = this.horizontalMargin;
        int j = fontmetrics.getMaxAscent() + this.verticalMargin;
        Object object2 = this.paintVectorLock;
        synchronized (object2) {
            for (int k = 0; k < this.paintVector.size(); ++k) {
                Vector vector = (Vector)this.paintVector.elementAt(k);
                for (int l = 0; l < vector.size(); ++l) {
                    Object obj2 = vector.elementAt(l);
                    if (obj2 instanceof Integer) {
                        font = this.getNewFont(font, (Integer)obj2);
                        fontmetrics = this.getToolkit().getFontMetrics(font);
                        g.setFont(font);
                    }
                    if (!(obj2 instanceof String)) continue;
                    try {
                        g.drawString((String)obj2, i, j);
                        i += fontmetrics.stringWidth((String)obj2);
                        continue;
                    }
                    catch (Exception _ex) {
                        this.repaint();
                    }
                }
                i = this.horizontalMargin;
                j += fontmetrics.getHeight();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectinputstream) throws IOException {
        try {
            objectinputstream.defaultReadObject();
        }
        catch (ClassNotFoundException classnotfoundexception) {
            classnotfoundexception.printStackTrace();
        }
        finally {
            this.textVectorLock = new Object();
            this.paintVectorLock = new Object();
            this.paintVector = new Vector();
            this.currentSize = new Dimension(0, 0);
            this.currentSizeLock = new Object();
        }
    }

    public void setHgap(int i) {
        this.horizontalMargin = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String s) {
        this.labelText = s;
        Object object = this.textVectorLock;
        synchronized (object) {
            this.textVector = this.createTextVector();
        }
        Dimension dimension = this.getSize();
        if (dimension.width > 0 || dimension.height > 0) {
            Object object2 = this.paintVectorLock;
            synchronized (object2) {
                this.paintVector = this.createPaintVector(dimension);
            }
        }
        if (this.isShowing()) {
            this.invalidate();
            this.repaint();
        }
    }

    public void setVgap(int i) {
        this.verticalMargin = i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sizeChanged(Dimension dimension) {
        Object object = this.currentSizeLock;
        synchronized (object) {
            Dimension dimension1 = this.currentSize;
            if (!dimension.equals(dimension1)) {
                try {
                    Graphics g = this.getGraphics();
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, dimension1.width + 1, dimension1.height + 1);
                }
                catch (Exception _ex) {
                    // empty catch block
                }
            }
            if (dimension.width != dimension1.width) {
                Object object2 = this.paintVectorLock;
                synchronized (object2) {
                    this.paintVector = this.createPaintVector(dimension);
                }
            }
            this.currentSize = dimension;
            this.resizePerformed = false;
        }
    }

    private int skipWhitespace(String s, int i) {
        int j;
        for (j = i; j < s.length() && Character.isWhitespace(s.charAt(j)); ++j) {
        }
        return j;
    }

    static {
        removeAttr = new String[]{"</bold>", "</b>", "</italics>", "</i>", "</tt>", "</br>", "</p>"};
        attrBreak = 32;
        attrParagraph = 64;
        attrFlowControlOnly = attrBreak | attrParagraph;
    }
}

