/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.realm;

import com.sun.enterprise.tools.upgrade.common.BaseModule;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.common.UpdateProgressManager;
import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RealmUpgrade
implements BaseModule {
    private String AS7_FILE_REALM = "com.iplanet.ias.security.auth.realm.file.FileRealm";
    private String AS7_LDAP_REALM = "com.iplanet.ias.security.auth.realm.ldap.LDAPRealm";
    private String AS7_CERTIFICATE_REALM = "com.iplanet.ias.security.auth.realm.certificate.CertificateRealm";
    private String AS7_SOLARIS_REALM = "com.iplanet.ias.security.auth.realm.solaris.SolarisRealm";
    private String AS8_FILE_REALM = "com.sun.enterprise.security.auth.realm.file.FileRealm";
    private String AS8_LDAP_REALM = "com.sun.enterprise.security.auth.realm.ldap.LDAPRealm";
    private String AS8_CERTIFICATE_REALM = "com.sun.enterprise.security.auth.realm.certificate.CertificateRealm";
    private String AS8_SOLARIS_REALM = "com.sun.enterprise.security.auth.realm.solaris.SolarisRealm";
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.realm");
    private Logger logger = CommonInfoModel.getDefaultLogger();
    private CommonInfoModel commonInfo = null;
    private Vector recoveryList = new Vector();

    public boolean upgrade(CommonInfoModel commonInfoModel) {
        this.logger.log(Level.INFO, this.stringManager.getString("upgrade.realm.startMessage"));
        this.commonInfo = commonInfoModel;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        if (this.commonInfo.getSourceDomainRootFlag()) {
            factory.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        }
        String realmname = "";
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (!this.commonInfo.getSourceVersion().equals("7x")) {
                builder.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            }
            Document sourceDoc = builder.parse(new File(this.commonInfo.getSourceConfigXMLFile()));
            NodeList nl = sourceDoc.getElementsByTagName("auth-realm");
            for (int i = 0; i < nl.getLength(); ++i) {
                String classpath;
                NamedNodeMap java_attrs;
                NodeList nlist;
                String classname;
                Node node = nl.item(i);
                NamedNodeMap attributes = node.getAttributes();
                if (this.commonInfo.getSourceVersion().equals("7x")) {
                    classname = attributes.getNamedItem("classname").getNodeValue();
                    if (!(classname.equals(this.AS7_FILE_REALM) || classname.equals(this.AS7_LDAP_REALM) || classname.equals(this.AS7_CERTIFICATE_REALM) || classname.equals(this.AS7_SOLARIS_REALM))) {
                        nlist = sourceDoc.getElementsByTagName("java-config");
                        Node njava = nlist.item(0);
                        java_attrs = njava.getAttributes();
                        classpath = java_attrs.getNamedItem("server-classpath").getNodeValue();
                        this.migrateClass(classname, classpath);
                    }
                } else if (!(!this.commonInfo.getSourceVersion().equals("80") && !this.commonInfo.getSourceVersion().equals("81") || (classname = attributes.getNamedItem("classname").getNodeValue()).equals(this.AS8_FILE_REALM) || classname.equals(this.AS8_LDAP_REALM) || classname.equals(this.AS8_CERTIFICATE_REALM) || classname.equals(this.AS8_SOLARIS_REALM))) {
                    nlist = sourceDoc.getElementsByTagName("java-config");
                    Node njava = nlist.item(0);
                    java_attrs = njava.getAttributes();
                    classpath = java_attrs.getNamedItem("server-classpath").getNodeValue();
                    this.migrateClass(classname, classpath);
                }
                realmname = attributes.getNamedItem("name").getNodeValue();
                classname = attributes.getNamedItem("classname").getNodeValue();
                if (!classname.equals(this.AS8_FILE_REALM)) continue;
                NodeList props = node.getChildNodes();
                for (int j = 0; j < props.getLength(); ++j) {
                    NamedNodeMap attrs;
                    Node propnode = props.item(j);
                    if (!propnode.getNodeName().equals("property") || (attrs = propnode.getAttributes()) == null || !attrs.getNamedItem("name").getNodeValue().equals("file")) continue;
                    Node valueNode = attrs.getNamedItem("value");
                    System.setProperty("com.sun.aas.instanceRoot", this.commonInfo.getSourceInstancePath());
                    String rawSourceRealmPath = valueNode.getNodeValue();
                    String sourceRealmPath = RelativePathResolver.resolvePath((String)rawSourceRealmPath);
                    File sourceRealmFile = new File(sourceRealmPath);
                    String targetRealmPath = this.commonInfo.getDestinationDomainPath() + File.separator + "config" + File.separator + sourceRealmFile.getName();
                    File targetRealmFile = new File(targetRealmPath);
                    this.backup(targetRealmPath);
                    this.transferKeys(sourceRealmFile, targetRealmFile, builder);
                }
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.realm.migrationFailureMessage", (Object)ex.getMessage()), new Object[]{realmname, ex});
            ex.printStackTrace();
            UpdateProgressManager.getProgressManager().setContinueUpgrade(false);
            return false;
        }
        return true;
    }

    private void backup(String filePath) throws IOException {
        String backupFilePath = filePath + ".bak";
        UpgradeUtils.copyFile(filePath, backupFilePath);
        this.recoveryList.add(filePath);
    }

    public void recovery(CommonInfoModel commonInfo) {
        Enumeration e = this.recoveryList.elements();
        while (e.hasMoreElements()) {
            String recoverPath = (String)e.nextElement();
            String backupPath = recoverPath + ".bak";
            try {
                UpgradeUtils.copyFile(backupPath, recoverPath);
                new File(backupPath).delete();
            }
            catch (IOException ioe) {
                this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.realm.recoveryFailureMessage", (Object)ioe.getMessage()), new Object[]{recoverPath, ioe});
            }
        }
    }

    private void migrateClass(String classname, String classpath) {
        boolean found = false;
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator, false);
        String[] fileList = new String[st.countTokens()];
        for (int i = 0; i < fileList.length; ++i) {
            fileList[i] = st.nextToken();
        }
        String targetDir = this.commonInfo.getDestinationDomainPath() + File.separator + "lib" + File.separator + "ext";
        String file = classname;
        block3: for (int i = 0; i < fileList.length; ++i) {
            String fileName = fileList[i];
            if (!fileName.endsWith(".jar")) continue;
            try {
                JarFile jarFile = new JarFile(fileName);
                Enumeration<JarEntry> ee = jarFile.entries();
                while (ee.hasMoreElements()) {
                    ZipEntry entry = ee.nextElement();
                    String entryString = entry.toString();
                    String className = entryString.replaceAll("/", ".");
                    if (!className.equals(file)) continue;
                    String target = targetDir + File.pathSeparatorChar + jarFile.getName();
                    UpgradeUtils.copyFile(fileName, target);
                    this.updateDomainClassPath(jarFile.getName());
                    found = true;
                    continue block3;
                }
                continue;
            }
            catch (IOException ioe) {
                RealmUpgrade realmUpgrade = this;
                realmUpgrade.commonInfo.getDefaultLogger().info(this.stringManager.getString("upgrade.realm.customRealmClassMessage") + fileName + this.stringManager.getString("upgrade.realm.IOExceptionMessage"));
            }
        }
        if (!found) {
            RealmUpgrade realmUpgrade = this;
            realmUpgrade.commonInfo.getDefaultLogger().info(this.stringManager.getString("upgrade.realm.customRealmClassMessage") + classname + this.stringManager.getString("upgrade.realm.manuallyRelocatedMessage"));
        }
    }

    private void updateDomainClassPath(String fileName) {
        this.logger.log(Level.INFO, this.stringManager.getString("upgrade.realm.updateDomainClassPathMessage"));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builderDomainXml = factory.newDocumentBuilder();
            builderDomainXml.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document resultDoc = builderDomainXml.parse(new File(this.commonInfo.getTargetConfigXMLFile()));
            this.updateClassPathString(resultDoc, fileName);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            if (resultDoc.getDoctype() != null) {
                String systemValue = resultDoc.getDoctype().getSystemId();
                transformer.setOutputProperty("doctype-system", systemValue);
                String pubValue = resultDoc.getDoctype().getPublicId();
                transformer.setOutputProperty("doctype-public", pubValue);
            }
            DOMSource source = new DOMSource(resultDoc);
            StreamResult result = new StreamResult(new FileOutputStream(this.commonInfo.getTargetConfigXMLFile()));
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, this.stringManager.getString("upgrade.realm.updateDomainFailureMessage"), ex);
        }
    }

    private void updateClassPathString(Document domainXML, String fileName) {
        Element docEle = domainXML.getDocumentElement();
        NodeList configList = docEle.getElementsByTagName("java-config");
        Element javaConfElement = (Element)configList.item(0);
        javaConfElement.setAttribute("server-classpath", javaConfElement.getAttribute("server-classpath") + "${path.separator}${com.sun.aas.installRoot}" + File.separator + "lib" + File.separator + "ext" + File.separator + fileName);
    }

    public String getName() {
        return this.stringManager.getString("upgrade.realm.moduleName");
    }

    private void transferKeys(File sourceRealmFile, File targetRealmFile, DocumentBuilder builder) throws FileNotFoundException, IOException, SAXException {
        Document sourceDoc = builder.parse(new File(this.commonInfo.getTargetConfigXMLFile()));
        BufferedReader reader = new BufferedReader(new FileReader(sourceRealmFile));
        BufferedWriter writer = new BufferedWriter(new FileWriter(targetRealmFile));
        while (reader.ready()) {
            String entry = reader.readLine();
            if (entry.startsWith("admin") && !this.commonInfo.getSourceVersion().equals("81")) {
                NodeList nl = sourceDoc.getElementsByTagName("auth-realm");
                for (int i = 0; i < nl.getLength(); ++i) {
                    Node node = nl.item(i);
                    NamedNodeMap attributes = node.getAttributes();
                    String name = attributes.getNamedItem("name").getNodeValue();
                    if (!name.equals("admin-realm")) continue;
                    NodeList props = node.getChildNodes();
                    for (int j = 0; j < props.getLength(); ++j) {
                        NamedNodeMap attrs;
                        Node propnode = props.item(j);
                        if (!propnode.getNodeName().equals("property") || (attrs = propnode.getAttributes()) == null || !attrs.getNamedItem("name").getNodeValue().equals("file")) continue;
                        Node valueNode = attrs.getNamedItem("value");
                        System.setProperty("com.sun.aas.instanceRoot", this.commonInfo.getDestinationDomainPath());
                        String rawSourceRealmPath = valueNode.getNodeValue();
                        String adminRealmPath = RelativePathResolver.resolvePath((String)rawSourceRealmPath);
                        File adminRealmFile = new File(adminRealmPath);
                        this.backup(adminRealmPath);
                        BufferedWriter adminRealmWriter = new BufferedWriter(new FileWriter(adminRealmFile));
                        adminRealmWriter.write(entry);
                        adminRealmWriter.newLine();
                        adminRealmWriter.write("# Domain User and Password - Do Not Delete Entry Above");
                        adminRealmWriter.close();
                    }
                }
                continue;
            }
            if (entry.startsWith("#")) continue;
            writer.write(entry);
            writer.newLine();
        }
        writer.close();
        reader.close();
    }
}

