/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.transform.elements;

import com.sun.enterprise.tools.upgrade.cluster.ClusterInfo;
import com.sun.enterprise.tools.upgrade.cluster.ClusteredInstance;
import com.sun.enterprise.tools.upgrade.cluster.ClustersInfoManager;
import com.sun.enterprise.tools.upgrade.transform.ElementToObjectMapper;
import com.sun.enterprise.tools.upgrade.transform.elements.BaseElement;
import com.sun.enterprise.tools.upgrade.transform.elements.GenericElement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GenericResource
extends GenericElement {
    private boolean appendingResourceRefToCluster = false;
    private List insertStructureForResourceRefInCluster = null;
    private boolean appendJdbcResource = false;
    private boolean appendJdbcConnPool = false;

    public void transform(Element element, Element parentSource, Element parentResult) {
        String resourceTagName = element.getTagName();
        this.logger.log(Level.FINE, this.stringManager.getString("upgrade.transform.transformingMSG", (Object)this.getClass().getName(), (Object)resourceTagName));
        boolean derbyPoolExists = false;
        if (commonInfoModel.checkUpgradefrom8xeeto9x()) {
            NodeList jdbcResources = parentResult.getElementsByTagName("jdbc-resource");
            for (int i = 0; i < jdbcResources.getLength(); ++i) {
                if (((Element)jdbcResources.item(i)).getAttribute("jndi-name").equals("jdbc/__default")) {
                    derbyPoolExists = true;
                    break;
                }
                derbyPoolExists = false;
            }
            this.logger.log(Level.FINE, this.getClass().getName() + ":: derbyPoolExists ", derbyPoolExists);
            if (!derbyPoolExists) {
                this.addJdbcResource(element, parentSource, parentResult);
            }
            if (resourceTagName.equals("jdbc-connection-pool")) {
                this.transferJdbcConnPool(element, parentSource, parentResult);
            }
            NodeList jdbcConnPools = parentResult.getElementsByTagName("jdbc-connection-pool");
            for (int j = 0; j < jdbcConnPools.getLength(); ++j) {
                if (((Element)jdbcConnPools.item(j)).getAttribute("name").equals("DerbyPool")) {
                    this.appendJdbcConnPool = true;
                    break;
                }
                this.appendJdbcConnPool = false;
            }
            this.logger.log(Level.FINE, this.getClass().getName() + ":: appendJdbcConnPool ", this.appendJdbcConnPool);
            if (!this.appendJdbcConnPool) {
                this.addJdbcConnPool(element, parentSource, parentResult);
            }
        }
        if (resourceTagName.equals("jms-resource")) {
            this.skipGenericElementTransform(element, parentSource, parentResult);
            return;
        }
        if (resourceTagName.equals("jdbc-connection-pool") && (element.getAttribute("name").equals("__TimerPool") || element.getAttribute("name").equals("PointBasePool"))) {
            return;
        }
        if (resourceTagName.equals("jdbc-resource") && element.getAttribute("pool-name").equals("PointBasePool")) {
            return;
        }
        super.transform(element, parentSource, parentResult);
    }

    protected void updateResourceRef(Element element, Element parentResult) {
        if (!"7x".equals(commonInfoModel.getSourceVersion())) {
            return;
        }
        Attr jndiAttr = element.getAttributeNode("jndi-name");
        if (jndiAttr != null) {
            NodeList servers = ((Element)parentResult.getParentNode()).getElementsByTagName("servers");
            NodeList serverList = ((Element)servers.item(0)).getElementsByTagName("server");
            if (commonInfoModel.isPlatformEdition(commonInfoModel.getSourceEdition())) {
                Element serverElement = (Element)serverList.item(0);
                this.addOrUpdateResourceRef(serverElement, element, parentResult);
            } else if (commonInfoModel.getCurrentCluster() == null) {
                String serverName = commonInfoModel.getCurrentSourceInstance();
                if (serverName == null || "".equals(serverName.trim())) {
                    serverName = "server";
                }
                if (serverName != null) {
                    for (int lh = 0; lh < serverList.getLength(); ++lh) {
                        if (!serverName.equals(((Element)serverList.item(lh)).getAttribute("name"))) continue;
                        this.addOrUpdateResourceRef((Element)serverList.item(lh), element, parentResult);
                        break;
                    }
                }
            } else {
                String clusterName = commonInfoModel.getCurrentCluster();
                this.updateResourceRefsForCluster(clusterName, serverList, element, parentResult);
            }
        }
    }

    private void updateResourceRefsForCluster(String clusterName, NodeList serverRefList, Element element, Element parentResult) {
        for (ClusterInfo cInfo : ClustersInfoManager.getClusterInfoManager().getClusterInfoList()) {
            if (!cInfo.getClusterName().equals(clusterName)) continue;
            block1: for (ClusteredInstance clInstance : cInfo.getClusteredInstanceList()) {
                String clInstanceName = clInstance.getInstanceName();
                for (int lh = 0; lh < serverRefList.getLength(); ++lh) {
                    if (!clInstanceName.equals(((Element)serverRefList.item(lh)).getAttribute("name"))) continue;
                    this.addOrUpdateResourceRef((Element)serverRefList.item(lh), element, parentResult);
                    continue block1;
                }
            }
        }
        NodeList clusters = ((Element)parentResult.getParentNode()).getElementsByTagName("clusters");
        if (clusters != null && clusters.getLength() > 0) {
            NodeList clustersList = ((Element)clusters.item(0)).getElementsByTagName("cluster");
            for (int lh = 0; lh < clustersList.getLength(); ++lh) {
                if (!clusterName.equals(((Element)clustersList.item(lh)).getAttribute("name"))) continue;
                this.appendingResourceRefToCluster = true;
                this.addOrUpdateResourceRef((Element)clustersList.item(lh), element, parentResult);
                this.appendingResourceRefToCluster = false;
                break;
            }
        }
    }

    private void addOrUpdateResourceRef(Element parentForRef, Element element, Element parentResult) {
        NodeList resourceRefs = parentForRef.getElementsByTagName("resource-ref");
        Element resourceRef = null;
        for (int lh = 0; lh < resourceRefs.getLength(); ++lh) {
            if (!element.getAttribute("jndi-name").equals(((Element)resourceRefs.item(lh)).getAttribute("ref"))) continue;
            resourceRef = (Element)resourceRefs.item(lh);
            Attr enAttr = element.getAttributeNode("enabled");
            if (enAttr == null) break;
            resourceRef.setAttribute("enabled", element.getAttribute("enabled"));
            break;
        }
        if (resourceRef == null) {
            resourceRef = parentResult.getOwnerDocument().createElement("resource-ref");
            resourceRef.setAttribute("ref", element.getAttribute("jndi-name"));
            Attr enAttr = element.getAttributeNode("enabled");
            if (enAttr != null) {
                resourceRef.setAttribute("enabled", element.getAttribute("enabled"));
            }
            this.appendElementToParent(parentForRef, resourceRef);
        }
    }

    private void skipGenericElementTransform(Element element, Element parentSource, Element parentResult) {
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node aNode = childNodes.item(index);
            try {
                if (aNode.getNodeType() != 1) continue;
                BaseElement baseElement = ElementToObjectMapper.getMapper().getElementObject(aNode.getNodeName());
                baseElement.transform((Element)aNode, element, parentResult);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected List getInsertElementStructure(Element element, Element parentEle) {
        List insertStrucure = ElementToObjectMapper.getMapper().getInsertElementStructure(element.getTagName());
        if (element.getTagName().equals("resource-ref") && this.appendingResourceRefToCluster) {
            if (this.insertStructureForResourceRefInCluster == null) {
                this.insertStructureForResourceRefInCluster = new ArrayList();
                this.insertStructureForResourceRefInCluster.add("application-ref");
                this.insertStructureForResourceRefInCluster.add("system-property");
                this.insertStructureForResourceRefInCluster.add("property");
            }
            return this.insertStructureForResourceRefInCluster;
        }
        return insertStrucure;
    }

    public void transferJdbcConnPool(Element element, Element parentSource, Element parentResult) {
        NodeList nodeList = parentResult.getElementsByTagName("jdbc-connection-pool");
        Element connPool = null;
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                connPool = (Element)nodeList.item(i);
                if (!connPool.getAttribute("name").equals("__TimerPool")) continue;
                this.modifyConnPoolProps(element, connPool);
                connPool.setAttribute("datasource-classname", "org.apache.derby.jdbc.ClientDataSource");
            }
        }
    }

    public void modifyConnPoolProps(Element element, Element connPool) {
        NodeList propList = connPool.getElementsByTagName("property");
        if (connPool.getAttribute("name").equals("__TimerPool")) {
            this.transferTimerPoolProps(element, propList, connPool);
        }
    }

    public void addPropertyToConnPool(Element element, Element parentSource, Element parentResult) {
        Element serverNameProp = parentResult.getOwnerDocument().createElement("property");
        serverNameProp.setAttribute("name", "serverName");
        serverNameProp.setAttribute("value", "localhost");
        parentResult.appendChild(serverNameProp);
        Element portNumberProp = parentResult.getOwnerDocument().createElement("property");
        portNumberProp.setAttribute("name", "PortNumber");
        portNumberProp.setAttribute("value", "1527");
        parentResult.appendChild(portNumberProp);
        Element connSettingsProp = parentResult.getOwnerDocument().createElement("property");
        connSettingsProp.setAttribute("name", "connectionAttributes");
        connSettingsProp.setAttribute("value", ";create=true");
        Element userProp = parentResult.getOwnerDocument().createElement("property");
        userProp.setAttribute("name", "User");
        userProp.setAttribute("value", "APP");
        parentResult.appendChild(userProp);
        Element passwordProp = parentResult.getOwnerDocument().createElement("property");
        passwordProp.setAttribute("name", "Password");
        passwordProp.setAttribute("value", "APP");
        parentResult.appendChild(passwordProp);
        Element databaseNameProp = parentResult.getOwnerDocument().createElement("property");
        databaseNameProp.setAttribute("name", "DatabaseName");
        databaseNameProp.setAttribute("value", "sun-appserv-samples");
        parentResult.appendChild(databaseNameProp);
    }

    public void transferTimerPoolProps(Element element, NodeList propList, Element parentResult) {
        for (int i = 0; i < propList.getLength(); ++i) {
            Element property = (Element)propList.item(i);
            if (property.getAttribute("name").equals("DatabaseName")) {
                property.setAttribute("value", "${com.sun.aas.instanceRoot}/lib/databases/ejbtimer");
                parentResult.appendChild(property);
            }
            if (property.getAttribute("name").equals("User")) {
                property.setAttribute("value", "APP");
                parentResult.appendChild(property);
            }
            if (!property.getAttribute("name").equals("Password")) continue;
            property.setAttribute("value", "APP");
            parentResult.appendChild(property);
        }
    }

    public void addJdbcResource(Element element, Element parentSource, Element parentResult) {
        NodeList jdbcConnPool = parentResult.getElementsByTagName("jdbc-connection-pool");
        Element jdbcResource = parentResult.getOwnerDocument().createElement("jdbc-resource");
        jdbcResource.setAttribute("enabled", "true");
        jdbcResource.setAttribute("jndi-name", "jdbc/__default");
        jdbcResource.setAttribute("object-type", "user");
        jdbcResource.setAttribute("pool-name", "DerbyPool");
        parentResult.insertBefore(jdbcResource, jdbcConnPool.item(0));
        NodeList serverList = ((Element)parentResult.getParentNode()).getElementsByTagName("servers");
        if (serverList != null && serverList.getLength() > 0) {
            NodeList servers = ((Element)serverList.item(0)).getElementsByTagName("server");
            for (int sCount = 0; sCount < servers.getLength(); ++sCount) {
                Element resourceRef = servers.item(sCount).getOwnerDocument().createElement("resource-ref");
                resourceRef.setAttribute("enabled", "true");
                resourceRef.setAttribute("ref", "jdbc/__default");
                servers.item(sCount).appendChild(resourceRef);
            }
        }
        this.appendJdbcResource = true;
    }

    public void addJdbcConnPool(Element element, Element parentSource, Element parentResult) {
        Element jdbcConnPool = parentResult.getOwnerDocument().createElement("jdbc-connection-pool");
        NodeList connPools = parentResult.getElementsByTagName("jdbc-connection-pool");
        Element firstConnPool = (Element)connPools.item(0);
        jdbcConnPool.setAttribute("connection-validation-method", "auto-commit");
        jdbcConnPool.setAttribute("datasource-classname", "org.apache.derby.jdbc.ClientDataSource");
        jdbcConnPool.setAttribute("fail-all-connections", "false");
        jdbcConnPool.setAttribute("idle-timeout-in-seconds", "300");
        jdbcConnPool.setAttribute("is-connection-validation-required", "false");
        jdbcConnPool.setAttribute("is-isolation-level-guaranteed", "true");
        jdbcConnPool.setAttribute("max-pool-size", "32");
        jdbcConnPool.setAttribute("max-wait-time-in-millis", "60000");
        jdbcConnPool.setAttribute("name", "DerbyPool");
        jdbcConnPool.setAttribute("pool-resize-quantity", "2");
        jdbcConnPool.setAttribute("res-type", "javax.sql.XADataSource");
        jdbcConnPool.setAttribute("steady-pool-size", "8");
        this.addPropertyToConnPool(element, parentSource, jdbcConnPool);
        parentResult.insertBefore(jdbcConnPool, firstConnPool);
    }
}

