/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.transform.elements;

import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.transform.elements.BaseElement;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IIOPListener
extends BaseElement {
    private final String IIOP_LISTENER_PORT_PROPERTY_NAME = "IIOP_LISTENER_PORT";

    public void transform(Element element, Element parentSource, Element parentResult) {
        String elementTagName = element.getTagName();
        NodeList resultElements = parentResult.getElementsByTagName(elementTagName);
        Element resultElement = null;
        for (int lh = 0; lh < resultElements.getLength(); ++lh) {
            Element itElement = (Element)resultElements.item(lh);
            if (!element.getAttribute("id").equals(((Element)resultElements.item(lh)).getAttribute("id"))) continue;
            resultElement = (Element)resultElements.item(lh);
            break;
        }
        List notToTransferAttrList = this.getNonTransferList(element);
        if (resultElement == null) {
            resultElement = parentResult.getOwnerDocument().createElement(elementTagName);
            if (commonInfoModel.getCurrentCluster() != null) {
                notToTransferAttrList.add("port");
                String propertyName = element.getAttribute("id") + "_IIOP_LISTENER_PORT";
                UpgradeUtils.getUpgradeUtils(commonInfoModel).updateListenerPortsForClusteredInstances(parentResult.getOwnerDocument().getDocumentElement(), propertyName, element.getAttribute("port"), this);
                resultElement.setAttribute("port", "${" + propertyName + "}");
            }
            this.transferAttributes(element, resultElement, notToTransferAttrList);
            this.appendElementToParent(parentResult, resultElement);
        } else {
            String instanceName;
            if (commonInfoModel.getCurrentCluster() == null && !commonInfoModel.isPlatformEdition(commonInfoModel.getSourceEdition()) && (instanceName = commonInfoModel.getCurrentSourceInstance()) != null && !"".equals(instanceName.trim()) && element.getAttribute("id").equals("orb-listener-1")) {
                notToTransferAttrList.add("port");
                String propertyValue = element.getAttribute("port");
                NodeList servers = parentResult.getOwnerDocument().getDocumentElement().getElementsByTagName("servers");
                NodeList serverList = ((Element)servers.item(0)).getElementsByTagName("server");
                UpgradeUtils.getUpgradeUtils(commonInfoModel).addOrUpdateSystemPropertyToServer(instanceName, serverList, "IIOP_LISTENER_PORT", element.getAttribute("port"), this);
            }
            this.transferAttributes(element, resultElement, notToTransferAttrList);
        }
        super.transform(element, parentSource, resultElement);
    }

    protected void transferAttributes(Element source, Element result, List nonTransferList) {
        if (!commonInfoModel.isPlatformEdition(commonInfoModel.getSourceEdition()) && "7x".equals(commonInfoModel.getSourceVersion()) && source.getAttribute("id").equals("orb-listener-1") && source.getAttribute("port").equals("3700")) {
            String serverID = source.getOwnerDocument().getDocumentElement().getAttribute("name");
            if ("se".equals(commonInfoModel.getSourceEdition()) || this.isAppserver71EE(source)) {
                UpgradeUtils.getUpgradeUtils(commonInfoModel).switchedIIOPPorts(serverID, result.getAttribute("port"), result.getOwnerDocument().getDocumentElement());
            }
        }
        super.transferAttributes(source, result, nonTransferList);
    }

    protected List getNonTransferList(Element element) {
        Vector<String> notToTransferAttrList = new Vector<String>();
        if (commonInfoModel.getCurrentCluster() != null && element.getAttribute("id").equals("orb-listener-1")) {
            notToTransferAttrList.add("port");
        }
        return notToTransferAttrList;
    }

    private boolean isAppserver71EE(Element source) {
        Element docEle = source.getOwnerDocument().getDocumentElement();
        NodeList iiopClusters = docEle.getElementsByTagName("iiop-cluster");
        return iiopClusters != null && iiopClusters.getLength() != 0;
    }
}

