/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.client.ProxyFactory;
import com.sun.appserv.management.j2ee.J2EEServer;
import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public abstract class BaseLoggingCommand
extends S1ASCommand {
    private static final String TARGET_OPTION = "target";

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        try {
            MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
            String instanceName = this.getOption(TARGET_OPTION);
            this.verifyTargetInstance(mbsc, instanceName);
            String objectName = this.getObjectName();
            Object[] params = this.getParamsInfo();
            String operationName = this.getOperationName();
            String[] types = this.getTypesInfo();
            Object returnValue = mbsc.invoke(new ObjectName(objectName), operationName, params, types);
            this.handleReturnValue(returnValue);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void verifyTargetInstance(MBeanServerConnection mbsc, String instanceName) throws CommandException {
        try {
            DomainRoot domainRoot = ProxyFactory.getInstance((MBeanServerConnection)mbsc).getDomainRoot();
            boolean isServer = false;
            isServer = domainRoot.getDomainConfig().getServerConfigMap().keySet().contains(instanceName);
            if (!isServer) {
                throw new CommandException(this.getLocalizedString("TargetNotAnInstance", new Object[]{instanceName}));
            }
            Map servers = domainRoot.getJ2EEDomain().getJ2EEServerMap();
            J2EEServer server = (J2EEServer)servers.get(instanceName);
            if (server != null) {
                if (server.getstate() == 1) return;
            }
            if (server.getstate() == 0) {
                return;
            }
            boolean bl = false;
            boolean running = bl;
            if (running) return;
            throw new CommandException(this.getLocalizedString("InstanceNotRunning", new Object[]{instanceName}));
        }
        catch (Exception e) {
            throw new CommandException(e);
        }
    }
}

