/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.DomainsManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.cli.commands.BaseLifeCycleCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;

public class ChangeMasterPasswordCommand
extends BaseLifeCycleCommand {
    private String newMasterPassword = null;
    private String masterPassword = null;

    public boolean validateOptions() throws CommandValidationException {
        super.validateOptions();
        if (!this.isPasswordValid(this.newMasterPassword)) {
            throw new CommandValidationException(this.getLocalizedString("PasswordLimit", new Object[]{"newmasterpassword"}));
        }
        return true;
    }

    public void changeMasterPassword(String domainName) throws DomainException, CommandValidationException, CommandException {
        DomainConfig config = this.getDomainConfig(domainName);
        DomainsManager mgr = this.getFeatureFactory().getDomainsManager();
        mgr.validateDomain(config, true);
        this.masterPassword = this.getMasterPassword(new RepositoryManager(), (RepositoryConfig)config);
        config.put((Object)"domain.masterPassword", (Object)this.masterPassword);
        mgr.validateMasterPassword(config);
        this.newMasterPassword = this.getNewMasterPassword();
        this.validateOptions();
        Boolean saveMasterPassword = this.getSaveMasterPassword(null);
        config.put((Object)"domain.newMasterPassword", (Object)this.newMasterPassword);
        config.put((Object)"domain.saveMasterPassword", (Object)saveMasterPassword);
        mgr.changeMasterPassword(config);
    }

    public void runCommand() throws CommandException, CommandValidationException {
        String domainName = null;
        try {
            this.setLoggerLevel();
            domainName = this.getDomainName();
            this.changeMasterPassword(domainName);
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("DomainPasswordChanged", new Object[]{domainName}));
        }
        catch (Exception e) {
            this.displayExceptionMessage(e);
        }
    }
}

