/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.ArrayList;
import java.util.List;

public class DomainReporter {
    private final boolean detailed;
    private final DomainConfig dc;
    private static final CLILogger logger = CLILogger.getInstance();
    private static final StringManager lsm = StringManager.getManager(DomainReporter.class);
    private final List<String> records = new ArrayList<String>();
    private ConfigContext cc = null;
    private String sn = null;

    DomainReporter(DomainConfig dc, boolean terse, ConfigContext cc) {
        if (dc == null || cc == null) {
            throw new IllegalArgumentException("Null Argument");
        }
        this.dc = dc;
        this.detailed = !terse;
        this.cc = cc;
    }

    void report() throws ConfigException {
        this.prepare();
        this.display();
    }

    private void prepare() throws ConfigException {
        PEFileLayout layout = new PEFileLayout((RepositoryConfig)this.dc);
        String xmlPath = layout.getDomainConfigFile().getAbsolutePath();
        this.sn = "server";
        String ver = Version.getFullVersion();
        this.records.add(this.getDomainBanner(this.dc.getDomainName(), ver, this.dc.getDomainRoot()));
        if (this.detailed) {
            this.records.add(this.getAdminConsoleMessage());
            this.records.add(this.getHttpUrlsMessage());
            this.records.add(this.getWebContextsMessage());
            this.records.add(this.getJmxServiceUrlMessage());
            this.records.add(this.getOccupiedPorts());
            this.records.add(this.getClusterSupport());
            this.records.add(this.getDebugMessage());
        }
    }

    private String getDomainBanner(String dn, String version, String dr) {
        return lsm.getString("domain.report.banner", (Object)dn, (Object)version, (Object)dr);
    }

    private String getDebugMessage() throws ConfigException {
        String msg = "";
        boolean debugMode = false;
        try {
            debugMode = (Boolean)this.dc.get((Object)"domain.debug");
        }
        catch (Exception e) {
            e.hashCode();
        }
        if (debugMode) {
            JavaConfig jc = ServerHelper.getConfigForServer((ConfigContext)this.cc, (String)this.sn).getJavaConfig();
            String dopt = jc.getDebugOptions();
            msg = lsm.getString("start.debug.msg", (Object)dopt);
        }
        return msg;
    }

    private String getAdminConsoleMessage() throws ConfigException {
        HttpListener admin = ServerHelper.getHttpListener((ConfigContext)this.cc, (String)this.sn, (String)"admin-listener");
        String url = "";
        String port = null;
        if (admin != null) {
            url = ServerHelper.getUrlString((HttpListener)admin);
            port = admin.getPort();
        }
        return lsm.getString("admin.console.msg", (Object)url, port);
    }

    private String getHttpUrlsMessage() throws ConfigException {
        HttpListener[] lss = ServerHelper.getHttpListeners((ConfigContext)this.cc, (String)this.sn);
        String urls = "";
        if (lss != null) {
            for (HttpListener ls : lss) {
                if ("admin-listener".equals(ls.getId()) || !ls.isEnabled()) continue;
                urls = urls + ServerHelper.getUrlString((HttpListener)ls);
                urls = urls + " ";
            }
        }
        return lsm.getString("http.listeners.msg", (Object)urls);
    }

    private String getWebContextsMessage() throws ConfigException {
        WebModule[] wms = ServerHelper.getAssociatedWebModules((ConfigContext)this.cc, (String)this.sn);
        String crs = "";
        for (WebModule wm : wms) {
            crs = crs + wm.getContextRoot();
            crs = crs + " ";
        }
        return lsm.getString("web.contexts.msg", (Object)crs);
    }

    private String getJmxServiceUrlMessage() throws ConfigException {
        String url = "";
        JmxConnector sjc = ServerHelper.getServerSystemConnector((ConfigContext)this.cc, (String)this.sn);
        if (sjc != null) {
            url = url + ServerHelper.getJmxServiceUrl((JmxConnector)sjc);
        }
        return lsm.getString("jmx.connector.msg", (Object)url);
    }

    private String getOccupiedPorts() throws ConfigException {
        String ports = "";
        ports = this.getHttpPorts() + this.getIiopPorts() + this.getJmxConnectorPorts();
        return lsm.getString("ports.msg", (Object)ports);
    }

    private String getClusterSupport() throws ConfigException {
        boolean sc = ServerHelper.isClusterAdminSupported((ConfigContext)this.cc);
        if (sc) {
            return lsm.getString("clusters.supported.msg");
        }
        return lsm.getString("clusters.not.supported.msg");
    }

    private String getHttpPorts() throws ConfigException {
        HttpListener[] hss;
        String hp = "";
        for (HttpListener hs : hss = ServerHelper.getConfigForServer((ConfigContext)this.cc, (String)this.sn).getHttpService().getHttpListener()) {
            if (!hs.isEnabled()) continue;
            hp = hp + hs.getPort();
            hp = hp + " ";
        }
        return hp;
    }

    private String getIiopPorts() throws ConfigException {
        IiopListener[] ils;
        String ip = "";
        for (IiopListener is : ils = ServerHelper.getConfigForServer((ConfigContext)this.cc, (String)this.sn).getIiopService().getIiopListener()) {
            if (!is.isEnabled()) continue;
            ip = ip + is.getPort();
            ip = ip + " ";
        }
        return ip;
    }

    private String getJmxConnectorPorts() throws ConfigException {
        JmxConnector[] jcs;
        String jp = "";
        for (JmxConnector jc : jcs = ServerHelper.getConfigForServer((ConfigContext)this.cc, (String)this.sn).getAdminService().getJmxConnector()) {
            if (!jc.isEnabled()) continue;
            jp = jp + jc.getPort();
            jp = jp + " ";
        }
        return jp;
    }

    private void display() {
        for (String record : this.records) {
            logger.printMessage(record);
        }
    }
}

