/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands.monitor;

import com.sun.appserv.management.monitor.ApplicationMonitor;
import com.sun.appserv.management.monitor.EJBModuleMonitor;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.cli.commands.monitor.MonitorTask;
import com.sun.enterprise.cli.commands.monitor.MonitorTaskException;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BeanMonitorTask
extends MonitorTask {
    String appName = null;
    String ejbName = null;
    String beanName = null;

    public BeanMonitorTask(ServerRootMonitor srm, String filter, Timer timer, boolean verbose, File fileName) throws MonitorTaskException {
        super(srm, filter, timer, verbose, fileName);
    }

    String[] possibleAppModuleFilters() {
        Map appModuleMap = this.srm.getApplicationMonitorMap();
        Vector<String> possibleFilters = new Vector<String>();
        if (appModuleMap != null && appModuleMap.size() > 0) {
            String[] appModules;
            for (String appModule : appModules = MapUtil.getKeyStrings((Map)appModuleMap)) {
                ApplicationMonitor am = (ApplicationMonitor)appModuleMap.get(appModule);
                Map innerEjbModuleMap = am.getEJBModuleMonitorMap();
                possibleFilters.addAll(this.getBeansInEjbModule(appModule, innerEjbModuleMap));
            }
        }
        return possibleFilters.toArray(new String[0]);
    }

    String[] possibleEjbModuleFilters() {
        Map ejbModuleMap = this.srm.getEJBModuleMonitorMap();
        List<String> possibleFilters = this.getBeansInEjbModule(null, ejbModuleMap);
        return possibleFilters.toArray(new String[0]);
    }

    void getDefaultFilter() throws MonitorTaskException {
        String[] appModuleFilters = this.possibleAppModuleFilters();
        String[] ejbModuleFilters = this.possibleEjbModuleFilters();
        if (ejbModuleFilters.length < 1 && appModuleFilters.length < 1) {
            throw new MonitorTaskException(localStrings.getString("command.monitor.no_value_to_monitor"));
        }
        if (ejbModuleFilters.length == 1 && appModuleFilters.length < 1) {
            this.filter = ejbModuleFilters[0];
            StringTokenizer st = new StringTokenizer(this.filter, ":");
            this.ejbName = st.nextToken();
            this.beanName = st.nextToken();
        } else if (ejbModuleFilters.length < 1 && appModuleFilters.length == 1) {
            this.filter = appModuleFilters[0];
            StringTokenizer st = new StringTokenizer(this.filter, ":");
            this.appName = st.nextToken();
            this.ejbName = st.nextToken();
            this.beanName = st.nextToken();
        } else {
            String msg = this.getAvailableFilterMessage(appModuleFilters, ejbModuleFilters);
            throw new MonitorTaskException(msg);
        }
    }

    private String getAvailableFilterMessage(String[] appModuleFilters, String[] ejbModuleFilters) {
        StringBuffer sb = new StringBuffer();
        sb.append(localStrings.getString("commands.monitor.more_than_one_monitoring_elements"));
        if (ejbModuleFilters.length > 0) {
            sb.append(localStrings.getString("commands.monitor.available_ejbmodule_elements"));
            for (String ejbmodule : ejbModuleFilters) {
                sb.append("    ");
                sb.append(ejbmodule);
                sb.append("\n");
            }
        }
        if (appModuleFilters.length > 0) {
            sb.append(localStrings.getString("commands.monitor.available_appmodule_elements"));
            for (String appmodule : appModuleFilters) {
                sb.append("    ");
                sb.append(appmodule);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void verifyFilterValue() throws MonitorTaskException {
        if (this.appName != null) {
            Map appModuleMap = this.srm.getApplicationMonitorMap();
            if (!appModuleMap.containsKey(this.appName)) throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist", new Object[]{this.appName}));
            ApplicationMonitor am = (ApplicationMonitor)appModuleMap.get(this.appName);
            Map innerEJBModuleMap = am.getEJBModuleMonitorMap();
            boolean exist = this.checkIfBeanExists(innerEJBModuleMap);
            if (exist) return;
            throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist_in2", new Object[]{this.beanName, this.appName, this.ejbName}));
        }
        Map ejbModuleMap = this.srm.getEJBModuleMonitorMap();
        boolean exist = this.checkIfBeanExists(ejbModuleMap);
        if (exist) return;
        throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist_in1", new Object[]{this.beanName, this.ejbName}));
    }

    abstract boolean checkIfBeanExists(Map<String, EJBModuleMonitor> var1) throws MonitorTaskException;

    abstract List<String> getBeansInEjbModule(String var1, Map<String, EJBModuleMonitor> var2);
}

