/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands.monitor;

import com.sun.appserv.management.monitor.ApplicationMonitor;
import com.sun.appserv.management.monitor.EJBModuleMonitor;
import com.sun.appserv.management.monitor.EntityBeanMonitor;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.cli.commands.monitor.BeanMonitorTask;
import com.sun.enterprise.cli.commands.monitor.MonitorTaskException;
import com.sun.enterprise.cli.framework.CLILogger;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.Vector;
import javax.management.j2ee.statistics.EntityBeanStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityBeanMonitorTask
extends BeanMonitorTask {
    private final String displayFormat = "%1$-10s %2$-10s %3$-10s %4$-10s %5$-10s %6$-10s";

    public EntityBeanMonitorTask(ServerRootMonitor srm, String filter, Timer timer, boolean verbose, File fileName) throws MonitorTaskException {
        super(srm, filter, timer, verbose, fileName);
        if (this.filter == null) {
            this.getDefaultFilter();
        } else {
            StringTokenizer st = new StringTokenizer(this.filter, ":");
            if (st.countTokens() < 2) {
                throw new MonitorTaskException(localStrings.getString("commands.monitor.entity_bean_invalid_filter"));
            }
            if (st.countTokens() == 2) {
                this.ejbName = st.nextToken();
                this.beanName = st.nextToken();
            } else {
                this.appName = st.nextToken();
                this.ejbName = st.nextToken();
                this.beanName = st.nextToken();
            }
            this.verifyFilterValue();
        }
        String entityBeanTitle = localStrings.getString("commands.monitor.entity_bean_monitoring_title", new Object[]{this.filter});
        String title = String.format("%1$50s", entityBeanTitle);
        CLILogger.getInstance().printMessage(title);
        this.displayHeader();
    }

    @Override
    public void run() {
        if (this.srm == null) {
            super.cancelMonitorTask();
            return;
        }
        Map ejbMap = null;
        if (this.appName == null) {
            ejbMap = this.srm.getEJBModuleMonitorMap();
        } else {
            Map appMap = this.srm.getApplicationMonitorMap();
            if (appMap == null || appMap.size() < 1) {
                this.cancelMonitorTask();
                return;
            }
            ApplicationMonitor am = (ApplicationMonitor)appMap.get(this.appName);
            ejbMap = am.getEJBModuleMonitorMap();
        }
        if (ejbMap == null || ejbMap.size() < 1) {
            this.cancelMonitorTask();
            return;
        }
        EntityBeanMonitor entitybeanMonitor = this.getEntityBeanMonitor(ejbMap);
        if (entitybeanMonitor == null) {
            this.cancelMonitorTask();
            return;
        }
        EntityBeanStats entitybeanStat = entitybeanMonitor.getEntityBeanStats();
        if (this.verbose && this.counter == 25) {
            this.displayHeader();
            this.counter = 0;
        }
        this.displayData(entitybeanStat);
        if (this.verbose) {
            ++this.counter;
        }
    }

    private EntityBeanMonitor getEntityBeanMonitor(Map<String, EJBModuleMonitor> ejbMap) {
        EJBModuleMonitor ejbModuleMonitor = ejbMap.get(this.ejbName);
        Map entitybeanMap = ejbModuleMonitor.getEntityBeanMonitorMap();
        return (EntityBeanMonitor)entitybeanMap.get(this.beanName);
    }

    @Override
    List<String> getBeansInEjbModule(String appName, Map<String, EJBModuleMonitor> ejbModuleMap) {
        Vector<String> possibleEntityBeans = new Vector<String>();
        String[] ejbModules = MapUtil.getKeyStrings(ejbModuleMap);
        if (ejbModuleMap != null && ejbModuleMap.size() > 0) {
            for (String ejbModule : ejbModules) {
                String[] entityBeans;
                EJBModuleMonitor ejbModuleMonitor = ejbModuleMap.get(ejbModule);
                Map entityBeanMap = ejbModuleMonitor.getEntityBeanMonitorMap();
                for (String entityBean : entityBeans = MapUtil.getKeyStrings((Map)entityBeanMap)) {
                    if (appName == null) {
                        possibleEntityBeans.add(ejbModule + ":" + entityBean);
                        continue;
                    }
                    possibleEntityBeans.add(appName + ":" + ejbModule + ":" + entityBean);
                }
            }
        }
        return possibleEntityBeans;
    }

    @Override
    boolean checkIfBeanExists(Map<String, EJBModuleMonitor> ejbModuleMap) throws MonitorTaskException {
        if (!ejbModuleMap.containsKey(this.ejbName)) {
            if (this.appName == null) {
                throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist", new Object[]{this.ejbName}));
            }
            throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist_in1", new Object[]{this.ejbName, this.appName}));
        }
        EJBModuleMonitor ejbmoduleMonitor = ejbModuleMap.get(this.ejbName);
        Map entityBeanMap = ejbmoduleMonitor.getEntityBeanMonitorMap();
        return entityBeanMap.containsKey(this.beanName);
    }

    private void displayHeader() {
        String pooledCount = localStrings.getString("commands.monitor.pooledcount");
        String readyCount = localStrings.getString("commands.monitor.readycount");
        String low = localStrings.getString("commands.monitor.low");
        String hi = localStrings.getString("commands.monitor.hi");
        String current = localStrings.getString("commands.monitor.current");
        String header = String.format("%1$20s %2$30s", pooledCount, readyCount);
        String subHeader = String.format("%1$-10s %2$-10s %3$-10s %4$-10s %5$-10s %6$-10s", low, hi, current, low, hi, current);
        CLILogger.getInstance().printMessage(header);
        CLILogger.getInstance().printMessage(subHeader);
        if (this.fileName != null) {
            this.writeToFile(localStrings.getString("commands.monitor.entity_bean_write_to_file"));
        }
    }

    private void displayData(EntityBeanStats stat) {
        String data = String.format("%1$-10s %2$-10s %3$-10s %4$-10s %5$-10s %6$-10s", stat.getPooledCount().getLowWaterMark(), stat.getPooledCount().getHighWaterMark(), stat.getPooledCount().getCurrent(), stat.getReadyCount().getLowWaterMark(), stat.getReadyCount().getHighWaterMark(), stat.getReadyCount().getCurrent());
        CLILogger.getInstance().printMessage(data);
        if (this.fileName != null) {
            String fileData = String.format("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s", stat.getPooledCount().getLowWaterMark(), stat.getPooledCount().getHighWaterMark(), stat.getPooledCount().getCurrent(), stat.getReadyCount().getLowWaterMark(), stat.getReadyCount().getHighWaterMark(), stat.getReadyCount().getCurrent());
            this.writeToFile(fileData);
        }
    }

    @Override
    public void displayDetails() {
        String details = localStrings.getString("commands.monitor.entity_bean_detail");
        CLILogger.getInstance().printMessage(details);
    }
}

