/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands.monitor;

import com.sun.appserv.management.monitor.HTTPServiceMonitor;
import com.sun.appserv.management.monitor.HTTPServiceVirtualServerMonitor;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.monitor.statistics.HTTPServiceVirtualServerStats;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.cli.commands.monitor.MonitorTask;
import com.sun.enterprise.cli.commands.monitor.MonitorTaskException;
import com.sun.enterprise.cli.framework.CLILogger;
import java.io.File;
import java.util.Map;
import java.util.Timer;

public class HttpServiceVirtualServerMonitorTask
extends MonitorTask {
    private final String displayFormat = "%1$-20s %2$-10s %3$-20s %4$-10s";

    public HttpServiceVirtualServerMonitorTask(ServerRootMonitor srm, String filter, Timer timer, boolean verbose, File fileName) throws MonitorTaskException {
        super(srm, filter, timer, verbose, fileName);
        HTTPServiceMonitor httpserviceMonitor = srm.getHTTPServiceMonitor();
        if (httpserviceMonitor == null) {
            throw new MonitorTaskException("Unable to monitor virtualserver");
        }
        Map httpServiceMap = httpserviceMonitor.getHTTPServiceVirtualServerMonitorMap();
        if (httpServiceMap == null) {
            throw new MonitorTaskException(localStrings.getString("commands.monitor.unable_to_monitor_virtual_server"));
        }
        String[] keys = MapUtil.getKeyStrings((Map)httpServiceMap);
        if (this.filter == null) {
            this.checkForNumberOfElements(keys);
            this.filter = keys[0];
        } else if (!httpServiceMap.containsKey(this.filter)) {
            throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist", new Object[]{this.filter}));
        }
        String virtualServerTitle = localStrings.getString("commands.monitor.virtual_server_title", new Object[]{this.filter});
        String title = String.format("%1$50s", virtualServerTitle);
        CLILogger.getInstance().printMessage(title);
        this.displayHeader();
    }

    public void run() {
        if (this.srm == null) {
            super.cancelMonitorTask();
            return;
        }
        HTTPServiceMonitor httpserviceMonitor = this.srm.getHTTPServiceMonitor();
        if (httpserviceMonitor == null) {
            this.cancelMonitorTask();
            return;
        }
        Map httpServiceMap = httpserviceMonitor.getHTTPServiceVirtualServerMonitorMap();
        if (httpServiceMap == null || httpServiceMap.size() < 1) {
            this.cancelMonitorTask();
            return;
        }
        HTTPServiceVirtualServerMonitor httpServiceMonitor = (HTTPServiceVirtualServerMonitor)httpServiceMap.get(this.filter);
        if (httpServiceMonitor == null) {
            this.cancelMonitorTask();
            return;
        }
        HTTPServiceVirtualServerStats httpServiceStats = httpServiceMonitor.getHTTPServiceVirtualServerStats();
        if (this.verbose && this.counter == 25) {
            this.displayHeader();
            this.counter = 0;
        }
        this.displayData(httpServiceStats);
        if (this.verbose) {
            ++this.counter;
        }
    }

    private void displayHeader() {
        String hosts = localStrings.getString("commands.monitor.hosts");
        String id = localStrings.getString("commands.monitor.id");
        String interfaces = localStrings.getString("commands.monitor.interfaces");
        String mode = localStrings.getString("commands.monitor.mode");
        String header = String.format("%1$-20s %2$-10s %3$-20s %4$-10s", hosts, id, interfaces, mode);
        CLILogger.getInstance().printMessage(header);
        if (this.fileName != null) {
            this.writeToFile(hosts + "," + id + "," + interfaces + "," + mode);
        }
    }

    private void displayData(HTTPServiceVirtualServerStats vss) {
        String data = String.format("%1$-20s %2$-10s %3$-20s %4$-10s", vss.getHosts().getCurrent(), vss.getID().getCurrent(), vss.getInterfaces().getCurrent(), vss.getMode().getCurrent());
        CLILogger.getInstance().printMessage(data);
        if (this.fileName != null) {
            String fileData = String.format("%1$s,%2$s,%3$s,%4$s,", vss.getHosts().getCurrent(), vss.getID().getCurrent(), vss.getInterfaces().getCurrent(), vss.getMode().getCurrent());
            this.writeToFile(fileData);
        }
    }

    public void displayDetails() {
        String details = localStrings.getString("commands.monitor.virtual_server_detail");
        CLILogger.getInstance().printMessage(details);
    }
}

