/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ee.sfsb.store;

import com.sun.appserv.ha.spi.BackingStore;
import com.sun.appserv.ha.spi.BackingStoreException;
import com.sun.appserv.ha.spi.Metadata;
import com.sun.appserv.ha.spi.SimpleMetadata;
import com.sun.ejb.Container;
import com.sun.ejb.ee.sfsb.store.BaseSFSBStoreManager;
import com.sun.ejb.ee.sfsb.store.EJBModuleStatistics;
import com.sun.ejb.ee.sfsb.store.EJBStoreBase;
import com.sun.ejb.ee.sfsb.store.ReplicatedSFSBStoreManager;
import com.sun.ejb.spi.sfsb.store.SFSBBeanState;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManager;
import com.sun.enterprise.ee.web.sessmgmt.JxtaBackingStoreImpl;
import com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationSender;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationManager;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationMessageRouter;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.enterprise.web.ServerConfigLookup;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReplicatedEjbStore
extends EJBStoreBase {
    public static final String LOGGER_MEM_REP = "com.sun.ejb.ee.sfsb.store";
    private static final Logger _logger = Logger.getLogger("com.sun.ejb.ee.sfsb.store");
    private static final String info = "ReplicatedEjbStore/1.0";
    private static final String storeName = "ReplicatedEjbStore";
    static final String MODE_EJB = "ejb";
    static final String UNDEPLOY_COMMAND = "undeploy";
    static final String REMOVE_EXPIRED_COMMAND = "removeExpired";
    static final String UPDATE_LAST_ACCESS_TIME_COMMAND = "updateLastAccessTime";
    static final String REMOVE_COMMAND = "remove";
    protected SFSBStoreManager manager;
    private Container container = null;
    private String clusterID = null;
    private String containerID = null;
    protected int _debug = 1;

    public ReplicatedEjbStore() {
        this.threadName = storeName;
    }

    protected boolean isMonitoringEnabled() {
        BaseSFSBStoreManager mgr = (BaseSFSBStoreManager)this.getSFSBStoreManager();
        return mgr.isMonitoringEnabled();
    }

    protected EJBModuleStatistics getEJBModuleStatistics() {
        BaseSFSBStoreManager mgr = (BaseSFSBStoreManager)this.getSFSBStoreManager();
        return mgr.getEJBModuleStatistics();
    }

    protected void debug(String message) {
        System.out.println(message);
    }

    public Container getContainer() {
        return this.container;
    }

    protected String getContainerId() {
        return this.containerID;
    }

    protected long getContainerIdAsLong() {
        Long longContId = new Long(this.getContainerId());
        return longContId;
    }

    protected void setContainerId(String containerId) {
        this.containerID = containerId;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public int getContainerSize() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "ReplicatedEjbStore.getContainerSize containerId = " + this.containerID);
        }
        int result = 0;
        return result;
    }

    public void save(SFSBBeanState[] beanStates, long startTime) throws IOException {
        long eachStartTime = startTime;
        long eachEndTime = 0L;
        for (int i = 0; i < beanStates.length; ++i) {
            BackingStore replicator;
            SFSBBeanState sfsBean = beanStates[i];
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "ReplicatedEjbStore aggregate save bean[" + i + "]=" + sfsBean);
            }
            if ((replicator = this.getBackingStoreForBean(sfsBean)) == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "ReplicatedEjbStore aggregate save bean[" + i + "]=" + "unable to find replicator");
                }
                return;
            }
            this.save(sfsBean, replicator);
            if (!this.isMonitoringEnabled()) continue;
            eachEndTime = System.currentTimeMillis();
            long storeDuration = eachEndTime - eachStartTime;
            sfsBean.setTxCheckpointDuration(sfsBean.getTxCheckpointDuration() + storeDuration);
            eachStartTime = eachEndTime;
        }
    }

    public void save(SFSBBeanState sfsBean, SFSBStoreManager mgr) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering(storeName, "save", new Object[]{sfsBean, mgr});
        }
        this.manager = mgr;
        this.save(sfsBean);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting(storeName, "save");
        }
    }

    public void saveOldAPI(SFSBBeanState sfsBean) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering(storeName, "save", sfsBean);
        }
        long tempStartTime = System.currentTimeMillis();
        this.transmitSession(sfsBean, "save", true);
        System.out.println("ReplicatedEjbStore>>save time = " + (System.currentTimeMillis() - tempStartTime));
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting(storeName, "save");
        }
    }

    public void save(SFSBBeanState sfsBean) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering(storeName, "save", sfsBean);
        }
        long tempStartTime = System.currentTimeMillis();
        ReplicatedSFSBStoreManager mgr = (ReplicatedSFSBStoreManager)this.getSFSBStoreManager();
        if (mgr == null) {
            return;
        }
        BackingStore replicator = mgr.getBackingStore();
        SimpleMetadata simpleMetadata = this.createSimpleMetadata(sfsBean);
        try {
            replicator.save(sfsBean.getId().toString(), (Metadata)simpleMetadata);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting(storeName, "save");
        }
    }

    public void save(SFSBBeanState sfsBean, BackingStore replicator) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering(storeName, "save", sfsBean);
        }
        long tempStartTime = System.currentTimeMillis();
        ReplicatedSFSBStoreManager mgr = (ReplicatedSFSBStoreManager)this.getSFSBStoreManager();
        if (mgr == null) {
            return;
        }
        SimpleMetadata simpleMetadata = this.createSimpleMetadata(sfsBean);
        try {
            replicator.save(sfsBean.getId().toString(), (Metadata)simpleMetadata);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting(storeName, "save");
        }
    }

    public void saveForRepair(ReplicationState state, SFSBStoreManager mgr) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering(storeName, "saveForRepair", new Object[]{state, mgr});
        }
        this.manager = mgr;
        this.saveForRepair(state);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting(storeName, "saveForRepair");
        }
    }

    public void saveForRepair(ReplicationState state) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering(storeName, "saveForRepair", state);
        }
        long tempStartTime = System.currentTimeMillis();
        this.transmitState(state, "save", true);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting(storeName, "saveForRepair");
        }
    }

    private BackingStore getBackingStoreForBean(SFSBBeanState beanState) {
        BackingStore result = null;
        long longContId = beanState.getContainerId();
        String containerId = this.getContainerIDAsString(longContId);
        ReplicationMessageRouter messageRouter = ReplicationMessageRouter.createInstance();
        ReplicationManager mgr = messageRouter.findApp(containerId);
        if (mgr != null && mgr instanceof ReplicatedSFSBStoreManager) {
            result = ((ReplicatedSFSBStoreManager)mgr).getBackingStore();
        }
        return result;
    }

    public String getContainerIDAsString(long containerID) {
        Long longContId = new Long(containerID);
        return longContId.toString();
    }

    public SFSBBeanState loadBean(Object id) throws IOException {
        ReplicationState broadcastResultState;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering(storeName, "loadBean", id);
        }
        if (id == null) {
            return null;
        }
        String idString = id.toString();
        SFSBBeanState bean = null;
        ReplicatedSFSBStoreManager repMgr = (ReplicatedSFSBStoreManager)this.getSFSBStoreManager();
        ReplicationState localCachedState = repMgr.transferFromReplicationCache(idString);
        ReplicationState bestState = this.getBestResult(localCachedState, broadcastResultState = this.findBeanViaBroadcast(idString));
        if (bestState != null && bestState.getState() != null) {
            bean = this.createBeanState(bestState);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting(storeName, "loadBean", bean);
        }
        return bean;
    }

    private ReplicationState getBestResult(ReplicationState localState, ReplicationState broadcastResultState) {
        if (localState == null) {
            return broadcastResultState;
        }
        if (broadcastResultState == null) {
            return localState;
        }
        if (broadcastResultState.getVersion() >= localState.getVersion()) {
            return broadcastResultState;
        }
        return localState;
    }

    private ReplicationState findBeanViaBroadcastOldAPI(String id) {
        ReplicationState state = ReplicationState.createBroadcastQueryState(MODE_EJB, id, this.getContainerId(), this.getInstanceName());
        JxtaReplicationSender sender = JxtaReplicationSender.createInstance();
        ReplicationState result = sender.sendReplicationStateQuery(state);
        return result;
    }

    public String getInstanceName() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getServerName();
    }

    private ReplicationState findBeanViaBroadcast(String id) {
        ReplicatedSFSBStoreManager mgr = (ReplicatedSFSBStoreManager)this.getSFSBStoreManager();
        if (mgr == null) {
            return null;
        }
        BackingStore replicator = mgr.getBackingStore();
        SimpleMetadata simpleMetadata = null;
        try {
            simpleMetadata = (SimpleMetadata)replicator.load(id);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        ReplicationState result = null;
        if (simpleMetadata != null) {
            result = ReplicationState.createReplicationState(MODE_EJB, id, null, (Metadata)simpleMetadata);
        }
        return result;
    }

    public boolean removeOldAPI(Object id) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering(storeName, REMOVE_COMMAND, id);
        }
        boolean result = false;
        if (id == null) {
            return result;
        }
        ReplicationState transmitState = this.createSparseReplicationState(id.toString(), REMOVE_COMMAND, -1L);
        this.doTransmit(transmitState);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting(storeName, REMOVE_COMMAND, new Boolean(result));
        }
        return result;
    }

    public boolean remove(Object id) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering(storeName, REMOVE_COMMAND, id);
        }
        boolean result = false;
        if (id == null) {
            return result;
        }
        ReplicatedSFSBStoreManager mgr = (ReplicatedSFSBStoreManager)this.getSFSBStoreManager();
        if (mgr == null) {
            return result;
        }
        BackingStore replicator = mgr.getBackingStore();
        try {
            replicator.remove(id.toString());
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting(storeName, REMOVE_COMMAND, new Boolean(result));
        }
        return result;
    }

    public int removeExpiredSessionsOldAPI() {
        _logger.finest("IN ReplicatedEjbStore>>removeExpiredSessions");
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "ReplicatedEjbStore.removeExpiredSessions containerId = " + this.containerID);
        }
        int result = 0;
        ReplicationState transmitState = this.createSparseReplicationState(this.getContainerId(), REMOVE_EXPIRED_COMMAND, -1L);
        this.doTransmit(transmitState);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ReplicatedEjbStore>>removeExpiredSessions():number of expired beans = " + result);
        }
        return result;
    }

    public int removeExpiredSessions() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN ReplicatedEjbStore>>removeExpiredSessions");
            _logger.log(Level.FINE, "ReplicatedEjbStore.removeExpiredSessions containerId = " + this.containerID);
        }
        int result = 0;
        ReplicatedSFSBStoreManager mgr = (ReplicatedSFSBStoreManager)this.getSFSBStoreManager();
        if (mgr == null) {
            return result;
        }
        BackingStore replicator = mgr.getBackingStore();
        try {
            replicator.removeExpired();
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicatedEjbStore>>removeExpiredSessions():number of expired beans = " + result);
        }
        return result;
    }

    public void undeployContainerOldAPI() {
        _logger.finest("IN ReplicatedEjbStore>>undeployContainer");
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "ReplicatedEjbStore.undeployContainer containerId = " + this.containerID);
        }
        ReplicationState transmitState = this.createSparseReplicationState(this.getContainerId(), UNDEPLOY_COMMAND, -1L);
        this.doTransmit(transmitState);
    }

    public void undeployContainer() {
        ReplicatedSFSBStoreManager mgr;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN ReplicatedEjbStore>>undeployContainer");
            _logger.log(Level.FINE, "ReplicatedEjbStore.undeployContainer containerId = " + this.containerID);
        }
        if ((mgr = (ReplicatedSFSBStoreManager)this.getSFSBStoreManager()) == null) {
            return;
        }
        BackingStore replicator = mgr.getBackingStore();
        try {
            replicator.destroy();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void updateLastAccessTimeOldAPI(Object sessionKey, long time) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "ReplicatedEjbStore.updateLastAccessTime id = " + sessionKey);
        }
        ReplicationState transmitState = this.createSparseReplicationState(sessionKey.toString(), UPDATE_LAST_ACCESS_TIME_COMMAND, time);
        this.doTransmit(transmitState);
    }

    public void updateLastAccessTime(Object sessionKey, long time) throws IOException {
        ReplicatedSFSBStoreManager mgr;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "ReplicatedEjbStore.updateLastAccessTime id = " + sessionKey);
        }
        if ((mgr = (ReplicatedSFSBStoreManager)this.getSFSBStoreManager()) == null) {
            return;
        }
        BackingStore replicator = mgr.getBackingStore();
        try {
            replicator.updateLastAccessTime(sessionKey.toString(), time, 0L);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
    }

    public void cleanup() {
    }

    protected void transmitSession(SFSBBeanState beanState, String command) throws IOException {
        ReplicationState transmitState = this.createReplicationState(beanState, command);
        this.doTransmit(transmitState);
    }

    protected void transmitSession(SFSBBeanState beanState, String command, boolean wait) throws IOException {
        ReplicationState transmitState = this.createReplicationState(beanState, command);
        this.doTransmit(transmitState, wait);
    }

    protected void transmitState(ReplicationState state, String command) throws IOException {
        ReplicationState transmitState = this.createRepairReplicationState(state, command);
        this.doTransmit(transmitState);
    }

    protected void transmitState(ReplicationState state, String command, boolean wait) throws IOException {
        ReplicationState transmitState = this.createRepairReplicationState(state, command);
        this.doTransmit(transmitState, wait);
    }

    protected ReplicationState doTransmit(ReplicationState transmitState) {
        JxtaReplicationSender replicationSender = JxtaReplicationSender.createInstance();
        ReplicationState resultState = replicationSender.sendReplicationState(transmitState);
        return resultState;
    }

    protected ReplicationState doTransmit(ReplicationState transmitState, boolean wait) {
        JxtaReplicationSender replicationSender = JxtaReplicationSender.createInstance();
        ReplicationState resultState = replicationSender.sendReplicationState(transmitState, wait);
        return resultState;
    }

    public void sendResponse(ReplicationState state) {
        this.doReturnTransmit(state);
    }

    protected ReplicationState doReturnTransmit(ReplicationState transmitState) {
        JxtaReplicationSender replicationSender = JxtaReplicationSender.createInstance();
        ReplicationState resultState = replicationSender.sendReplicationStateResponse(transmitState);
        return resultState;
    }

    public void sendQueryResponse(ReplicationState state, String returnInstance) {
        System.out.println("ReplicationEjbStore>>sendQueryResponse");
        this.doReturnQueryTransmit(state, returnInstance);
    }

    protected ReplicationState doReturnQueryTransmit(ReplicationState transmitState, String returnInstance) {
        JxtaReplicationSender replicationSender = JxtaReplicationSender.createInstance();
        ReplicationState resultState = replicationSender.sendReplicationStateQueryResponse(transmitState, returnInstance);
        return resultState;
    }

    protected ReplicationState createReplicationState(SFSBBeanState beanState, String command) throws IOException {
        byte[] sfsbState = beanState.getState();
        ReplicationState transmitState = new ReplicationState(MODE_EJB, beanState.getId().toString(), this.getContainerId(), beanState.getVersion(), beanState.getLastAccess(), this.getIdleTimeoutInSeconds(), null, null, null, command, sfsbState, null);
        return transmitState;
    }

    protected ReplicationState createSparseReplicationState(String id, String command, long lastAccessTime) {
        ReplicationState transmitState = new ReplicationState(MODE_EJB, id, this.getContainerId(), 0L, lastAccessTime, this.getIdleTimeoutInSeconds(), null, null, null, command, null, null);
        return transmitState;
    }

    protected ReplicationState createRepairReplicationState(ReplicationState state, String command) throws IOException {
        ReplicationState transmitState = new ReplicationState(MODE_EJB, state.getId().toString(), state.getAppId(), state.getVersion(), state.getLastAccess(), state.getMaxInactiveInterval(), null, null, null, command, state.getState(), null);
        return transmitState;
    }

    protected SFSBBeanState createBeanState(ReplicationState replicationState) {
        SFSBBeanState resultBeanState = new SFSBBeanState(this.getClusterID(), this.getContainerIdAsLong(), replicationState.getId(), replicationState.getLastAccess(), false, replicationState.getState(), this.getSFSBStoreManager());
        resultBeanState.setVersion(replicationState.getVersion());
        return resultBeanState;
    }

    protected SimpleMetadata createSimpleMetadata(SFSBBeanState beanState) throws IOException {
        byte[] sfsbState = beanState.getState();
        SimpleMetadata metaData = new SimpleMetadata(beanState.getVersion(), beanState.getLastAccess(), this.getIdleTimeoutInSeconds(), sfsbState, null);
        return metaData;
    }

    long getIdleTimeoutInSeconds() {
        long result = -1L;
        ReplicatedSFSBStoreManager mgr = (ReplicatedSFSBStoreManager)this.getSFSBStoreManager();
        if (mgr != null) {
            result = mgr.getIdleTimeoutInSeconds();
        }
        return result;
    }

    public void removeIds(long msgID, byte[] removedIdsData) throws IOException {
        ReplicatedSFSBStoreManager mgr;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering(storeName, "removeIds", msgID);
        }
        if ((mgr = (ReplicatedSFSBStoreManager)this.getSFSBStoreManager()) == null) {
            return;
        }
        JxtaBackingStoreImpl replicator = (JxtaBackingStoreImpl)mgr.getBackingStore();
        try {
            replicator.removeIds(msgID, removedIdsData);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting(storeName, "removeIds");
        }
    }
}

