/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ee.sfsb.store;

import com.sun.appserv.ha.spi.BackingStore;
import com.sun.appserv.ha.spi.BackingStoreException;
import com.sun.appserv.ha.spi.BackingStoreFactory;
import com.sun.appserv.ha.spi.BackingStoreRegistry;
import com.sun.appserv.ha.spi.SimpleMetadata;
import com.sun.appserv.util.cache.BaseCache;
import com.sun.ejb.ee.sfsb.store.BaseSFSBStoreManager;
import com.sun.ejb.ee.sfsb.store.EJBModuleStatistics;
import com.sun.ejb.ee.sfsb.store.ReplicatedEjbStore;
import com.sun.ejb.ee.sfsb.store.ReplicatedEjbStoreFactory;
import com.sun.ejb.spi.sfsb.store.SFSBBeanState;
import com.sun.ejb.spi.sfsb.store.SFSBStoreManagerException;
import com.sun.ejb.spi.sfsb.store.SFSBTxStoreManager;
import com.sun.ejb.spi.stats.MonitorableSFSBStoreManager;
import com.sun.enterprise.ee.web.sessmgmt.JxtaBackingStoreFactory;
import com.sun.enterprise.ee.web.sessmgmt.JxtaBackingStoreImpl;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationHealthChecker;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationManager;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationMessageRouter;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationResponseRepository;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationStateQueryResponse;
import com.sun.enterprise.ee.web.sessmgmt.StorePool;
import com.sun.enterprise.web.ServerConfigLookup;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicatedSFSBStoreManager
extends BaseSFSBStoreManager
implements SFSBTxStoreManager,
MonitorableSFSBStoreManager,
ReplicationManager {
    static final String MODE_EJB = "ejb";
    public static final String LOGGER_MEM_REP = "com.sun.ejb.ee.sfsb.store";
    private static final Level TRACE_LEVEL = Level.FINE;
    static final String DUPLICATE_IDS_SEMANTICS_PROPERTY = "duplicate_ids_semantics_property";
    StorePool _pool = null;
    protected static int _maxBaseCacheSize = 4096;
    protected static float _loadFactor = 0.75f;
    private static final Logger _logger = Logger.getLogger("com.sun.ejb.ee.sfsb.store");
    protected String _passedInPersistenceType = null;
    protected BackingStore backingStore = null;
    protected BaseCache replicatedSessions = new BaseCache();
    protected BaseCache locallyPassivatedSessions = new BaseCache();
    private static int NUMBER_OF_REQUESTS_BEFORE_FLUSH;
    volatile Map<String, String> removedKeysMap = new ConcurrentHashMap<String, String>();
    private static AtomicInteger requestCounter;
    private static int _messageIDCounter;
    private AtomicBoolean timeToChange = new AtomicBoolean(false);
    private DispatchThread dispatchThread = new DispatchThread();

    protected static boolean checkSessionCacheProperties() {
        boolean result = false;
        try {
            String loadFactor;
            Properties props = System.getProperties();
            String cacheSize = props.getProperty("EJB_SESSION_CACHE_MAX_BASE_CACHE_SIZE");
            if (null != cacheSize) {
                _maxBaseCacheSize = new Integer(cacheSize);
            }
            if (null != (loadFactor = props.getProperty("EJB_SESSION_CACHE_MAX_BASE_LOAD_FACTOR"))) {
                _loadFactor = new Float(loadFactor).floatValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public String getPassedInPersistenceType() {
        return this._passedInPersistenceType;
    }

    public void setPassedInPersistenceType(String persistenceType) {
        this._passedInPersistenceType = persistenceType;
    }

    @Override
    public String getApplicationId() {
        return this.getContainerID();
    }

    public BackingStore getBackingStore() {
        if (this.backingStore == null) {
            this.createBackingStore();
        }
        return this.backingStore;
    }

    public void setBackingStore(BackingStore aBackingStore) {
        this.backingStore = aBackingStore;
    }

    void createBackingStore() {
        BackingStoreRegistry backingStoreRegistry;
        Properties env;
        BackingStoreFactory storeFactory = this.getBackingStoreFactory();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("storeFactory: " + storeFactory);
        }
        if ((env = (backingStoreRegistry = BackingStoreRegistry.getInstance()).getFactoryClassEnv(this.getPassedInPersistenceType())) != null) {
            env.put(DUPLICATE_IDS_SEMANTICS_PROPERTY, (Object)true);
        }
        BackingStore backingStore = null;
        try {
            backingStore = storeFactory.createBackingStore(SimpleMetadata.class, this.getContainerID(), env);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
        if (backingStore != null && backingStore instanceof JxtaBackingStoreImpl) {
            ((JxtaBackingStoreImpl)backingStore).setMode(MODE_EJB);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("backingStore: " + backingStore);
        }
        this.setBackingStore(backingStore);
    }

    protected BackingStoreFactory getBackingStoreFactory() {
        JxtaBackingStoreFactory backingStoreFactory = new JxtaBackingStoreFactory();
        BackingStoreRegistry backingStoreRegistry = BackingStoreRegistry.getInstance();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("getBackingStoreFactory:passedInPersistenceType=" + this.getPassedInPersistenceType());
        }
        if (this.getPassedInPersistenceType() == null) {
            return backingStoreFactory;
        }
        String factoryClassName = backingStoreRegistry.getFactoryClassName(this.getPassedInPersistenceType());
        return this.getBackingStoreFactoryFromName(factoryClassName);
    }

    private BackingStoreFactory getBackingStoreFactoryFromName(String className) {
        JxtaBackingStoreFactory backingStoreFactory;
        block3: {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("getBackingStoreFactoryFromName:className: " + className);
            }
            backingStoreFactory = new JxtaBackingStoreFactory();
            try {
                backingStoreFactory = (BackingStoreFactory)Class.forName(className).newInstance();
            }
            catch (Exception ex) {
                if (!_logger.isLoggable(Level.FINE)) break block3;
                _logger.fine("ReplicatedSFSBStoreManager:unable to create backing store factory");
            }
        }
        return backingStoreFactory;
    }

    public ReplicatedSFSBStoreManager() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "ReplicatedSFSBStoreManager  loaded successfully......");
        }
        ReplicatedEjbStoreFactory haStoreFactory = new ReplicatedEjbStoreFactory();
        this._pool = new StorePool(100, -1, 100, haStoreFactory);
        this.replicatedSessions = new BaseCache();
        this.replicatedSessions.init(_maxBaseCacheSize, _loadFactor, null);
        this.locallyPassivatedSessions = new BaseCache();
        this.locallyPassivatedSessions.init(_maxBaseCacheSize, _loadFactor, null);
    }

    public String getInstanceName() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getServerName();
    }

    public BaseCache getReplicatedSessions() {
        return this.replicatedSessions;
    }

    public void setReplicatedSessions(BaseCache sesstable) {
        this.replicatedSessions = sesstable;
    }

    protected synchronized void putInReplicationCache(ReplicationState sessionState) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + this.getClass().getName() + ">>putInReplicationCache id: " + sessionState.getId());
        }
        String id = (String)sessionState.getId();
        if (this.replicatedSessions == null || id == null) {
            return;
        }
        ReplicationState currentState = (ReplicationState)this.replicatedSessions.get((Object)id);
        if (_logger.isLoggable(Level.FINE) && currentState != null) {
            _logger.fine("currentVersion: " + currentState.getVersion() + " newVersion: " + sessionState.getVersion());
        }
        if (currentState != null && currentState.getVersion() > sessionState.getVersion()) {
            return;
        }
        this.replicatedSessions.put(sessionState.getId(), (Object)sessionState);
        if (_logger.isLoggable(TRACE_LEVEL)) {
            _logger.log(TRACE_LEVEL, "in " + this.getClass().getName() + ">>putInReplicationCache complete id: " + sessionState.getId() + "[ver:" + sessionState.getVersion() + "]");
        }
    }

    protected ReplicationState getFromReplicationCache(String id) {
        return (ReplicationState)this.replicatedSessions.get((Object)id);
    }

    protected void removeFromReplicationCache(ReplicationState sessionState) {
        if (this.replicatedSessions == null || sessionState == null) {
            return;
        }
        this.replicatedSessions.remove(sessionState.getId());
    }

    protected synchronized ReplicationState transferFromReplicationCache(String id) {
        ReplicationState result = this.getFromReplicationCache(id);
        this.removeFromReplicationCache(result);
        return result;
    }

    public BaseCache getLocallyPassivatedSessions() {
        return this.locallyPassivatedSessions;
    }

    public void setLocallyPassivatedSessions(BaseCache sesstable) {
        this.locallyPassivatedSessions = sesstable;
    }

    protected void putInLocallyPassivatedCache(SFSBBeanState beanState) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicatedSFSBStoreManager>>putInLocallyPassivatedCache id: " + beanState.getContainerId());
        }
        if (this.locallyPassivatedSessions == null) {
            return;
        }
        this.locallyPassivatedSessions.put(beanState.getId(), (Object)beanState);
    }

    protected SFSBBeanState getFromLocallyPassivatedCache(String id) {
        return (SFSBBeanState)this.locallyPassivatedSessions.get((Object)id);
    }

    protected void removeFromLocallyPassivatedCache(SFSBBeanState beanState) {
        if (this.locallyPassivatedSessions == null) {
            return;
        }
        this.locallyPassivatedSessions.remove(beanState.getId());
    }

    protected void removeIdFromLocallyPassivatedCache(Object id) {
        if (this.locallyPassivatedSessions == null) {
            return;
        }
        this.locallyPassivatedSessions.remove(id);
    }

    public StorePool getStorePool() {
        return this._pool;
    }

    public void setStorePool(StorePool pool) {
        this._pool = pool;
    }

    private ReplicatedEjbStore getStore() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering("ReplicatedSFSBStoreManager", "getStore");
        }
        ReplicatedEjbStore store = null;
        try {
            store = (ReplicatedEjbStore)this._pool.take();
            store.setContainer(this.getContainer());
            store.setClusterID(this.getClusterID());
            store.setContainerId(this.getContainerID());
            store.setSFSBStoreManager(this);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "ReplicatedSFSBStoreManager.getStore returning   " + store);
            }
            return store;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.exiting("ReplicatedSFSBStoreManager", "getStore", store);
            }
            return store;
        }
    }

    private void putStore(ReplicatedEjbStore store) {
        store.setContainer(null);
        if (store != null) {
            try {
                StorePool storePool = this.getStorePool();
                if (storePool != null) {
                    storePool.put(store);
                }
            }
            catch (InterruptedException ex1) {
                ex1.printStackTrace();
            }
        }
    }

    public void checkpointSave(SFSBBeanState beanState) throws SFSBStoreManagerException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering("ReplicatedSFSBStoreManager", "checkpointSave", new Object[]{beanState});
        }
        EJBModuleStatistics stats = this.getEJBModuleStatistics();
        long saveStartTime = 0L;
        if (this.isMonitoringEnabled()) {
            saveStartTime = System.currentTimeMillis();
        }
        StorePool storePool = this.getStorePool();
        ReplicatedEjbStore store = null;
        try {
            store = this.getStore();
            store.save(beanState, this);
        }
        catch (IOException e) {
            throw new SFSBStoreManagerException("Error during checkpointSave: id =" + beanState.getId().toString(), (Exception)e);
        }
        finally {
            this.putStore(store);
        }
        if (this.isMonitoringEnabled()) {
            long saveEndTime = System.currentTimeMillis();
            stats.processCheckpointSave(saveEndTime - saveStartTime);
            stats.processBeanSize(this.getBeanSize(beanState));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting("ReplicatedSFSBStoreManager", "checkpointSave");
        }
    }

    public void repairSave(ReplicationState state) throws SFSBStoreManagerException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering("ReplicatedSFSBStoreManager", "repairSave", new Object[]{state});
        }
        EJBModuleStatistics stats = this.getEJBModuleStatistics();
        long saveStartTime = 0L;
        if (this.isMonitoringEnabled()) {
            saveStartTime = System.currentTimeMillis();
        }
        StorePool storePool = this.getStorePool();
        ReplicatedEjbStore store = null;
        try {
            store = this.getStore();
            store.saveForRepair(state, this);
        }
        catch (IOException e) {
            throw new SFSBStoreManagerException("Error during repairSave: id =" + state.getId().toString(), (Exception)e);
        }
        finally {
            this.putStore(store);
        }
        if (this.isMonitoringEnabled()) {
            long saveEndTime = System.currentTimeMillis();
            stats.processCheckpointSave(saveEndTime - saveStartTime);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting("ReplicatedSFSBStoreManager", "repairSave");
        }
    }

    public MonitorableSFSBStoreManager getMonitorableSFSBStoreManager() {
        return this;
    }

    public SFSBBeanState getState(Object id) throws SFSBStoreManagerException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering("ReplicatedSFSBStoreManager", "getState", id);
        }
        if (id == null) {
            return null;
        }
        SFSBBeanState sfsbState = null;
        sfsbState = this.getFromLocallyPassivatedCache(id.toString());
        if (sfsbState != null) {
            return sfsbState;
        }
        StorePool storePool = this.getStorePool();
        ReplicatedEjbStore store = null;
        try {
            store = this.getStore();
            sfsbState = store.loadBean(id);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.exiting("ReplicatedSFSBStoreManager", "getStore", sfsbState);
            }
            SFSBBeanState sFSBBeanState = sfsbState;
            return sFSBBeanState;
        }
        catch (Exception e) {
            throw new SFSBStoreManagerException("Error loading SFSB state: id =" + id.toString(), e);
        }
        finally {
            this.putStore(store);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.exiting("ReplicatedSFSBStoreManager", "getStore", sfsbState);
            }
        }
    }

    public void passivateSave(SFSBBeanState beanState) throws SFSBStoreManagerException {
        this.putInLocallyPassivatedCache(beanState);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering("ReplicatedSFSBStoreManager", "passivateSave", new Object[]{beanState});
        }
        EJBModuleStatistics stats = this.getEJBModuleStatistics();
        long saveStartTime = 0L;
        if (this.isMonitoringEnabled()) {
            saveStartTime = System.currentTimeMillis();
        }
        StorePool storePool = this.getStorePool();
        ReplicatedEjbStore store = null;
        try {
            store = this.getStore();
            store.save(beanState, this);
        }
        catch (IOException e) {
            throw new SFSBStoreManagerException("Error during passivateSave: id =" + beanState.getId().toString(), (Exception)e);
        }
        finally {
            this.putStore(store);
        }
        if (this.isMonitoringEnabled()) {
            long saveEndTime = System.currentTimeMillis();
            stats.processPassivateSave(saveEndTime - saveStartTime);
            stats.processBeanSize(this.getBeanSize(beanState));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting("ReplicatedSFSBStoreManager", "passivateSave");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object id) {
        this.removeIdFromLocallyPassivatedCache(id);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering("ReplicatedSFSBStoreManager", "remove", id);
        }
        ReplicatedEjbStore store = null;
        try {
            store = this.getStore();
            store.remove(id);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.exiting("ReplicatedSFSBStoreManager", "remove");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.putStore(store);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting("ReplicatedSFSBStoreManager", "remove");
        }
    }

    public void removeAll() throws SFSBStoreManagerException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering("ReplicatedSFSBStoreManager", "removeAll", this.containerId);
        }
        StorePool storePool = this.getStorePool();
        ReplicatedEjbStore store = null;
        try {
            store = this.getStore();
            store.undeployContainer();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.exiting("ReplicatedSFSBStoreManager", "removeAll");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SFSBStoreManagerException("Error during ReplicatedSFSBStoreManager>>removeAll for container: " + this.containerId, e);
        }
        finally {
            ReplicationMessageRouter router = ReplicationMessageRouter.createInstance();
            if (router != null) {
                router.removeReplicationManager(this.getContainerID());
            }
            this.putStore(store);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting("ReplicatedSFSBStoreManager", "removeAll");
        }
    }

    public int removeExpiredSessions() throws SFSBStoreManagerException {
        this.removeExpiredFromLocallyPassivated();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering("ReplicatedSFSBStoreManager", "removeExpired", this.containerId);
        }
        int result = 0;
        StorePool storePool = this.getStorePool();
        ReplicatedEjbStore store = null;
        try {
            store = this.getStore();
            result = store.removeExpiredSessions();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.exiting("ReplicatedSFSBStoreManager", "removeExpired");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SFSBStoreManagerException("Error during ReplicatedSFSBStoreManager>>removeExpired for container: " + this.containerId, e);
        }
        finally {
            this.putStore(store);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting("ReplicatedSFSBStoreManager", "removeExpired");
        }
        return result;
    }

    public void updateLastAccessTime(Object sessionKey, long time) throws SFSBStoreManagerException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering("ReplicatedSFSBStoreManager", "updateLastAccessTime", sessionKey.toString());
        }
        StorePool storePool = this.getStorePool();
        ReplicatedEjbStore store = null;
        try {
            store = this.getStore();
            store.updateLastAccessTime(sessionKey, time);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.exiting("ReplicatedSFSBStoreManager", "updateLastAccessTime");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SFSBStoreManagerException("Error during ReplicatedSFSBStoreManager>>updateLastAccessTime for key: " + sessionKey + " errMsg: " + e.getMessage(), e);
        }
        finally {
            this.putStore(store);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting("ReplicatedSFSBStoreManager", "updateLastAccessTime");
        }
    }

    public void checkpointSave(SFSBBeanState[] beanStates) throws SFSBStoreManagerException {
        if (beanStates.length == 1) {
            this.checkpointSave(beanStates[0]);
            return;
        }
        EJBModuleStatistics stats = this.getEJBModuleStatistics();
        long startTime = 0L;
        Long[] originalTxCheckpointDurations = new Long[]{new Long(0L)};
        if (this.isMonitoringEnabled()) {
            originalTxCheckpointDurations = this.storeOriginalTxCheckpointDurations(beanStates);
            startTime = System.currentTimeMillis();
        }
        StorePool storePool = this.getStorePool();
        ReplicatedEjbStore store = null;
        try {
            store = this.getStore();
            store.save(beanStates, startTime);
            if (this.isMonitoringEnabled()) {
                for (int i = 0; i < beanStates.length; ++i) {
                    SFSBBeanState nextBeanState = beanStates[i];
                    stats.processBeanSize(this.getBeanSize(nextBeanState));
                }
            }
        }
        catch (IOException e) {
            if (this.isMonitoringEnabled()) {
                this.restoreOriginalTxCheckpointDurations(beanStates, originalTxCheckpointDurations);
            }
            throw new SFSBStoreManagerException("Error during checkpointSave", (Exception)e);
        }
        finally {
            this.putStore(store);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting("ReplicatedSFSBStoreManager", "checkpointSave");
        }
    }

    private Long[] storeOriginalTxCheckpointDurations(SFSBBeanState[] beanStates) {
        Long[] originalTxCheckpointDurations = new Long[beanStates.length];
        for (int i = 0; i < beanStates.length; ++i) {
            SFSBBeanState nextBeanState = beanStates[i];
            originalTxCheckpointDurations[i] = new Long(nextBeanState.getTxCheckpointDuration());
        }
        return originalTxCheckpointDurations;
    }

    private void restoreOriginalTxCheckpointDurations(SFSBBeanState[] beanStates, Long[] originalTxCheckpointDurations) {
        for (int i = 0; i < beanStates.length; ++i) {
            SFSBBeanState nextBeanState = beanStates[i];
            long originalDuration = originalTxCheckpointDurations[i];
            nextBeanState.setTxCheckpointDuration(originalDuration);
        }
    }

    private void printTxCheckpointDurations(SFSBBeanState[] beanStates) {
        System.out.println("Printing Checkpoint Durations");
        for (int i = 0; i < beanStates.length; ++i) {
            SFSBBeanState nextBeanState = beanStates[i];
            System.out.println("printTxCheckpointDurations for beanState[" + i + "]: " + nextBeanState.getTxCheckpointDuration());
        }
    }

    protected long getBeanSize(SFSBBeanState beanState) {
        if (beanState == null) {
            return 0L;
        }
        byte[] bytes = beanState.getState();
        if (bytes != null) {
            return bytes.length;
        }
        return 0L;
    }

    public void monitoringLevelChanged(boolean newValue) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentStoreSize() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering("ReplicatedSFSBStoreManager", "getCurrentStoreSize");
        }
        int result = 0;
        ReplicatedEjbStore store = null;
        try {
            store = this.getStore();
            result = store.getContainerSize();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.exiting("ReplicatedSFSBStoreManager", "getCurrentStoreSize");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.putStore(store);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting("ReplicatedSFSBStoreManager", "getCurrentStoreSize");
        }
        return result;
    }

    @Override
    public void repair(long repairStartTime) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicatedSFSBStoreManager>>repair");
        }
        if (ReplicationHealthChecker.isStopping()) {
            return;
        }
        SFSBBeanState[] beanStates = this.getLocallyPassivatedBeanStatesArray();
        for (int i = 0; i < beanStates.length; ++i) {
            SFSBBeanState beanState = beanStates[i];
            if (beanState.getLastAccess() > repairStartTime) continue;
            try {
                this.checkpointSave(beanState);
                continue;
            }
            catch (SFSBStoreManagerException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (Throwable t) {
                System.out.println("Throwable during force flush");
                t.printStackTrace();
                break;
            }
        }
    }

    @Override
    public void repair(long repairStartTime, boolean checkForStopping) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicatedSFSBStoreManager>>repair");
        }
        if (checkForStopping && ReplicationHealthChecker.isStopping()) {
            return;
        }
        SFSBBeanState[] beanStates = this.getLocallyPassivatedBeanStatesArray();
        for (int i = 0; i < beanStates.length; ++i) {
            SFSBBeanState beanState = beanStates[i];
            if (beanState.getLastAccess() > repairStartTime) continue;
            try {
                this.checkpointSave(beanState);
                continue;
            }
            catch (SFSBStoreManagerException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (Throwable t) {
                System.out.println("Throwable during force flush");
                break;
            }
        }
    }

    public SFSBBeanState[] getLocallyPassivatedBeanStatesArray() {
        BaseCache passivatedSessions = this.locallyPassivatedSessions;
        SFSBBeanState[] beanStates = null;
        int numberOfIds = passivatedSessions.getEntryCount();
        ArrayList<SFSBBeanState> valuesList = new ArrayList<SFSBBeanState>(numberOfIds);
        Iterator valuesIter = passivatedSessions.values();
        while (valuesIter.hasNext()) {
            valuesList.add((SFSBBeanState)valuesIter.next());
        }
        SFSBBeanState[] template = new SFSBBeanState[valuesList.size()];
        beanStates = valuesList.toArray(template);
        return beanStates;
    }

    public void removeExpiredFromLocallyPassivated() {
        SFSBBeanState nextBeanState;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicatedSFSBStoreManager>>removeExpiredFromLocallyPassivated");
        }
        ArrayList<SFSBBeanState> expiredLocallyPassivated = new ArrayList<SFSBBeanState>(30);
        BaseCache locallyPassivatedCache = this.getLocallyPassivatedSessions();
        Iterator it = locallyPassivatedCache.values();
        while (it.hasNext()) {
            nextBeanState = (SFSBBeanState)it.next();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicatedSFSBStoreManager>>removeExpiredFromLocallyPassivated:nextState=" + nextBeanState);
            }
            if (!this.isBeanExpired(nextBeanState)) continue;
            expiredLocallyPassivated.add(nextBeanState);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("removeExpiredFromLocallyPassivated:expiredReplicas.size=" + expiredLocallyPassivated.size());
        }
        for (int i = 0; i < expiredLocallyPassivated.size(); ++i) {
            nextBeanState = (SFSBBeanState)expiredLocallyPassivated.get(i);
            this.removeFromLocallyPassivatedCache(nextBeanState);
        }
    }

    private boolean isBeanExpired(SFSBBeanState beanState) {
        long timeAlive = System.currentTimeMillis() - beanState.getLastAccess();
        return timeAlive > (long)this.getIdleTimeoutInSeconds() * 1000L;
    }

    public void processValvesave(ReplicationState message) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN" + this.getClass().getName() + ">>processValvesave");
            _logger.fine("processValvesave:version:" + message.getVersion());
        }
        this.putInReplicationCache(message);
    }

    public void processRemove(ReplicationState message) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicatedSFSBStoreManager>>processRemove");
        }
        this.removeFromReplicationCache(message);
    }

    public void processRemoveExpired(ReplicationState message) {
        ReplicationState nextState;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicatedSFSBStoreManager>>processRemoveExpired");
        }
        ArrayList<ReplicationState> expiredReplicas = new ArrayList<ReplicationState>(30);
        BaseCache replicasCache = this.getReplicatedSessions();
        Iterator it = replicasCache.values();
        while (it.hasNext()) {
            nextState = (ReplicationState)it.next();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicatedSFSBStoreManager>>processRemoveExpired:nextState=" + nextState);
            }
            if (!nextState.isExpired()) continue;
            expiredReplicas.add(nextState);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("processRemoveExpired:expiredReplicas.size=" + expiredReplicas.size());
        }
        for (int i = 0; i < expiredReplicas.size(); ++i) {
            nextState = (ReplicationState)expiredReplicas.get(i);
            this.removeFromReplicationCache(nextState);
        }
    }

    public void processUpdateLastAccessTime(ReplicationState message) {
        ReplicationState cachedState;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in ReplicatedSFSBStoreManager>>processUpdateLastAccessTime");
        }
        if ((cachedState = this.getFromReplicationCache((String)message.getId())) != null) {
            cachedState.setLastAccess(message.getLastAccess());
        }
    }

    public ReplicationState processBroadcastfindsessionPrevious(ReplicationState queryState) {
        ReplicationState replicaState = this.findReplicatedState(queryState);
        ReplicationState returnState = null;
        if (replicaState != null) {
            returnState = ReplicationState.createQueryResponseFrom(replicaState);
        }
        return returnState;
    }

    public ReplicationState processBroadcastfindsession(ReplicationState queryState) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + this.getClass().getName() + ">>processBroadcastfindSession:instance: " + this.getInstanceName());
            _logger.fine("in " + this.getClass().getName() + ">>processBroadcastfindSession:id=" + queryState.getId());
        }
        ReplicationState replicaState = this.findReplicatedState(queryState);
        ReplicationState returnState = null;
        if (replicaState != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicatedSFSBStoreManager>>processBroadcastfindsession:REPLICA_FOUND:replicaStateVersion:" + replicaState.getVersion());
                _logger.fine("ReplicatedSFSBStoreManager>>processBroadcastfindsession:REPLICA_FOUND:replicaState:" + replicaState.getTrunkState());
                _logger.fine("ReplicatedSFSBStoreManager>>processBroadcastfindsession:REPLICA_FOUND:replicaAttrState" + replicaState.getState());
            }
            returnState = ReplicationState.createQueryResponseFrom(replicaState);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicatedSFSBStoreManager>>processBroadcastfindsession:replicaStateResponseVersion:" + returnState.getVersion());
            }
            this.clearFromPassivatedCache((String)queryState.getId());
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + this.getClass().getName() + ">>processBroadcastfindSession:returnState=" + returnState);
        }
        return returnState;
    }

    protected ReplicationState findReplicatedState(ReplicationState queryState) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("findReplicatedState:id = " + queryState.getId());
        }
        return this.getFromReplicationCache((String)queryState.getId());
    }

    protected void clearFromPassivatedCache(String id) {
        SFSBBeanState beanState = this.getFromLocallyPassivatedCache(id);
        if (beanState != null) {
            this.removeFromLocallyPassivatedCache(beanState);
        }
    }

    @Override
    public void processMessage(ReplicationState message) {
        if (ReplicationState.isBroadcastState(message)) {
            this.processBroadcastMessage(message);
            return;
        }
        ReplicationState response = ReplicationState.createResponseFrom(message);
        boolean isResponse = this.doProcessMessage(message);
        if (!isResponse && !message.isVoidMethodReturnState()) {
            try {
                this.doSendResponse(response);
            }
            catch (SFSBStoreManagerException ex) {
                // empty catch block
            }
        }
    }

    public boolean doProcessMessage(ReplicationState message) {
        boolean result = false;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in ReplicatedSFSBStoreManager>>doProcessMessage");
        }
        String methodName = this.getProcessMethodName(message);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in ReplicatedSFSBStoreManager>>doProcessMessage:methodName=" + methodName);
        }
        try {
            Class<?> myClass = this.getClass();
            myClass.getMethod(methodName, message.getClass()).invoke((Object)this, message);
        }
        catch (IllegalAccessException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in ReplicatedSFSBStoreManager>>doProcessMessage:methodName=" + methodName + "illegalAccessException");
            }
        }
        catch (NoSuchMethodException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in ReplicatedSFSBStoreManager>>doProcessMessage:methodName=" + methodName + "noSuchMethodException");
            }
        }
        catch (InvocationTargetException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in ReplicatedSFSBStoreManager>>doProcessMessage:methodName=" + methodName + "invocationTargetException");
                _logger.fine("invocationException.getCause()= " + ex.getCause());
            }
            ex.printStackTrace();
        }
        if (methodName.equals("processResponse")) {
            result = true;
        }
        return result;
    }

    private String getProcessMethodName(ReplicationState message) {
        String command = message.getCommand();
        return "process" + this.camelCase(command);
    }

    private String camelCase(String inputString) {
        String strippedString = this.stripNonAlphas(inputString);
        String firstLetter = strippedString.substring(0, 1).toUpperCase();
        String remainingPart = strippedString.substring(1, strippedString.length()).toLowerCase();
        return firstLetter + remainingPart;
    }

    private String stripNonAlphas(String inputString) {
        StringBuffer sb = new StringBuffer(50);
        for (int i = 0; i < inputString.length(); ++i) {
            char nextChar = inputString.charAt(i);
            if (!Character.isLetter(nextChar)) continue;
            sb.append(nextChar);
        }
        return sb.toString();
    }

    public void processResponse(ReplicationState message) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in ReplicationWebEventPersistentManager>>processResponse");
        }
        ReplicationResponseRepository.putEntry(message);
    }

    public ReplicationState processBroadcastresponse(ReplicationState queryResponseState) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in " + this.getClass().getName() + ">>processBroadcastresponse:queryResponseState=" + queryResponseState);
        }
        ReplicationResponseRepository.putFederatedEntry(queryResponseState);
        return queryResponseState;
    }

    public void processBroadcastMessage(ReplicationState message) {
        ReplicationStateQueryResponse response = this.doProcessQueryMessage(message);
        boolean isResponse = response.isResponse();
        ReplicationState responseState = response.getState();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("processBroadcastMessage:after doProcessQueryMessage:response=" + isResponse);
            _logger.fine("processBroadcastMessage:after doProcessQueryMessage:responseState=" + responseState);
        }
        if (!isResponse) {
            try {
                this.doSendQueryResponse(responseState, this.getInstanceName());
            }
            catch (SFSBStoreManagerException ex) {
                // empty catch block
            }
        }
    }

    @Override
    public void processQueryMessage(ReplicationState message, String returnInstance) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicatedSFSBStoreManager>>processQueryMessage:returnInstance= " + returnInstance);
        }
        ReplicationStateQueryResponse response = this.doProcessQueryMessage(message);
        boolean isResponse = response.isResponse();
        ReplicationState responseState = response.getState();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("processQueryMessage:after doProcessQueryMessage:response=" + isResponse);
            _logger.fine("processQueryMessage:after doProcessQueryMessage:responseState=" + responseState);
        }
        if (!isResponse && responseState != null) {
            try {
                this.doSendQueryResponse(responseState, returnInstance);
            }
            catch (SFSBStoreManagerException ex) {
                // empty catch block
            }
        }
    }

    public ReplicationStateQueryResponse doProcessQueryMessage(ReplicationState message) {
        ReplicationState resultState = null;
        String methodName = this.getProcessMethodName(message);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("in ReplicatedSFSBStoreManager>>doProcessQueryMessage:methodName=" + methodName);
        }
        try {
            Class<?> myClass = this.getClass();
            resultState = (ReplicationState)myClass.getMethod(methodName, message.getClass()).invoke((Object)this, message);
        }
        catch (IllegalAccessException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in ReplicatedSFSBStoreManager>>doProcessQueryMessage:methodName=" + methodName + "illegalAccessException");
            }
        }
        catch (NoSuchMethodException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in ReplicatedSFSBStoreManager>>doProcessQueryMessage:methodName=" + methodName + "noSuchMethodException");
            }
        }
        catch (InvocationTargetException ex) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("in ReplicatedSFSBStoreManager>>doProcessQueryMessage:methodName=" + methodName + "invocationTargetException");
                _logger.fine("invocationException.getCause()= " + ex.getCause());
            }
            ex.printStackTrace();
        }
        boolean isResponse = methodName.equals("processBroadcastresponse");
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationWebEventPresistentManager>>doProcessQueryMessage:resultState=" + resultState);
        }
        return new ReplicationStateQueryResponse(resultState, isResponse);
    }

    public void doSendResponse(ReplicationState sessionState) throws SFSBStoreManagerException {
        StorePool storePool = this.getStorePool();
        ReplicatedEjbStore store = null;
        try {
            store = this.getStore();
            store.sendResponse(sessionState);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.exiting("ReplicatedSFSBStoreManager", "doSendResponse");
            }
        }
        catch (Exception e) {
            throw new SFSBStoreManagerException("Error sending ReplicationState response: id =" + sessionState.getId().toString(), e);
        }
        finally {
            this.putStore(store);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.exiting("ReplicatedSFSBStoreManager", "doSendResponse");
            }
        }
    }

    public void doSendQueryResponse(ReplicationState sessionState, String instanceName) throws SFSBStoreManagerException {
        StorePool storePool = this.getStorePool();
        ReplicatedEjbStore store = null;
        try {
            store = this.getStore();
            store.sendQueryResponse(sessionState, instanceName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.exiting("ReplicatedSFSBStoreManager", "doSendQueryResponse");
            }
        }
        catch (Exception e) {
            throw new SFSBStoreManagerException("Error sending ReplicationState query response: id =" + sessionState.getId().toString(), e);
        }
        finally {
            this.putStore(store);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.exiting("ReplicatedSFSBStoreManager", "doSendQueryResponse");
            }
        }
    }

    @Override
    public void appendStats(StringBuffer sb) {
        EJBModuleStatistics stats = this.getEJBModuleStatistics();
        sb.append("\nSAVE_LOW=" + stats.getSaveLow());
        sb.append("\nSAVE_HIGH=" + stats.getSaveHigh());
        sb.append("\nSAVE_AVG=" + stats.getSaveAverage());
        sb.append("\nPASSIVATE_SAVE_LOW=" + stats.getPassivateSaveLow());
        sb.append("\nPASSIVATE_SAVE_HIGH=" + stats.getPassivateSaveHigh());
        sb.append("\nPASSIVATE_SAVE_AVG=" + stats.getPassivateSaveAverage());
        sb.append("\nCHECKPOINT_SAVE_LOW=" + stats.getCheckpointSaveLow());
        sb.append("\nCHECKPOINT_SAVE_HIGH=" + stats.getCheckpointSaveHigh());
        sb.append("\nCHECKPOINT_SAVE_AVG=" + stats.getCheckpointSaveAverage());
        sb.append("\nBEAN_SIZE_LOW=" + stats.getBeanSizeLow());
        sb.append("\nBEAN_SIZE_HIGH=" + stats.getBeanSizeHigh());
        sb.append("\nBEAN_SIZE_AVG=" + stats.getBeanSizeAverage());
        stats.resetStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushAllIdsFromCurrentMap(boolean waitForAck) {
        Map<String, String> oldKeysMap = null;
        oldKeysMap = this.removedKeysMap;
        this.removedKeysMap = new ConcurrentHashMap<String, String>();
        this.timeToChange.set(false);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(">>ReplicationSFSBStoreManager::flushAllIds: " + oldKeysMap.size());
        }
        ArrayList<String> list = new ArrayList<String>(oldKeysMap.size() + 1);
        Iterator<String> iter = oldKeysMap.keySet().iterator();
        boolean totalMessageSize = false;
        while (iter.hasNext()) {
            String nextString = iter.next();
            list.add(nextString);
        }
        if (list.size() > 0) {
            this.createRemoveIdsMessageAndSend(list, waitForAck, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRemoveIdsMessageAndSend(List<String> list, boolean waitForAck, Object signalObject) {
        byte[] data = null;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            oos.writeObject(list);
            oos.flush();
        }
        catch (IOException ioEx) {
        }
        finally {
            if (oos != null) {
                try {
                    oos.flush();
                    oos.close();
                }
                catch (Exception ex) {}
            }
            if (bos != null) {
                try {
                    bos.flush();
                    data = bos.toByteArray();
                    bos.close();
                }
                catch (Exception ex) {}
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("<<ReplicationWebEventPersistentManager::createRemoveAllMessageAndSend: About to send " + data.length + " bytes...");
        }
        this.removeIds(_messageIDCounter++, list.size(), data, signalObject);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("<<ReplicationWebEventPersistentManager::createRemoveAllMessageAndSend: DONE!!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeIds(long msgID, int totalStates, byte[] removedIdsData, Object signalObject) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.entering("ReplicatedSFSBStoreManager", "removeIds");
        }
        ReplicatedEjbStore store = null;
        try {
            store = this.getStore();
            store.removeIds(msgID, removedIdsData);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.exiting("ReplicatedSFSBStoreManager", "removeIds");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.putStore(store);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.exiting("ReplicatedSFSBStoreManager", "removeIds");
        }
    }

    public void processRemoveids(ReplicationState message) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("IN" + this.getClass().getName() + ">>processRemoveids");
        }
        byte[] idsToRemoveState = message.getState();
        List removedIdsList = new ArrayList();
        try {
            removedIdsList = (List)ReplicationState.getObjectValue(idsToRemoveState);
        }
        catch (Exception ex) {
            // empty catch block
        }
        for (int i = 0; i < removedIdsList.size(); ++i) {
            String nextIdToRemove = (String)removedIdsList.get(i);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(">>processRemoveids:nextIdToRemove=" + nextIdToRemove);
            }
            this.replicatedSessions.remove((Object)nextIdToRemove);
        }
    }

    static {
        ReplicatedSFSBStoreManager.checkSessionCacheProperties();
        NUMBER_OF_REQUESTS_BEFORE_FLUSH = 1000;
        requestCounter = new AtomicInteger(0);
        _messageIDCounter = 0;
    }

    private class DispatchThread
    implements Runnable {
        private volatile boolean done = false;
        private Thread thread;
        private LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue();

        public DispatchThread() {
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }

        public void wakeup() {
            this.queue.add(new Object());
        }

        public void run() {
            while (!this.done) {
                try {
                    Object ignorableToken = this.queue.take();
                    ReplicatedSFSBStoreManager.this.flushAllIdsFromCurrentMap(false);
                }
                catch (InterruptedException inEx) {
                    this.done = true;
                }
            }
        }
    }
}

