/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.ee.timer.lifecycle;

import com.sun.ejb.spi.distributed.DistributedEJBServiceFactory;
import com.sun.ejb.spi.distributed.DistributedReadOnlyBeanNotifier;
import com.sun.ejb.spi.distributed.DistributedReadOnlyBeanService;
import com.sun.enterprise.ee.cms.core.Action;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.MessageAction;
import com.sun.enterprise.ee.cms.core.MessageActionFactory;
import com.sun.enterprise.ee.cms.core.MessageSignal;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

class ReadOnlyBeanMessageActionFactoryImpl
implements MessageActionFactory,
DistributedReadOnlyBeanNotifier {
    protected static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.ejb");
    private static DistributedReadOnlyBeanService _readOnlyBeanService = DistributedEJBServiceFactory.getDistributedEJBService().getDistributedReadOnlyBeanService();
    private GroupManagementService gms;
    private String componentName;

    ReadOnlyBeanMessageActionFactoryImpl(GroupManagementService gms, String componentName) {
        this.gms = gms;
        this.componentName = componentName;
        _readOnlyBeanService.setDistributedReadOnlyBeanNotifier((DistributedReadOnlyBeanNotifier)this);
    }

    public Action produceAction() {
        return new MessageAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void consumeSignal(Signal signal) {
                try {
                    signal.acquire();
                    MessageSignal messageSignal = (MessageSignal)signal;
                    byte[] payload = messageSignal.getMessage();
                    int size = payload.length;
                    long ejbID = ReadOnlyBeanMessageActionFactoryImpl.bytesToLong(payload, 0);
                    if (size == 8) {
                        _logger.log(Level.WARNING, "ReadOnlyBeanMessageActionFactoryImpl:  Got message for ejbID: " + ejbID);
                        _readOnlyBeanService.handleRefreshAllRequest(ejbID);
                    } else {
                        byte[] pkData = new byte[size - 8];
                        System.arraycopy(payload, 8, pkData, 0, pkData.length);
                        _readOnlyBeanService.handleRefreshRequest(ejbID, pkData);
                        _logger.log(Level.WARNING, "ReadOnlyBeanMessageActionFactoryImpl:  Handled message for ejbID: " + ejbID);
                    }
                }
                catch (Exception ex) {
                    _logger.log(Level.WARNING, "ReadOnlyBeanMessageActionFactoryImpl: Got exception while handling message", ex);
                }
                finally {
                    try {
                        signal.release();
                    }
                    catch (Exception ex) {
                        _logger.log(Level.WARNING, "ReadOnlyBeanMessageActionFactoryImpl: Got exception while releasing signal", ex);
                    }
                }
            }
        };
    }

    public void notifyRefresh(long ejbID, byte[] pk) {
        int size = pk.length;
        byte[] payload = new byte[size + 8];
        ReadOnlyBeanMessageActionFactoryImpl.longToBytes(ejbID, payload, 0);
        System.arraycopy(pk, 0, payload, 8, size);
        try {
            this.gms.getGroupHandle().sendMessage(this.componentName, payload);
            _logger.log(Level.WARNING, "ReadOnlyBeanMessageActionFactoryImpl:  Sent message for ejbID: " + ejbID);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ReadOnlyBeanMessageActionFactoryImpl: Got exception during notifyRefresh", ex);
        }
    }

    public void notifyRefreshAll(long ejbID) {
        byte[] payload = new byte[8];
        ReadOnlyBeanMessageActionFactoryImpl.longToBytes(ejbID, payload, 0);
        try {
            this.gms.getGroupHandle().sendMessage(this.componentName, payload);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "ReadOnlyBeanMessageActionFactoryImpl: Got exception during notifyRefreshAll", ex);
        }
    }

    private static void longToBytes(long value, byte[] array, int offset) {
        array[offset] = (byte)(value >>> 56 & 0xFFL);
        array[offset + 1] = (byte)(value >>> 48 & 0xFFL);
        array[offset + 2] = (byte)(value >>> 40 & 0xFFL);
        array[offset + 3] = (byte)(value >>> 32 & 0xFFL);
        array[offset + 4] = (byte)(value >>> 24 & 0xFFL);
        array[offset + 5] = (byte)(value >>> 16 & 0xFFL);
        array[offset + 6] = (byte)(value >>> 8 & 0xFFL);
        array[offset + 7] = (byte)(value >>> 0 & 0xFFL);
    }

    private static long bytesToLong(byte[] array, int offset) {
        long l1 = (long)ReadOnlyBeanMessageActionFactoryImpl.bytesToInt(array, offset) << 32;
        long l2 = (long)ReadOnlyBeanMessageActionFactoryImpl.bytesToInt(array, offset + 4) & 0xFFFFFFFFL;
        return l1 | l2;
    }

    private static int bytesToInt(byte[] array, int offset) {
        int b1 = array[offset] << 24 & 0xFF000000;
        int b2 = array[offset + 1] << 16 & 0xFF0000;
        int b3 = array[offset + 2] << 8 & 0xFF00;
        int b4 = array[offset + 3] << 0 & 0xFF;
        return b1 | b2 | b3 | b4;
    }
}

