/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.clientreg;

import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.ee.admin.clientreg.InstanceRegistry;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class RegistrySynchronizer
implements NotificationListener {
    private static final StringManager _strMgr = StringManager.getManager(RegistrySynchronizer.class);
    private static final String[] types = new String[]{"cluster.health.INSTANCE_STARTED_EVENT", "cluster.health.INSTANCE_STOPPED_EVENT", "cluster.health.INSTANCE_FAILED_EVENT"};
    private static Logger _logger = null;

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("ShoalLogger");
        }
        return _logger;
    }

    public void handleNotification(Notification notif, Object handback) {
        try {
            ObjectName objectName = (ObjectName)notif.getSource();
            String serverName = (String)notif.getUserData();
            String type = notif.getType();
            if (type.equals(types[0])) {
                this.instanceStarted(serverName);
            } else if (type.equals(types[1])) {
                this.instanceStopped(serverName);
            } else if (type.equals(types[1])) {
                this.instanceFailed(serverName);
            }
        }
        catch (Exception e) {
            RegistrySynchronizer.getLogger().log(Level.WARNING, "RegistrySynchronizer : handleNotification failed");
        }
    }

    private void instanceStarted(String serverName) {
        try {
            InstanceRegistry instanceRegistry = InstanceRegistry.getInstanceRegistry();
            InstanceRegistry.getInstanceConnection(serverName);
        }
        catch (InstanceException ex) {
            RegistrySynchronizer.getLogger().log(Level.WARNING, _strMgr.getString("gms.activeMngtFailedForServer", (Object)serverName));
        }
    }

    private void instanceStopped(String serverName) {
    }

    private void instanceFailed(String serverName) {
        try {
            InstanceRegistry instanceRegistry = InstanceRegistry.getInstanceRegistry();
            InstanceRegistry.removeInstanceConnection(serverName);
        }
        catch (InstanceException ex) {
            RegistrySynchronizer.getLogger().log(Level.WARNING, _strMgr.getString("gms.activeMngtFailed", (Object)serverName));
        }
    }
}

